/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skia.icu.CharProperties;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u001c\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a \u0010\u0013\u001a\u00060\u0001j\u0002`\u0014*\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u0017*\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u0001*\u00060\u0001j\u0002`\u0014H\u0000\u001a\u001e\u0010!\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u00140\u001e*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\"\u001a\u00060\u0001j\u0002`\u0014*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010#\u001a\u00060\u0001j\u0002`\u0014*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\f\u0010$\u001a\u00020\u0001*\u00020\u000bH\u0000\u001a\u0018\u0010%\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0002H\u0000\u001a\u0014\u0010'\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\f\u0010(\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010)\u001a\u00020\u0006*\u00060\u0001j\u0002`\u0014H\u0002\u001a\u0010\u0010*\u001a\u00020\u0006*\u00060\u0001j\u0002`\u0014H\u0002\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\"\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u00140\u001e*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 *\f\b\u0000\u0010\u0012\"\u00020\u00012\u00020\u0001\u00a8\u0006+"}, d2={"findPrecedingBreak", "", "", "index", "findFollowingBreak", "isSurrogatePair", "", "high", "", "low", "offsetByCodePoints", "", "offset", "findCodePointOrEmojiStartBefore", "ifNotFound", "EMOJI_PRESENTATION_SELECTOR", "canBeEmojiOrPictographic", "text", "CodePoint", "toCodePoint", "Landroidx/compose/foundation/text/CodePoint;", "Lkotlin/Char$Companion;", "appendCodePoint", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "codePoint", "MIN_SUPPLEMENTARY_CODE_POINT", "charCount", "codePoints", "Lkotlin/sequences/Sequence;", "getCodePoints", "(Ljava/lang/String;)Lkotlin/sequences/Sequence;", "codePointsAt", "codePointAt", "codePointBefore", "codePointCount", "findNextNonWhitespaceSymbolsSubsequenceStartOffset", "currentText", "isWhitespaceOrPunctuation", "midpointPositionWithUnicodeSymbols", "isWhitespace", "isPunctuation", "foundation"})
public final class StringHelpers_skikoKt {
    private static final int EMOJI_PRESENTATION_SELECTOR = 65039;
    private static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;

    public static final int findPrecedingBreak(String string, int n2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        BreakIterator breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
        breakIterator.setText(string);
        return breakIterator.preceding(n2);
    }

    public static final int findFollowingBreak(String string, int n2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        BreakIterator breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
        breakIterator.setText(string);
        return breakIterator.following(n2);
    }

    private static final boolean isSurrogatePair(char c2, char c3) {
        return Character.isHighSurrogate(c2) && Character.isLowSurrogate(c3);
    }

    public static final int offsetByCodePoints(CharSequence charSequence, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        int n4 = MathKt.getSign((int)n3);
        n3 = Math.abs(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2;
            if ((n2 += n4) <= 0) {
                return 0;
            }
            if (n2 >= charSequence.length()) {
                return charSequence.length();
            }
            char c3 = charSequence.charAt(n2 - 1);
            if (!StringHelpers_skikoKt.isSurrogatePair(c3, c2 = charSequence.charAt(n2))) continue;
            n2 += n4;
        }
        return n2;
    }

    public static final int findCodePointOrEmojiStartBefore(String string, int n2, int n3) {
        int n4;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (n2 <= 0) {
            return -1;
        }
        n3 = StringHelpers_skikoKt.findPrecedingBreak(string, n2);
        if (n3 == (n4 = StringHelpers_skikoKt.offsetByCodePoints(string, n2, -1))) {
            return n4;
        }
        String string2 = string.substring(n3, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        string = string2;
        if (StringHelpers_skikoKt.canBeEmojiOrPictographic(string2)) {
            return n3;
        }
        return n4;
    }

    private static final boolean canBeEmojiOrPictographic(String object) {
        object = StringHelpers_skikoKt.getCodePoints((String)object).iterator();
        while (object.hasNext()) {
            CharProperties charProperties = CharProperties.INSTANCE;
            int n2 = ((Number)object.next()).intValue();
            if (!charProperties.codePointHasBinaryProperty(n2, 58) && !charProperties.codePointHasBinaryProperty(n2, 64) && n2 != 65039) continue;
            return true;
        }
        return false;
    }

    public static final int toCodePoint(CharCompanionObject charCompanionObject, char c2, char c3) {
        Intrinsics.checkNotNullParameter((Object)charCompanionObject, (String)"");
        return (c2 - 55296 << 10 | c3 - 56320) + 65536;
    }

    public static final void appendCodePoint(StringBuilder stringBuilder, int n2) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        if (n2 < 65536) {
            stringBuilder.append((char)n2);
            return;
        }
        stringBuilder.append((char)(55296 + (n2 - 65536 >> 10)));
        stringBuilder.append((char)(56320 + (n2 & 0x3FF)));
    }

    public static final int charCount(int n2) {
        if (n2 >= 65536) {
            return 2;
        }
        return 1;
    }

    public static final Sequence<Integer> getCodePoints(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return StringHelpers_skikoKt.codePointsAt(string, 0);
    }

    public static final Sequence<Integer> codePointsAt(String string, int n2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object>(n2, string, null){
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $index;
            final /* synthetic */ String $this_codePointsAt;
            {
                this.$index = n2;
                this.$this_codePointsAt = string;
                super(2, continuation);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = (SequenceScope)this.L$0;
                        var3_4 = this.$index;
lbl7:
                        // 2 sources

                        while (var3_4 < this.$this_codePointsAt.length()) {
                            var4_5 = StringHelpers_skikoKt.codePointAt(this.$this_codePointsAt, var3_4);
                            this.L$0 = var2_3;
                            this.I$0 = var3_4;
                            this.I$1 = var4_5;
                            this.label = 1;
                            if (var2_3.yield((Object)Boxing.boxInt((int)var4_5), (Continuation)this) == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        var4_5 = this.I$1;
                        var3_4 = this.I$0;
                        var2_3 = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)var1_1);
lbl22:
                        // 2 sources

                        var3_4 += StringHelpers_skikoKt.charCount(var4_5);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> object2) {
                object2 = new /* invalid duplicate definition of identical inner class */;
                v0.L$0 = object;
                return object2;
            }

            public final Object invoke(SequenceScope<? super Integer> sequenceScope, Continuation<? super Unit> continuation) {
                return (this.create(sequenceScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final int codePointAt(CharSequence charSequence, int n2) {
        char c2;
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        char c3 = charSequence.charAt(n2);
        if (Character.isHighSurrogate(c3) && n2 + 1 < charSequence.length() && Character.isLowSurrogate(c2 = charSequence.charAt(n2 + 1))) {
            return StringHelpers_skikoKt.toCodePoint(CharCompanionObject.INSTANCE, c3, c2);
        }
        return c3;
    }

    public static final int codePointBefore(CharSequence charSequence, int n2) {
        char c2;
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        char c3 = charSequence.charAt(n2);
        if (Character.isLowSurrogate(c3) && n2 - 1 >= 0 && Character.isHighSurrogate(c2 = charSequence.charAt(n2 - 1))) {
            return StringHelpers_skikoKt.toCodePoint(CharCompanionObject.INSTANCE, c2, c3);
        }
        return c3;
    }

    public static final int codePointCount(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < charSequence.length() - 1) {
            if (Character.isHighSurrogate(charSequence.charAt(n3)) && Character.isLowSurrogate(charSequence.charAt(n3 + 1))) {
                --n2;
                n3 += 2;
                continue;
            }
            ++n3;
        }
        return n2;
    }

    public static final int findNextNonWhitespaceSymbolsSubsequenceStartOffset(int n2, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        BreakIterator breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
        breakIterator.setText(string);
        int n3 = breakIterator.next();
        while (n3 < n2) {
            n3 = breakIterator.next();
        }
        n2 = n3;
        n3 = breakIterator.next();
        while (n3 < string.length()) {
            if (StringHelpers_skikoKt.isWhitespace(StringHelpers_skikoKt.codePointAt(string, n2)) && !StringHelpers_skikoKt.isWhitespace(StringHelpers_skikoKt.codePointAt(string, n3))) {
                return n3;
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        return n2;
    }

    public static final boolean isWhitespaceOrPunctuation(String string, int n2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n3 = StringHelpers_skikoKt.codePointAt(string, n2);
        return StringHelpers_skikoKt.isPunctuation(n3) || StringHelpers_skikoKt.isWhitespace(n3);
    }

    public static final int midpointPositionWithUnicodeSymbols(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n2 = SequencesKt.count(StringHelpers_skikoKt.getCodePoints(string));
        BreakIterator breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
        breakIterator.setText(string);
        int n3 = 0;
        int n4 = 0;
        if ((n2 /= 2) >= 0) {
            while (true) {
                n3 = breakIterator.next();
                if (n4 == n2) break;
                ++n4;
            }
        }
        return n3;
    }

    private static final boolean isWhitespace(int n2) {
        if (StringHelpers_skikoKt.charCount(n2) != 1) {
            return false;
        }
        return CharsKt.isWhitespace((char)((char)n2));
    }

    private static final boolean isPunctuation(int n2) {
        if (StringHelpers_skikoKt.charCount(n2) != 1) {
            return false;
        }
        Object[] objectArray = new CharCategory[7];
        Object object = objectArray;
        objectArray[0] = CharCategory.DASH_PUNCTUATION;
        object[1] = CharCategory.START_PUNCTUATION;
        object[2] = CharCategory.END_PUNCTUATION;
        object[3] = CharCategory.CONNECTOR_PUNCTUATION;
        object[4] = CharCategory.OTHER_PUNCTUATION;
        object[5] = CharCategory.INITIAL_QUOTE_PUNCTUATION;
        object[6] = CharCategory.FINAL_QUOTE_PUNCTUATION;
        object = SetsKt.setOf((Object[])object);
        if (!((object = (Iterable)object) instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (!(object2 = (CharCategory)object2).contains((char)n2)) continue;
                return true;
            }
        }
        return false;
    }
}

