/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpRequest
extends DefaultHttpRequest
implements FullHttpRequest {
    private final ByteBuf content;
    private final HttpHeaders trailingHeader;
    private int hash;

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string) {
        this(httpVersion, httpMethod, string, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf) {
        this(httpVersion, httpMethod, string, byteBuf, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    @Deprecated
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, boolean bl) {
        this(httpVersion, httpMethod, string, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory().withValidation(bl), DefaultHttpHeadersFactory.trailersFactory().withValidation(bl));
    }

    @Deprecated
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, boolean bl) {
        this(httpVersion, httpMethod, string, byteBuf, DefaultHttpHeadersFactory.headersFactory().withValidation(bl), DefaultHttpHeadersFactory.trailersFactory().withValidation(bl));
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, HttpHeadersFactory httpHeadersFactory, HttpHeadersFactory httpHeadersFactory2) {
        this(httpVersion, httpMethod, string, byteBuf, httpHeadersFactory.newHeaders(), httpHeadersFactory2.newHeaders());
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, HttpHeaders httpHeaders, HttpHeaders httpHeaders2) {
        super(httpVersion, httpMethod, string, httpHeaders);
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"content");
        this.trailingHeader = (HttpHeaders)ObjectUtil.checkNotNull((Object)httpHeaders2, (String)"trailingHeader");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeader;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpRequest retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullHttpRequest retain(int n) {
        this.content.retain(n);
        return this;
    }

    @Override
    public FullHttpRequest touch() {
        this.content.touch();
        return this;
    }

    @Override
    public FullHttpRequest touch(Object object) {
        this.content.touch(object);
        return this;
    }

    public boolean release() {
        return this.content.release();
    }

    public boolean release(int n) {
        return this.content.release(n);
    }

    @Override
    public FullHttpRequest setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    @Override
    public FullHttpRequest setMethod(HttpMethod httpMethod) {
        super.setMethod(httpMethod);
        return this;
    }

    @Override
    public FullHttpRequest setUri(String string) {
        super.setUri(string);
        return this;
    }

    @Override
    public FullHttpRequest copy() {
        DefaultFullHttpRequest defaultFullHttpRequest = this;
        return defaultFullHttpRequest.replace(defaultFullHttpRequest.content().copy());
    }

    @Override
    public FullHttpRequest duplicate() {
        DefaultFullHttpRequest defaultFullHttpRequest = this;
        return defaultFullHttpRequest.replace(defaultFullHttpRequest.content().duplicate());
    }

    @Override
    public FullHttpRequest retainedDuplicate() {
        DefaultFullHttpRequest defaultFullHttpRequest = this;
        return defaultFullHttpRequest.replace(defaultFullHttpRequest.content().retainedDuplicate());
    }

    @Override
    public FullHttpRequest replace(ByteBuf object) {
        object = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), (ByteBuf)object, this.headers().copy(), this.trailingHeaders().copy());
        object.setDecoderResult(this.decoderResult());
        return object;
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            if (ByteBufUtil.isAccessible((ByteBuf)this.content())) {
                try {
                    n = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {}
            }
            n = 31;
            n = n * 31 + this.trailingHeaders().hashCode();
            this.hash = n = n * 31 + super.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultFullHttpRequest)) {
            return false;
        }
        return super.equals(object = (DefaultFullHttpRequest)object) && this.content().equals((Object)((DefaultFullHttpRequest)object).content()) && this.trailingHeaders().equals(((DefaultFullHttpRequest)object).trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
    }
}

