/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public final class HttpClientCodec
extends CombinedChannelDuplexHandler<HttpResponseDecoder, HttpRequestEncoder>
implements HttpClientUpgradeHandler.SourceCodec {
    public static final boolean DEFAULT_FAIL_ON_MISSING_RESPONSE = false;
    public static final boolean DEFAULT_PARSE_HTTP_AFTER_CONNECT_REQUEST = false;
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();
    private final boolean parseHttpAfterConnectRequest;
    private boolean done;
    private final AtomicLong requestResponseCounter = new AtomicLong();
    private final boolean failOnMissingResponse;

    public HttpClientCodec() {
        this(new HttpDecoderConfig(), false, false);
    }

    public HttpClientCodec(int n, int n2, int n3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3), false, false);
    }

    public HttpClientCodec(int n, int n2, int n3, boolean bl) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3), false, bl);
    }

    @Deprecated
    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl2), false, bl);
    }

    @Deprecated
    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl2), bl3, bl);
    }

    @Deprecated
    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl2).setInitialBufferSize(n4), false, bl);
    }

    @Deprecated
    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl2).setInitialBufferSize(n4), bl3, bl);
    }

    @Deprecated
    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl2).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl4), bl3, bl);
    }

    @Deprecated
    public HttpClientCodec(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4, boolean bl5) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setValidateHeaders(bl2).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl4).setAllowPartialChunks(bl5), bl3, bl);
    }

    public HttpClientCodec(HttpDecoderConfig httpDecoderConfig, boolean bl, boolean bl2) {
        this.init((ChannelInboundHandler)new Decoder(httpDecoderConfig), (ChannelOutboundHandler)new Encoder());
        this.parseHttpAfterConnectRequest = bl;
        this.failOnMissingResponse = bl2;
    }

    @Override
    public final void prepareUpgradeFrom(ChannelHandlerContext channelHandlerContext) {
        ((Encoder)this.outboundHandler()).upgraded = true;
    }

    @Override
    public final void upgradeFrom(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext = channelHandlerContext.pipeline();
        channelHandlerContext.remove((ChannelHandler)this);
    }

    public final void setSingleDecode(boolean bl) {
        ((HttpResponseDecoder)this.inboundHandler()).setSingleDecode(bl);
    }

    public final boolean isSingleDecode() {
        return ((HttpResponseDecoder)this.inboundHandler()).isSingleDecode();
    }

    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(HttpDecoderConfig httpDecoderConfig) {
            super(httpDecoderConfig);
        }

        @Override
        protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            if (HttpClientCodec.this.done) {
                int n = this.actualReadableBytes();
                if (n == 0) {
                    return;
                }
                list.add(byteBuf.readBytes(n));
                return;
            }
            int n = list.size();
            super.decode(channelHandlerContext, byteBuf, list);
            if (HttpClientCodec.this.failOnMissingResponse) {
                int n2 = list.size();
                for (int i = n; i < n2; ++i) {
                    this.decrement(list.get(i));
                }
            }
        }

        private void decrement(Object object) {
            if (object == null) {
                return;
            }
            if (object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            }
        }

        @Override
        protected final boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
            HttpMethod httpMethod = (HttpMethod)HttpClientCodec.this.queue.poll();
            HttpResponseStatus httpResponseStatus = ((HttpResponse)httpMessage).status();
            HttpStatusClass httpStatusClass = httpResponseStatus.codeClass();
            int n = httpResponseStatus.code();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL) {
                return super.isContentAlwaysEmpty(httpMessage);
            }
            if (httpMethod != null) {
                char c = httpMethod.name().charAt(0);
                switch (c) {
                    case 'H': {
                        if (!HttpMethod.HEAD.equals(httpMethod)) break;
                        return true;
                    }
                    case 'C': {
                        if (n != 200 || !HttpMethod.CONNECT.equals(httpMethod)) break;
                        if (!HttpClientCodec.this.parseHttpAfterConnectRequest) {
                            HttpClientCodec.this.done = true;
                            HttpClientCodec.this.queue.clear();
                        }
                        return true;
                    }
                }
            }
            return super.isContentAlwaysEmpty(httpMessage);
        }

        public final void channelInactive(ChannelHandlerContext channelHandlerContext) {
            long l;
            super.channelInactive(channelHandlerContext);
            if (HttpClientCodec.this.failOnMissingResponse && (l = HttpClientCodec.this.requestResponseCounter.get()) > 0L) {
                channelHandlerContext.fireExceptionCaught((Throwable)new PrematureChannelClosureException("channel gone inactive with " + l + " missing response(s)"));
            }
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        boolean upgraded;

        private Encoder() {
        }

        @Override
        protected final void encode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) {
            if (this.upgraded) {
                list.add(object);
                return;
            }
            if (object instanceof HttpRequest) {
                HttpClientCodec.this.queue.offer(((HttpRequest)object).method());
            }
            super.encode(channelHandlerContext, object, list);
            if (HttpClientCodec.this.failOnMissingResponse && !HttpClientCodec.this.done && object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            }
        }
    }
}

