/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.util.AsciiString;

public enum HttpStatusClass {
    INFORMATIONAL(100, 200, "Informational"),
    SUCCESS(200, 300, "Success"),
    REDIRECTION(300, 400, "Redirection"),
    CLIENT_ERROR(400, 500, "Client Error"),
    SERVER_ERROR(500, 600, "Server Error"),
    UNKNOWN(0, 0, "Unknown Status"){

        @Override
        public final boolean contains(int n) {
            return n < 100 || n >= 600;
        }
    };

    private static final HttpStatusClass[] statusArray;
    private final int min;
    private final int max;
    private final AsciiString defaultReasonPhrase;

    public static HttpStatusClass valueOf(int n) {
        if (UNKNOWN.contains(n)) {
            return UNKNOWN;
        }
        return statusArray[HttpStatusClass.fast_div100(n)];
    }

    private static int fast_div100(int n) {
        return (int)((long)n * 1374389535L >> 37);
    }

    public static HttpStatusClass valueOf(CharSequence charSequence) {
        if (charSequence != null && charSequence.length() == 3) {
            char c = charSequence.charAt(0);
            if (HttpStatusClass.isDigit(c) && HttpStatusClass.isDigit(charSequence.charAt(1)) && HttpStatusClass.isDigit(charSequence.charAt(2))) {
                return HttpStatusClass.valueOf(HttpStatusClass.digit(c) * 100);
            }
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    private static int digit(char c) {
        return c - 48;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private HttpStatusClass(int n2, int n3, String string2) {
        this.min = n2;
        this.max = n3;
        this.defaultReasonPhrase = AsciiString.cached((String)string2);
    }

    public boolean contains(int n) {
        return n >= this.min && n < this.max;
    }

    AsciiString defaultReasonPhrase() {
        return this.defaultReasonPhrase;
    }

    static {
        HttpStatusClass[] httpStatusClassArray = new HttpStatusClass[6];
        statusArray = httpStatusClassArray;
        httpStatusClassArray[1] = INFORMATIONAL;
        HttpStatusClass.statusArray[2] = SUCCESS;
        HttpStatusClass.statusArray[3] = REDIRECTION;
        HttpStatusClass.statusArray[4] = CLIENT_ERROR;
        HttpStatusClass.statusArray[5] = SERVER_ERROR;
    }
}

