/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker13
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public WebSocketServerHandshaker13(String string, String string2, boolean bl, int n) {
        this(string, string2, bl, n, false);
    }

    public WebSocketServerHandshaker13(String string, String string2, boolean bl, int n, boolean bl2) {
        this(string, string2, WebSocketDecoderConfig.newBuilder().allowExtensions(bl).maxFramePayloadLength(n).allowMaskMismatch(bl2).build());
    }

    public WebSocketServerHandshaker13(String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        super(WebSocketVersion.V13, string, string2, webSocketDecoderConfig);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest fullHttpMessage, HttpHeaders object) {
        Object object2 = fullHttpMessage.method();
        if (!HttpMethod.GET.equals(object2)) {
            throw new WebSocketServerHandshakeException("Invalid WebSocket handshake method: " + object2, (HttpRequest)((Object)fullHttpMessage));
        }
        object2 = fullHttpMessage.headers();
        if (!((HttpHeaders)object2).contains((CharSequence)HttpHeaderNames.CONNECTION) || !((HttpHeaders)object2).containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: a |Connection| header must includes a token 'Upgrade'", (HttpRequest)((Object)fullHttpMessage));
        }
        if (!((HttpHeaders)object2).contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true)) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: a |Upgrade| header must containing the value 'websocket'", (HttpRequest)((Object)fullHttpMessage));
        }
        String string = ((HttpHeaders)object2).get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY);
        if (string == null) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: missing key", (HttpRequest)((Object)fullHttpMessage));
        }
        fullHttpMessage = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, fullHttpMessage.content().alloc().buffer(0));
        if (object != null) {
            fullHttpMessage.headers().add((HttpHeaders)object);
        }
        object = string + WEBSOCKET_13_ACCEPT_GUID;
        byte[] byArray = WebSocketUtil.sha1(((String)object).getBytes(CharsetUtil.US_ASCII));
        object = byArray;
        object = WebSocketUtil.base64(byArray);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 server handshake key: {}, response: {}", (Object)string, object);
        }
        fullHttpMessage.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, object);
        object = ((HttpHeaders)object2).get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (object != null) {
            object2 = this.selectSubprotocol((String)object);
            if (object2 == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", object);
                }
            } else {
                fullHttpMessage.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, object2);
            }
        }
        return fullHttpMessage;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(this.decoderConfig());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(false);
    }
}

