/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;

public final class DescriptorUtilKt {
    public static final ClassDescriptor resolveClassByFqName(ModuleDescriptor object, FqName fqName, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        if (fqName.isRoot()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = object.getPackage(fqName.parent()).getMemberScope().getContributedClassifier(fqName.shortName(), lookupLocation);
        classifierDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classifierDescriptor != null) {
            object = classifierDescriptor;
            return object;
        }
        classifierDescriptor = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)object, fqName.parent(), lookupLocation);
        classifierDescriptor = classifierDescriptor != null && (object = classifierDescriptor.getUnsubstitutedInnerClassesScope()) != null ? object.getContributedClassifier(fqName.shortName(), lookupLocation) : null;
        if (classifierDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    public static final boolean isTopLevelInPackage(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static final ClassifierDescriptor getTopLevelContainingClassifier(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
        if (declarationDescriptor2 == null || declarationDescriptor instanceof PackageFragmentDescriptor) {
            return null;
        }
        if (!DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor2)) {
            return DescriptorUtilKt.getTopLevelContainingClassifier(declarationDescriptor2);
        }
        if (declarationDescriptor2 instanceof ClassifierDescriptor) {
            return (ClassifierDescriptor)declarationDescriptor2;
        }
        return null;
    }

    public static final boolean isTypedEqualsInValueClass(FunctionDescriptor functionDescriptor) {
        Annotated annotated;
        Annotated annotated2;
        DeclarationDescriptor declarationDescriptor;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
                declarationDescriptor = functionDescriptor.getContainingDeclaration();
                annotated2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                if (annotated2 == null) break block6;
                declarationDescriptor = annotated2;
                annotated = annotated2;
                if ((annotated2 = InlineClassesUtilsKt.isValueClass(annotated2) ? declarationDescriptor : null) != null && (annotated2 = annotated2.getDefaultType()) != null && (annotated2 = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)annotated2)) != null) break block7;
            }
            return false;
        }
        declarationDescriptor = annotated2;
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        annotated = kotlinType;
        if (Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)OperatorNameConventions.EQUALS) && (TypeUtilsKt.isBoolean((KotlinType)annotated) || TypeUtilsKt.isNothing((KotlinType)annotated)) && functionDescriptor.getValueParameters().size() == 1) {
            KotlinType kotlinType2 = functionDescriptor.getValueParameters().get(0).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
            if (Intrinsics.areEqual((Object)TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType2), (Object)declarationDescriptor) && functionDescriptor.getContextReceiverParameters().isEmpty() && functionDescriptor.getExtensionReceiverParameter() == null) {
                return true;
            }
        }
        return false;
    }
}

