/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.InvalidModuleExceptionKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleCapability;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependencies;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependenciesImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatform;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final TargetPlatform platform;
    private final Name stableName;
    private final Map<ModuleCapability<?>, Object> capabilities;
    private final PackageViewDescriptorFactory packageViewDescriptorFactory;
    private ModuleDependencies dependencies;
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private boolean isValid;
    private final MemoizedFunctionToNotNull<FqName, PackageViewDescriptor> packages;
    private final Lazy packageFragmentProviderForWholeModuleWithDependencies$delegate;

    public ModuleDescriptorImpl(Name object, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map<ModuleCapability<?>, ? extends Object> map, Name name) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        Intrinsics.checkNotNullParameter(map, (String)"");
        super(Annotations.Companion.getEMPTY(), (Name)object);
        this.storageManager = storageManager;
        this.builtIns = kotlinBuiltIns;
        this.platform = targetPlatform;
        this.stableName = name;
        if (!((Name)object).isSpecial()) {
            throw new IllegalArgumentException("Module name must be special: " + object);
        }
        this.capabilities = map;
        PackageViewDescriptorFactory packageViewDescriptorFactory = this.getCapability(PackageViewDescriptorFactory.Companion.getCAPABILITY());
        if (packageViewDescriptorFactory == null) {
            packageViewDescriptorFactory = PackageViewDescriptorFactory.Default.INSTANCE;
        }
        this.packageViewDescriptorFactory = packageViewDescriptorFactory;
        this.isValid = true;
        object = this;
        this.packages = this.storageManager.createMemoizedFunction(new ModuleDescriptorImpl$$Lambda$0((ModuleDescriptorImpl)object));
        object = this;
        this.packageFragmentProviderForWholeModuleWithDependencies$delegate = LazyKt.lazy((Function0)new ModuleDescriptorImpl$$Lambda$1((ModuleDescriptorImpl)object));
    }

    public /* synthetic */ ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map map, Name name2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            targetPlatform = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            name2 = null;
        }
        this(name, storageManager, kotlinBuiltIns, targetPlatform, map, name2);
    }

    @Override
    public final KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void assertValid() {
        if (!this.isValid()) {
            InvalidModuleExceptionKt.moduleInvalidated(this);
        }
    }

    @Override
    public final List<ModuleDescriptor> getExpectedByModules() {
        Object object = this.dependencies;
        if (object == null) {
            object = "Dependencies of module " + this.getId() + " were not set";
            throw new AssertionError(object);
        }
        return object.getDirectExpectedByDependencies();
    }

    @Override
    public final PackageViewDescriptor getPackage(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        this.assertValid();
        return (PackageViewDescriptor)this.packages.invoke(fqName);
    }

    @Override
    public final Collection<FqName> getSubPackagesOf(FqName fqName, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.assertValid();
        return this.getPackageFragmentProvider().getSubPackagesOf(fqName, function1);
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        Lazy lazy = this.packageFragmentProviderForWholeModuleWithDependencies$delegate;
        return (CompositePackageFragmentProvider)lazy.getValue();
    }

    private final boolean isInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    public final void setDependencies(ModuleDependencies object) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        boolean bl2 = bl = this.dependencies == null;
        if (_Assertions.ENABLED && !bl) {
            object = "Dependencies of " + this.getId() + " were already set";
            throw new AssertionError(object);
        }
        this.dependencies = object;
    }

    public final void setDependencies(ModuleDescriptorImpl ... moduleDescriptorImplArray) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptorImplArray, (String)"");
        this.setDependencies(ArraysKt.toList((Object[])moduleDescriptorImplArray));
    }

    public final void setDependencies(List<ModuleDescriptorImpl> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.setDependencies(list, SetsKt.emptySet());
    }

    public final void setDependencies(List<ModuleDescriptorImpl> list, Set<ModuleDescriptorImpl> set) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(set, (String)"");
        this.setDependencies(new ModuleDependenciesImpl(list, set, CollectionsKt.emptyList(), SetsKt.emptySet()));
    }

    @Override
    public final boolean shouldSeeInternalsOf(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        if (Intrinsics.areEqual((Object)this, (Object)moduleDescriptor)) {
            return true;
        }
        ModuleDependencies moduleDependencies = this.dependencies;
        Intrinsics.checkNotNull((Object)moduleDependencies);
        if (CollectionsKt.contains((Iterable)moduleDependencies.getModulesWhoseInternalsAreVisible(), (Object)moduleDescriptor)) {
            return true;
        }
        if (this.getExpectedByModules().contains(moduleDescriptor)) {
            return true;
        }
        return moduleDescriptor.getExpectedByModules().contains(this);
    }

    private final String getId() {
        String string = this.getName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final void initialize(PackageFragmentProvider object) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        boolean bl2 = bl = !this.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            object = "Attempt to initialize module " + this.getId() + " twice";
            throw new AssertionError(object);
        }
        this.packageFragmentProviderForModuleContent = object;
    }

    public final PackageFragmentProvider getPackageFragmentProvider() {
        this.assertValid();
        return this.getPackageFragmentProviderForWholeModuleWithDependencies();
    }

    @Override
    public final <T> T getCapability(ModuleCapability<T> moduleCapability) {
        Intrinsics.checkNotNullParameter(moduleCapability, (String)"");
        Object object = this.capabilities.get(moduleCapability);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (!this.isValid()) {
            stringBuilder2.append(" !isValid");
        }
        stringBuilder2.append(" packageFragmentProvider: ");
        Object object = this.packageFragmentProviderForModuleContent;
        stringBuilder2.append(object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null);
        return stringBuilder.toString();
    }

    @Override
    public final DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    @Override
    public final <R, D> R accept(DeclarationDescriptorVisitor<R, D> declarationDescriptorVisitor, D d) {
        return ModuleDescriptor.DefaultImpls.accept(this, declarationDescriptorVisitor, d);
    }

    public ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        this(name, storageManager, kotlinBuiltIns, targetPlatform, null, null, 48, null);
    }

    private static final PackageViewDescriptor packages$lambda$0(ModuleDescriptorImpl moduleDescriptorImpl, FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return moduleDescriptorImpl.packageViewDescriptorFactory.compute(moduleDescriptorImpl, fqName, moduleDescriptorImpl.storageManager);
    }

    private static final CompositePackageFragmentProvider packageFragmentProviderForWholeModuleWithDependencies_delegate$lambda$10(ModuleDescriptorImpl object) {
        Object object2;
        Object object3 = object2 = ((ModuleDescriptorImpl)object).dependencies;
        if (object3 == null) {
            object = "Dependencies of module " + ((ModuleDescriptorImpl)object).getId() + " were not set before querying module content";
            throw new AssertionError(object);
        }
        object2 = object3;
        object2 = object3.getAllDependencies();
        ((ModuleDescriptorImpl)object).assertValid();
        boolean bl = object2.contains(object);
        if (_Assertions.ENABLED && !bl) {
            object = "Module " + super.getId() + " is not contained in its own dependencies, this is probably a misconfiguration";
            throw new AssertionError(object);
        }
        Object object4 = (Iterable)object2;
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object4 = object5.next();
            object4 = (ModuleDescriptorImpl)object4;
            boolean bl2 = ((ModuleDescriptorImpl)object4).isInitialized();
            if (!_Assertions.ENABLED || bl2) continue;
            object5 = "Dependency module " + super.getId() + " was not initialized by the time contents of dependent module " + super.getId() + " were queried";
            throw new AssertionError(object5);
        }
        object5 = object4 = (Iterable)object2;
        object4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10));
        object2 = object5.iterator();
        while (object2.hasNext()) {
            Object object6 = object2.next();
            object5 = (ModuleDescriptorImpl)object6;
            object6 = object4;
            PackageFragmentProvider packageFragmentProvider = ((ModuleDescriptorImpl)object5).packageFragmentProviderForModuleContent;
            Intrinsics.checkNotNull((Object)packageFragmentProvider);
            object6.add((PackageFragmentProvider)packageFragmentProvider);
        }
        object = "CompositeProvider@ModuleDescriptor for " + ((DeclarationDescriptorImpl)object).getName();
        object2 = (List)object4;
        return new CompositePackageFragmentProvider((List<? extends PackageFragmentProvider>)object2, (String)object);
    }

    static /* synthetic */ PackageViewDescriptor accessor$ModuleDescriptorImpl$lambda0(ModuleDescriptorImpl moduleDescriptorImpl, FqName fqName) {
        return ModuleDescriptorImpl.packages$lambda$0(moduleDescriptorImpl, fqName);
    }

    static /* synthetic */ CompositePackageFragmentProvider accessor$ModuleDescriptorImpl$lambda1(ModuleDescriptorImpl moduleDescriptorImpl) {
        return ModuleDescriptorImpl.packageFragmentProviderForWholeModuleWithDependencies_delegate$lambda$10(moduleDescriptorImpl);
    }
}

