/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;

public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(FqName fqName, FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (Intrinsics.areEqual((Object)fqName, (Object)fqName2)) {
            return true;
        }
        if (fqName2.isRoot()) {
            return true;
        }
        return FqNamesUtilKt.isSubpackageOf(fqName.asString(), fqName2.asString());
    }

    public static final boolean isChildOf(FqName fqName, FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        return Intrinsics.areEqual((Object)FqNamesUtilKt.parentOrNull(fqName), (Object)fqName2);
    }

    private static final boolean isSubpackageOf(String string, String string2) {
        return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) && string.charAt(string2.length()) == '.';
    }

    public static final FqName tail(FqName fqName, FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (!FqNamesUtilKt.isSubpackageOf(fqName, fqName2) || fqName2.isRoot()) {
            return fqName;
        }
        if (Intrinsics.areEqual((Object)fqName, (Object)fqName2)) {
            return FqName.ROOT;
        }
        String string = fqName.asString().substring(fqName2.asString().length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return new FqName(string);
    }

    public static final FqName parentOrNull(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        if (fqName.isRoot()) {
            return null;
        }
        return fqName.parent();
    }

    public static final boolean isValidJavaFqName(String string) {
        if (string == null) {
            return false;
        }
        State state = State.BEGINNING;
        block4: for (int i = 0; i < ((CharSequence)string).length(); ++i) {
            char c = ((CharSequence)string).charAt(i);
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    continue block4;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) continue block4;
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return state != State.AFTER_DOT;
    }

    public static final <V> V findValueForMostSpecificFqname(FqName fqName, Map<FqName, ? extends V> iterator2) {
        Iterator iterator3;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(iterator2, (String)"");
        Object object = new LinkedHashMap();
        Iterator iterator5 = iterator2.entrySet().iterator();
        while (iterator5.hasNext()) {
            Map.Entry object2 = iterator5.next();
            iterator2 = object2;
            iterator2 = (FqName)object2.getKey();
            if (!(Intrinsics.areEqual((Object)fqName, (Object)iterator2) || FqNamesUtilKt.isChildOf(fqName, (FqName)((Object)iterator2)))) continue;
            object.put(object2.getKey(), object2.getValue());
        }
        iterator2 = object;
        object = iterator2;
        Iterator<Object> iterator4 = !iterator2.isEmpty() ? iterator2 : null;
        if (iterator4 == null) {
            return null;
        }
        iterator2 = iterator4;
        object = iterator4.entrySet();
        iterator2 = object.iterator();
        if (!iterator2.hasNext()) {
            iterator3 = null;
        } else {
            object = iterator2.next();
            if (!iterator2.hasNext()) {
                iterator3 = object;
            } else {
                Map.Entry entry = (Map.Entry)object;
                FqName object3 = (FqName)entry.getKey();
                int n = FqNamesUtilKt.tail(object3, fqName).asString().length();
                do {
                    Map.Entry n2;
                    FqName fqName2;
                    int n3;
                    if (n <= (n3 = FqNamesUtilKt.tail(fqName2 = (FqName)(n2 = (Map.Entry)((Object)(iterator5 = iterator2.next()))).getKey(), fqName).asString().length())) continue;
                    object = iterator5;
                    n = n3;
                } while (iterator2.hasNext());
                iterator3 = object;
            }
        }
        Map.Entry entry = (Map.Entry)((Object)iterator3);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.BEGINNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[State.AFTER_DOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[State.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

