/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;

public final class DescriptorEquivalenceForOverrides {
    public static final DescriptorEquivalenceForOverrides INSTANCE = new DescriptorEquivalenceForOverrides();

    private DescriptorEquivalenceForOverrides() {
    }

    public final boolean areEquivalent(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2) {
        if (declarationDescriptor instanceof ClassDescriptor && declarationDescriptor2 instanceof ClassDescriptor) {
            return this.areClassesEquivalent((ClassDescriptor)declarationDescriptor, (ClassDescriptor)declarationDescriptor2);
        }
        if (declarationDescriptor instanceof TypeParameterDescriptor && declarationDescriptor2 instanceof TypeParameterDescriptor) {
            return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)declarationDescriptor, (TypeParameterDescriptor)declarationDescriptor2, bl, null, 8, null);
        }
        if (declarationDescriptor instanceof CallableDescriptor && declarationDescriptor2 instanceof CallableDescriptor) {
            return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)declarationDescriptor, (CallableDescriptor)declarationDescriptor2, bl, bl2, false, KotlinTypeRefiner.Default.INSTANCE, 16, null);
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor && declarationDescriptor2 instanceof PackageFragmentDescriptor) {
            return Intrinsics.areEqual((Object)((PackageFragmentDescriptor)declarationDescriptor).getFqName(), (Object)((PackageFragmentDescriptor)declarationDescriptor2).getFqName());
        }
        return Intrinsics.areEqual((Object)declarationDescriptor, (Object)declarationDescriptor2);
    }

    public static /* synthetic */ boolean areEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return descriptorEquivalenceForOverrides.areEquivalent(declarationDescriptor, declarationDescriptor2, bl, bl2);
    }

    private final boolean areClassesEquivalent(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2) {
        return Intrinsics.areEqual((Object)classDescriptor.getTypeConstructor(), (Object)classDescriptor2.getTypeConstructor());
    }

    public final boolean areTypeParametersEquivalent(TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> function2) {
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor2, (String)"");
        Intrinsics.checkNotNullParameter(function2, (String)"");
        if (Intrinsics.areEqual((Object)typeParameterDescriptor, (Object)typeParameterDescriptor2)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)typeParameterDescriptor.getContainingDeclaration(), (Object)typeParameterDescriptor2.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, function2, bl)) {
            return false;
        }
        return typeParameterDescriptor.getIndex() == typeParameterDescriptor2.getIndex();
    }

    public static /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = DescriptorEquivalenceForOverrides$$Lambda$0.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, bl, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)function2);
    }

    private final SourceElement singleSource(CallableDescriptor callableDescriptor) {
        do {
            if (!(callableDescriptor instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)callableDescriptor).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return callableDescriptor.getSource();
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)callableDescriptor).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"");
            callableDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
        } while (callableDescriptor != null);
        return null;
    }

    public final boolean areCallableDescriptorsEquivalent(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner object) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)callableDescriptor2, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (Intrinsics.areEqual((Object)callableDescriptor, (Object)callableDescriptor2)) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)callableDescriptor.getName(), (Object)callableDescriptor2.getName())) {
            return false;
        }
        if (bl2 && callableDescriptor instanceof MemberDescriptor && callableDescriptor2 instanceof MemberDescriptor && ((MemberDescriptor)((Object)callableDescriptor)).isExpect() != ((MemberDescriptor)((Object)callableDescriptor2)).isExpect()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)callableDescriptor.getContainingDeclaration(), (Object)callableDescriptor2.getContainingDeclaration())) {
            if (!bl) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleSource(callableDescriptor), (Object)this.singleSource(callableDescriptor2))) {
                return false;
            }
        }
        if (DescriptorUtils.isLocal(callableDescriptor) || DescriptorUtils.isLocal(callableDescriptor2)) {
            return false;
        }
        if (!this.ownersEquivalent(callableDescriptor, callableDescriptor2, DescriptorEquivalenceForOverrides$$Lambda$1.INSTANCE, bl)) {
            return false;
        }
        KotlinTypeRefiner kotlinTypeRefiner = object;
        CallableDescriptor callableDescriptor3 = callableDescriptor2;
        object = callableDescriptor;
        OverridingUtil overridingUtil = OverridingUtil.create(kotlinTypeRefiner, new DescriptorEquivalenceForOverrides$$Lambda$2(bl, (CallableDescriptor)object, callableDescriptor3));
        Intrinsics.checkNotNullExpressionValue((Object)overridingUtil, (String)"");
        OverridingUtil overridingUtil2 = overridingUtil;
        return overridingUtil.isOverridableBy(callableDescriptor, callableDescriptor2, null, !bl3).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && overridingUtil2.isOverridableBy(callableDescriptor2, callableDescriptor, null, !bl3).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    public static /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner kotlinTypeRefiner, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl, bl2, bl3, kotlinTypeRefiner);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> function2, boolean bl) {
        declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        declarationDescriptor2 = declarationDescriptor2.getContainingDeclaration();
        if (declarationDescriptor instanceof CallableMemberDescriptor || declarationDescriptor2 instanceof CallableMemberDescriptor) {
            return (Boolean)function2.invoke((Object)declarationDescriptor, (Object)declarationDescriptor2);
        }
        return DescriptorEquivalenceForOverrides.areEquivalent$default(this, declarationDescriptor, declarationDescriptor2, bl, false, 8, null);
    }

    public final boolean areTypeParametersEquivalent(TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor2, (String)"");
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, typeParameterDescriptor, typeParameterDescriptor2, bl, null, 8, null);
    }

    private static final boolean areTypeParametersEquivalent$lambda$0(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return false;
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$1(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return false;
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$3$lambda$2(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return Intrinsics.areEqual((Object)declarationDescriptor, (Object)callableDescriptor) && Intrinsics.areEqual((Object)declarationDescriptor2, (Object)callableDescriptor2);
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$3(boolean bl, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, TypeConstructor object, TypeConstructor object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        if (Intrinsics.areEqual((Object)object, (Object)object2)) {
            return true;
        }
        object = object.getDeclarationDescriptor();
        object2 = object2.getDeclarationDescriptor();
        if (!(object instanceof TypeParameterDescriptor) || !(object2 instanceof TypeParameterDescriptor)) {
            return false;
        }
        CallableDescriptor callableDescriptor3 = callableDescriptor2;
        return INSTANCE.areTypeParametersEquivalent((TypeParameterDescriptor)object, (TypeParameterDescriptor)object2, bl, new DescriptorEquivalenceForOverrides$$Lambda$3(callableDescriptor, callableDescriptor3));
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda0(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$lambda$0(declarationDescriptor, declarationDescriptor2);
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda1(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$1(declarationDescriptor, declarationDescriptor2);
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda2(boolean bl, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, TypeConstructor typeConstructor2, TypeConstructor typeConstructor3) {
        return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$3(bl, callableDescriptor, callableDescriptor2, typeConstructor2, typeConstructor3);
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda3(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$3$lambda$2(callableDescriptor, callableDescriptor2, declarationDescriptor, declarationDescriptor2);
    }
}

