/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.FunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PropertyAccessorDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PropertyDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingStrategy;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtilTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.resolve.VisibilityUtilKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

public class OverridingUtil {
    private static final List<ExternalOverridabilityCondition> EXTERNAL_CONDITIONS = CollectionsKt.toList(ServiceLoader.load(ExternalOverridabilityCondition.class, ExternalOverridabilityCondition.class.getClassLoader()));
    public static final OverridingUtil DEFAULT;
    private static final KotlinTypeChecker.TypeConstructorEquality DEFAULT_TYPE_CONSTRUCTOR_EQUALITY;
    private final KotlinTypeRefiner kotlinTypeRefiner;
    private final KotlinTypePreparator kotlinTypePreparator;
    private final KotlinTypeChecker.TypeConstructorEquality equalityAxioms;
    private final Function2<KotlinType, KotlinType, Boolean> customSubtype;

    public static OverridingUtil createWithTypeRefiner(KotlinTypeRefiner kotlinTypeRefiner) {
        if (kotlinTypeRefiner == null) {
            OverridingUtil.$$$reportNull$$$0(0);
        }
        return new OverridingUtil(DEFAULT_TYPE_CONSTRUCTOR_EQUALITY, kotlinTypeRefiner, KotlinTypePreparator.Default.INSTANCE, null);
    }

    public static OverridingUtil create(KotlinTypeRefiner kotlinTypeRefiner, KotlinTypeChecker.TypeConstructorEquality typeConstructorEquality) {
        if (kotlinTypeRefiner == null) {
            OverridingUtil.$$$reportNull$$$0(3);
        }
        if (typeConstructorEquality == null) {
            OverridingUtil.$$$reportNull$$$0(4);
        }
        return new OverridingUtil(typeConstructorEquality, kotlinTypeRefiner, KotlinTypePreparator.Default.INSTANCE, null);
    }

    private OverridingUtil(KotlinTypeChecker.TypeConstructorEquality typeConstructorEquality, KotlinTypeRefiner kotlinTypeRefiner, KotlinTypePreparator kotlinTypePreparator, Function2<KotlinType, KotlinType, Boolean> function2) {
        if (typeConstructorEquality == null) {
            OverridingUtil.$$$reportNull$$$0(5);
        }
        if (kotlinTypeRefiner == null) {
            OverridingUtil.$$$reportNull$$$0(6);
        }
        if (kotlinTypePreparator == null) {
            OverridingUtil.$$$reportNull$$$0(7);
        }
        this.equalityAxioms = typeConstructorEquality;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
        this.kotlinTypePreparator = kotlinTypePreparator;
        this.customSubtype = function2;
    }

    public static <D extends CallableDescriptor> Set<D> filterOutOverridden(Set<D> set) {
        if (set == null) {
            OverridingUtil.$$$reportNull$$$0(8);
        }
        boolean bl = !set.isEmpty() && DescriptorUtilsKt.isTypeRefinementEnabled(DescriptorUtilsKt.getModule((DeclarationDescriptor)set.iterator().next()));
        return OverridingUtil.filterOverrides(set, bl, null, new Function2<D, D, Pair<CallableDescriptor, CallableDescriptor>>(){

            public final Pair<CallableDescriptor, CallableDescriptor> invoke(D d, D d2) {
                return new Pair(d, d2);
            }
        });
    }

    public static <D> Set<D> filterOverrides(Set<D> set, boolean bl, Function0<?> function0, Function2<? super D, ? super D, Pair<CallableDescriptor, CallableDescriptor>> function2) {
        if (set == null) {
            OverridingUtil.$$$reportNull$$$0(9);
        }
        if (function2 == null) {
            OverridingUtil.$$$reportNull$$$0(10);
        }
        if (set.size() <= 1) {
            Set<D> set2 = set;
            if (set2 == null) {
                OverridingUtil.$$$reportNull$$$0(11);
            }
            return set2;
        }
        LinkedHashSet<D> linkedHashSet = new LinkedHashSet<D>();
        block0: for (D d : set) {
            if (function0 != null) {
                function0.invoke();
            }
            Iterator iterator2 = linkedHashSet.iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                object = (Pair)function2.invoke(d, object);
                CallableDescriptor callableDescriptor = (CallableDescriptor)object.component1();
                if (OverridingUtil.overrides(callableDescriptor, object = (CallableDescriptor)object.component2(), bl, true)) {
                    iterator2.remove();
                    continue;
                }
                if (OverridingUtil.overrides(object, callableDescriptor, bl, true)) continue block0;
            }
            linkedHashSet.add(d);
        }
        assert (!linkedHashSet.isEmpty()) : "All candidates filtered out from " + set;
        return linkedHashSet;
    }

    public static <D extends CallableDescriptor> boolean overrides(D object, D object2, boolean bl, boolean bl2) {
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(13);
        }
        if (object2 == null) {
            OverridingUtil.$$$reportNull$$$0(14);
        }
        if (!object.equals(object2) && DescriptorEquivalenceForOverrides.INSTANCE.areEquivalent(object.getOriginal(), object2.getOriginal(), bl, bl2)) {
            return true;
        }
        object2 = object2.getOriginal();
        for (CallableDescriptor callableDescriptor : DescriptorUtils.getAllOverriddenDescriptors(object)) {
            if (!DescriptorEquivalenceForOverrides.INSTANCE.areEquivalent((DeclarationDescriptor)object2, callableDescriptor, bl, bl2)) continue;
            return true;
        }
        return false;
    }

    public static Set<CallableMemberDescriptor> getOverriddenDeclarations(CallableMemberDescriptor callableMemberDescriptor) {
        if (callableMemberDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(15);
        }
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = new LinkedHashSet<CallableMemberDescriptor>();
        OverridingUtil.collectOverriddenDeclarations(callableMemberDescriptor, linkedHashSet);
        return linkedHashSet;
    }

    private static void collectOverriddenDeclarations(CallableMemberDescriptor object, Set<CallableMemberDescriptor> set) {
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(17);
        }
        if (set == null) {
            OverridingUtil.$$$reportNull$$$0(18);
        }
        if (object.getKind().isReal()) {
            set.add((CallableMemberDescriptor)((Object)object));
            return;
        }
        if (object.getOverriddenDescriptors().isEmpty()) {
            throw new IllegalStateException("No overridden descriptors found for (fake override) " + object);
        }
        for (CallableMemberDescriptor callableMemberDescriptor : object.getOverriddenDescriptors()) {
            OverridingUtil.collectOverriddenDeclarations(callableMemberDescriptor, set);
        }
    }

    public OverrideCompatibilityInfo isOverridableBy(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, ClassDescriptor classDescriptor) {
        if (callableDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(19);
        }
        if (callableDescriptor2 == null) {
            OverridingUtil.$$$reportNull$$$0(20);
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = this.isOverridableBy(callableDescriptor, callableDescriptor2, classDescriptor, false);
        if (overrideCompatibilityInfo == null) {
            OverridingUtil.$$$reportNull$$$0(21);
        }
        return overrideCompatibilityInfo;
    }

    public OverrideCompatibilityInfo isOverridableBy(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, ClassDescriptor classDescriptor, boolean bl) {
        ExternalOverridabilityCondition.Result result;
        OverrideCompatibilityInfo overrideCompatibilityInfo;
        if (callableDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(22);
        }
        if (callableDescriptor2 == null) {
            OverridingUtil.$$$reportNull$$$0(23);
        }
        boolean bl2 = (overrideCompatibilityInfo = this.isOverridableByWithoutExternalConditions(callableDescriptor, callableDescriptor2, bl)).getResult() == OverrideCompatibilityInfo.Result.OVERRIDABLE;
        block8: for (ExternalOverridabilityCondition externalOverridabilityCondition : EXTERNAL_CONDITIONS) {
            if (externalOverridabilityCondition.getContract() == ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY || bl2 && externalOverridabilityCondition.getContract() == ExternalOverridabilityCondition.Contract.SUCCESS_ONLY) continue;
            result = externalOverridabilityCondition.isOverridable(callableDescriptor, callableDescriptor2, classDescriptor);
            switch (result) {
                case OVERRIDABLE: {
                    bl2 = true;
                    continue block8;
                }
                case INCOMPATIBLE: {
                    OverrideCompatibilityInfo overrideCompatibilityInfo2 = OverrideCompatibilityInfo.incompatible("External condition");
                    if (overrideCompatibilityInfo2 == null) {
                        OverridingUtil.$$$reportNull$$$0(24);
                    }
                    return overrideCompatibilityInfo2;
                }
            }
        }
        if (!bl2) {
            OverrideCompatibilityInfo overrideCompatibilityInfo3 = overrideCompatibilityInfo;
            if (overrideCompatibilityInfo3 == null) {
                OverridingUtil.$$$reportNull$$$0(25);
            }
            return overrideCompatibilityInfo3;
        }
        for (ExternalOverridabilityCondition externalOverridabilityCondition : EXTERNAL_CONDITIONS) {
            if (externalOverridabilityCondition.getContract() != ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY) continue;
            result = externalOverridabilityCondition.isOverridable(callableDescriptor, callableDescriptor2, classDescriptor);
            switch (result) {
                case INCOMPATIBLE: {
                    OverrideCompatibilityInfo overrideCompatibilityInfo4 = OverrideCompatibilityInfo.incompatible("External condition");
                    if (overrideCompatibilityInfo4 == null) {
                        OverridingUtil.$$$reportNull$$$0(26);
                    }
                    return overrideCompatibilityInfo4;
                }
                case OVERRIDABLE: {
                    throw new IllegalStateException("Contract violation in " + externalOverridabilityCondition.getClass().getName() + " condition. It's not supposed to end with success");
                }
            }
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo5 = OverrideCompatibilityInfo.success();
        if (overrideCompatibilityInfo5 == null) {
            OverridingUtil.$$$reportNull$$$0(27);
        }
        return overrideCompatibilityInfo5;
    }

    public OverrideCompatibilityInfo isOverridableByWithoutExternalConditions(CallableDescriptor annotated, CallableDescriptor callableDescriptor, boolean bl) {
        int n;
        Object object;
        if (annotated == null) {
            OverridingUtil.$$$reportNull$$$0(28);
        }
        if (callableDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(29);
        }
        if ((object = OverridingUtil.getBasicOverridabilityProblem((CallableDescriptor)annotated, callableDescriptor)) != null) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = object;
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(30);
            }
            return overrideCompatibilityInfo;
        }
        object = OverridingUtil.compiledValueParameters((CallableDescriptor)annotated);
        List<KotlinType> list = OverridingUtil.compiledValueParameters(callableDescriptor);
        List<TypeParameterDescriptor> list2 = annotated.getTypeParameters();
        List<TypeParameterDescriptor> list3 = callableDescriptor.getTypeParameters();
        if (list2.size() != list3.size()) {
            for (int i = 0; i < object.size(); ++i) {
                if (KotlinTypeChecker.DEFAULT.equalTypes((KotlinType)object.get(i), list.get(i))) continue;
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("Type parameter number mismatch");
                if (overrideCompatibilityInfo == null) {
                    OverridingUtil.$$$reportNull$$$0(31);
                }
                return overrideCompatibilityInfo;
            }
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.conflict("Type parameter number mismatch");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(32);
            }
            return overrideCompatibilityInfo;
        }
        TypeCheckerState typeCheckerState = this.createTypeCheckerState(list2, list3);
        for (n = 0; n < list2.size(); ++n) {
            if (OverridingUtil.areTypeParametersEquivalent(list2.get(n), list3.get(n), typeCheckerState)) continue;
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("Type parameter bounds mismatch");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(33);
            }
            return overrideCompatibilityInfo;
        }
        for (n = 0; n < object.size(); ++n) {
            if (OverridingUtil.areTypesEquivalent((KotlinType)object.get(n), list.get(n), typeCheckerState)) continue;
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("Value parameter type mismatch");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(34);
            }
            return overrideCompatibilityInfo;
        }
        if (annotated instanceof FunctionDescriptor && callableDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)annotated).isSuspend() != ((FunctionDescriptor)callableDescriptor).isSuspend()) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.conflict("Incompatible suspendability");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(35);
            }
            return overrideCompatibilityInfo;
        }
        if (bl) {
            boolean bl2;
            KotlinType kotlinType = annotated.getReturnType();
            annotated = callableDescriptor.getReturnType();
            if (kotlinType != null && annotated != null && !(bl2 = KotlinTypeKt.isError((KotlinType)annotated) && KotlinTypeKt.isError(kotlinType)) && !AbstractTypeChecker.INSTANCE.isSubtypeOf(typeCheckerState, ((KotlinType)annotated).unwrap(), kotlinType.unwrap())) {
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.conflict("Return type mismatch");
                if (overrideCompatibilityInfo == null) {
                    OverridingUtil.$$$reportNull$$$0(36);
                }
                return overrideCompatibilityInfo;
            }
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.success();
        if (overrideCompatibilityInfo == null) {
            OverridingUtil.$$$reportNull$$$0(37);
        }
        return overrideCompatibilityInfo;
    }

    public static OverrideCompatibilityInfo getBasicOverridabilityProblem(CallableDescriptor object, CallableDescriptor callableDescriptor) {
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(38);
        }
        if (callableDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(39);
        }
        if (object instanceof FunctionDescriptor && !(callableDescriptor instanceof FunctionDescriptor) || object instanceof PropertyDescriptor && !(callableDescriptor instanceof PropertyDescriptor)) {
            return OverrideCompatibilityInfo.incompatible("Member kind mismatch");
        }
        if (!(object instanceof FunctionDescriptor) && !(object instanceof PropertyDescriptor)) {
            throw new IllegalArgumentException("This type of CallableDescriptor cannot be checked for overridability: " + object);
        }
        if (!object.getName().equals(callableDescriptor.getName())) {
            return OverrideCompatibilityInfo.incompatible("Name mismatch");
        }
        if ((object = OverridingUtil.checkReceiverAndParameterCount((CallableDescriptor)object, callableDescriptor)) != null) {
            return object;
        }
        return null;
    }

    private TypeCheckerState createTypeCheckerState(List<TypeParameterDescriptor> list, List<TypeParameterDescriptor> list2) {
        if (list == null) {
            OverridingUtil.$$$reportNull$$$0(40);
        }
        if (list2 == null) {
            OverridingUtil.$$$reportNull$$$0(41);
        }
        assert (list.size() == list2.size()) : "Should be the same number of type parameters: " + list + " vs " + list2;
        if (list.isEmpty()) {
            TypeCheckerState typeCheckerState = new OverridingUtilTypeSystemContext(null, this.equalityAxioms, this.kotlinTypeRefiner, this.kotlinTypePreparator, this.customSubtype).newTypeCheckerState(true, true);
            if (typeCheckerState == null) {
                OverridingUtil.$$$reportNull$$$0(42);
            }
            return typeCheckerState;
        }
        HashMap<TypeConstructor, TypeConstructor> hashMap = new HashMap<TypeConstructor, TypeConstructor>();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(list.get(i).getTypeConstructor(), list2.get(i).getTypeConstructor());
        }
        TypeCheckerState typeCheckerState = new OverridingUtilTypeSystemContext(hashMap, this.equalityAxioms, this.kotlinTypeRefiner, this.kotlinTypePreparator, this.customSubtype).newTypeCheckerState(true, true);
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(43);
        }
        return typeCheckerState;
    }

    private static OverrideCompatibilityInfo checkReceiverAndParameterCount(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2) {
        if (callableDescriptor.getExtensionReceiverParameter() == null != (callableDescriptor2.getExtensionReceiverParameter() == null)) {
            return OverrideCompatibilityInfo.incompatible("Receiver presence mismatch");
        }
        if (callableDescriptor.getValueParameters().size() != callableDescriptor2.getValueParameters().size()) {
            return OverrideCompatibilityInfo.incompatible("Value parameter number mismatch");
        }
        return null;
    }

    private static boolean areTypesEquivalent(KotlinType kotlinType, KotlinType kotlinType2, TypeCheckerState typeCheckerState) {
        boolean bl;
        if (kotlinType == null) {
            OverridingUtil.$$$reportNull$$$0(44);
        }
        if (kotlinType2 == null) {
            OverridingUtil.$$$reportNull$$$0(45);
        }
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(46);
        }
        if (bl = KotlinTypeKt.isError(kotlinType) && KotlinTypeKt.isError(kotlinType2)) {
            return true;
        }
        return AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, kotlinType.unwrap(), kotlinType2.unwrap());
    }

    private static boolean areTypeParametersEquivalent(TypeParameterDescriptor iterator2, TypeParameterDescriptor object, TypeCheckerState typeCheckerState) {
        if (iterator2 == null) {
            OverridingUtil.$$$reportNull$$$0(47);
        }
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(48);
        }
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(49);
        }
        iterator2 = iterator2.getUpperBounds();
        object = new ArrayList<KotlinType>(object.getUpperBounds());
        if (iterator2.size() != object.size()) {
            return false;
        }
        iterator2 = iterator2.iterator();
        block0: while (iterator2.hasNext()) {
            KotlinType kotlinType = (KotlinType)iterator2.next();
            ListIterator listIterator = object.listIterator();
            while (listIterator.hasNext()) {
                KotlinType kotlinType2 = (KotlinType)listIterator.next();
                if (!OverridingUtil.areTypesEquivalent(kotlinType, kotlinType2, typeCheckerState)) continue;
                listIterator.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    private static List<KotlinType> compiledValueParameters(CallableDescriptor object) {
        ReceiverParameterDescriptor parameterDescriptor2 = object.getExtensionReceiverParameter();
        ArrayList<KotlinType> arrayList = new ArrayList<KotlinType>();
        if (parameterDescriptor2 != null) {
            arrayList.add(parameterDescriptor2.getType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : object.getValueParameters()) {
            arrayList.add(valueParameterDescriptor.getType());
        }
        return arrayList;
    }

    public void generateOverridesInFunctionGroup(Name object, Collection<? extends CallableMemberDescriptor> collection, Collection<? extends CallableMemberDescriptor> object2, ClassDescriptor classDescriptor, OverridingStrategy overridingStrategy) {
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(50);
        }
        if (collection == null) {
            OverridingUtil.$$$reportNull$$$0(51);
        }
        if (object2 == null) {
            OverridingUtil.$$$reportNull$$$0(52);
        }
        if (classDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(53);
        }
        if (overridingStrategy == null) {
            OverridingUtil.$$$reportNull$$$0(54);
        }
        object = new LinkedHashSet<CallableMemberDescriptor>(collection);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = (CallableMemberDescriptor)object2.next();
            object3 = this.extractAndBindOverridesForMember((CallableMemberDescriptor)object3, collection, classDescriptor, overridingStrategy);
            object.removeAll((Collection<?>)object3);
        }
        OverridingUtil.createAndBindFakeOverrides(classDescriptor, (Collection<CallableMemberDescriptor>)object, overridingStrategy);
    }

    public static boolean isVisibleForOverride(MemberDescriptor memberDescriptor, MemberDescriptor memberDescriptor2, boolean bl) {
        if (memberDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(55);
        }
        if (memberDescriptor2 == null) {
            OverridingUtil.$$$reportNull$$$0(56);
        }
        return !DescriptorVisibilities.isPrivate(memberDescriptor2.getVisibility()) && DescriptorVisibilities.isVisibleIgnoringReceiver(memberDescriptor2, memberDescriptor, bl);
    }

    private Collection<CallableMemberDescriptor> extractAndBindOverridesForMember(CallableMemberDescriptor callableMemberDescriptor, Collection<? extends CallableMemberDescriptor> object, ClassDescriptor classDescriptor, OverridingStrategy overridingStrategy) {
        if (callableMemberDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(57);
        }
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(58);
        }
        if (classDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(59);
        }
        if (overridingStrategy == null) {
            OverridingUtil.$$$reportNull$$$0(60);
        }
        ArrayList<CallableMemberDescriptor> arrayList = new ArrayList<CallableMemberDescriptor>(object.size());
        SmartSet smartSet = SmartSet.create();
        object = object.iterator();
        while (object.hasNext()) {
            CallableMemberDescriptor callableMemberDescriptor2 = (CallableMemberDescriptor)object.next();
            OverrideCompatibilityInfo.Result result = this.isOverridableBy(callableMemberDescriptor2, callableMemberDescriptor, classDescriptor).getResult();
            boolean bl = OverridingUtil.isVisibleForOverride(callableMemberDescriptor, callableMemberDescriptor2, false);
            switch (result) {
                case OVERRIDABLE: {
                    if (bl) {
                        smartSet.add((CallableMemberDescriptor)callableMemberDescriptor2);
                    }
                    arrayList.add(callableMemberDescriptor2);
                    break;
                }
                case CONFLICT: {
                    if (bl) {
                        overridingStrategy.overrideConflict(callableMemberDescriptor2, callableMemberDescriptor);
                    }
                    arrayList.add(callableMemberDescriptor2);
                }
            }
        }
        overridingStrategy.setOverriddenDescriptors(callableMemberDescriptor, (Collection<? extends CallableMemberDescriptor>)((Object)smartSet));
        return arrayList;
    }

    private static boolean allHasSameContainingDeclaration(Collection<CallableMemberDescriptor> collection) {
        if (collection == null) {
            OverridingUtil.$$$reportNull$$$0(61);
        }
        if (collection.size() < 2) {
            return true;
        }
        final DeclarationDescriptor declarationDescriptor = collection.iterator().next().getContainingDeclaration();
        return CollectionsKt.all(collection, (Function1)new Function1<CallableMemberDescriptor, Boolean>(){

            public final Boolean invoke(CallableMemberDescriptor callableMemberDescriptor) {
                return callableMemberDescriptor.getContainingDeclaration() == declarationDescriptor;
            }
        });
    }

    private static void createAndBindFakeOverrides(ClassDescriptor classDescriptor, Collection<CallableMemberDescriptor> linkedList, OverridingStrategy overridingStrategy) {
        if (classDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(62);
        }
        if (linkedList == null) {
            OverridingUtil.$$$reportNull$$$0(63);
        }
        if (overridingStrategy == null) {
            OverridingUtil.$$$reportNull$$$0(64);
        }
        if (OverridingUtil.allHasSameContainingDeclaration(linkedList)) {
            for (CallableMemberDescriptor callableMemberDescriptor : linkedList) {
                OverridingUtil.createAndBindFakeOverride(Collections.singleton(callableMemberDescriptor), classDescriptor, overridingStrategy);
            }
            return;
        }
        linkedList = new LinkedList<CallableMemberDescriptor>(linkedList);
        while (!linkedList.isEmpty()) {
            Object object = VisibilityUtilKt.findMemberWithMaxVisibility(linkedList);
            object = OverridingUtil.extractMembersOverridableInBothWays((CallableMemberDescriptor)object, linkedList, overridingStrategy);
            OverridingUtil.createAndBindFakeOverride(object, classDescriptor, overridingStrategy);
        }
    }

    public static boolean isMoreSpecific(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2) {
        if (callableDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(65);
        }
        if (callableDescriptor2 == null) {
            OverridingUtil.$$$reportNull$$$0(66);
        }
        KotlinType kotlinType = callableDescriptor.getReturnType();
        KotlinType kotlinType2 = callableDescriptor2.getReturnType();
        assert (kotlinType != null) : "Return type of " + callableDescriptor + " is null";
        assert (kotlinType2 != null) : "Return type of " + callableDescriptor2 + " is null";
        if (!OverridingUtil.isVisibilityMoreSpecific(callableDescriptor, callableDescriptor2)) {
            return false;
        }
        TypeCheckerState typeCheckerState = DEFAULT.createTypeCheckerState(callableDescriptor.getTypeParameters(), callableDescriptor2.getTypeParameters());
        if (callableDescriptor instanceof FunctionDescriptor) {
            assert (callableDescriptor2 instanceof FunctionDescriptor) : "b is " + callableDescriptor2.getClass();
            return OverridingUtil.isReturnTypeMoreSpecific(callableDescriptor, kotlinType, callableDescriptor2, kotlinType2, typeCheckerState);
        }
        if (callableDescriptor instanceof PropertyDescriptor) {
            assert (callableDescriptor2 instanceof PropertyDescriptor) : "b is " + callableDescriptor2.getClass();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)callableDescriptor;
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)callableDescriptor2;
            if (!OverridingUtil.isAccessorMoreSpecific(propertyDescriptor.getSetter(), propertyDescriptor2.getSetter())) {
                return false;
            }
            if (propertyDescriptor.isVar() && propertyDescriptor2.isVar()) {
                return AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, kotlinType.unwrap(), kotlinType2.unwrap());
            }
            return (propertyDescriptor.isVar() || !propertyDescriptor2.isVar()) && OverridingUtil.isReturnTypeMoreSpecific(callableDescriptor, kotlinType, callableDescriptor2, kotlinType2, typeCheckerState);
        }
        throw new IllegalArgumentException("Unexpected callable: " + callableDescriptor.getClass());
    }

    private static boolean isVisibilityMoreSpecific(DeclarationDescriptorWithVisibility object, DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility) {
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(67);
        }
        if (declarationDescriptorWithVisibility == null) {
            OverridingUtil.$$$reportNull$$$0(68);
        }
        return (object = DescriptorVisibilities.compare(object.getVisibility(), declarationDescriptorWithVisibility.getVisibility())) == null || (Integer)object >= 0;
    }

    private static boolean isAccessorMoreSpecific(PropertyAccessorDescriptor propertyAccessorDescriptor, PropertyAccessorDescriptor propertyAccessorDescriptor2) {
        if (propertyAccessorDescriptor == null || propertyAccessorDescriptor2 == null) {
            return true;
        }
        return OverridingUtil.isVisibilityMoreSpecific(propertyAccessorDescriptor, propertyAccessorDescriptor2);
    }

    private static boolean isMoreSpecificThenAllOf(CallableDescriptor callableDescriptor, Collection<CallableDescriptor> object) {
        if (callableDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(69);
        }
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(70);
        }
        object = object.iterator();
        while (object.hasNext()) {
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)object.next();
            if (OverridingUtil.isMoreSpecific(callableDescriptor, callableDescriptor2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isReturnTypeMoreSpecific(CallableDescriptor callableDescriptor, KotlinType kotlinType, CallableDescriptor callableDescriptor2, KotlinType kotlinType2, TypeCheckerState typeCheckerState) {
        if (callableDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(71);
        }
        if (kotlinType == null) {
            OverridingUtil.$$$reportNull$$$0(72);
        }
        if (callableDescriptor2 == null) {
            OverridingUtil.$$$reportNull$$$0(73);
        }
        if (kotlinType2 == null) {
            OverridingUtil.$$$reportNull$$$0(74);
        }
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(75);
        }
        return AbstractTypeChecker.INSTANCE.isSubtypeOf(typeCheckerState, kotlinType.unwrap(), kotlinType2.unwrap());
    }

    public static <H> H selectMostSpecificMember(Collection<H> object, Function1<H, CallableDescriptor> function1) {
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(76);
        }
        if (function1 == null) {
            OverridingUtil.$$$reportNull$$$0(77);
        }
        assert (!object.isEmpty()) : "Should have at least one overridable descriptor";
        if (object.size() == 1) {
            Object object2 = CollectionsKt.first((Iterable)((Object)object));
            if (object2 == null) {
                OverridingUtil.$$$reportNull$$$0(78);
            }
            return (H)object2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        List list = CollectionsKt.map((Iterable)((Object)object), function1);
        Object object3 = CollectionsKt.first((Iterable)((Object)object));
        CallableDescriptor callableDescriptor = (CallableDescriptor)function1.invoke(object3);
        object = object.iterator();
        while (object.hasNext()) {
            Object object4 = object.next();
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)function1.invoke(object4);
            if (OverridingUtil.isMoreSpecificThenAllOf(callableDescriptor2, list)) {
                arrayList.add(object4);
            }
            if (!OverridingUtil.isMoreSpecific(callableDescriptor2, callableDescriptor) || OverridingUtil.isMoreSpecific(callableDescriptor, callableDescriptor2)) continue;
            object3 = object4;
        }
        if (arrayList.isEmpty()) {
            Object object4 = object3;
            if (object4 == null) {
                OverridingUtil.$$$reportNull$$$0(79);
            }
            return (H)object4;
        }
        if (arrayList.size() == 1) {
            Object object5 = CollectionsKt.first(arrayList);
            if (object5 == null) {
                OverridingUtil.$$$reportNull$$$0(80);
            }
            return (H)object5;
        }
        object = null;
        for (Object e : arrayList) {
            if (FlexibleTypesKt.isFlexible(((CallableDescriptor)function1.invoke(e)).getReturnType())) continue;
            object = e;
            break;
        }
        if (object != null) {
            Iterator iterator2 = object;
            if (iterator2 == null) {
                OverridingUtil.$$$reportNull$$$0(81);
            }
            return (H)iterator2;
        }
        Object object6 = CollectionsKt.first(arrayList);
        if (object6 == null) {
            OverridingUtil.$$$reportNull$$$0(82);
        }
        return (H)object6;
    }

    private static void createAndBindFakeOverride(Collection<CallableMemberDescriptor> collection, ClassDescriptor memberDescriptor, OverridingStrategy overridingStrategy) {
        Object object;
        boolean bl;
        if (collection == null) {
            OverridingUtil.$$$reportNull$$$0(83);
        }
        if (memberDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(84);
        }
        if (overridingStrategy == null) {
            OverridingUtil.$$$reportNull$$$0(85);
        }
        collection = (bl = (object = OverridingUtil.filterVisibleFakeOverrides((ClassDescriptor)memberDescriptor, collection)).isEmpty()) ? collection : object;
        object = OverridingUtil.determineModalityForFakeOverride(collection, (ClassDescriptor)memberDescriptor);
        DescriptorVisibility descriptorVisibility = bl ? DescriptorVisibilities.INVISIBLE_FAKE : DescriptorVisibilities.INHERITED;
        CallableMemberDescriptor callableMemberDescriptor = OverridingUtil.selectMostSpecificMember(collection, new Function1<CallableMemberDescriptor, CallableDescriptor>(){

            public final CallableMemberDescriptor invoke(CallableMemberDescriptor callableMemberDescriptor) {
                return callableMemberDescriptor;
            }
        });
        memberDescriptor = callableMemberDescriptor.copy(memberDescriptor, (Modality)((Object)object), descriptorVisibility, CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
        overridingStrategy.setOverriddenDescriptors((CallableMemberDescriptor)memberDescriptor, collection);
        assert (!memberDescriptor.getOverriddenDescriptors().isEmpty()) : "Overridden descriptors should be set for " + (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE);
        overridingStrategy.addFakeOverride((CallableMemberDescriptor)memberDescriptor);
    }

    private static Modality determineModalityForFakeOverride(Collection<CallableMemberDescriptor> object, ClassDescriptor classDescriptor) {
        boolean bl;
        Object object2;
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(86);
        }
        if (classDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(87);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator<CallableMemberDescriptor> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            switch (object2.getModality()) {
                case FINAL: {
                    Modality modality = Modality.FINAL;
                    if (modality == null) {
                        OverridingUtil.$$$reportNull$$$0(88);
                    }
                    return modality;
                }
                case SEALED: {
                    throw new IllegalStateException("Member cannot have SEALED modality: " + object2);
                }
                case OPEN: {
                    bl2 = true;
                    break;
                }
                case ABSTRACT: {
                    bl3 = true;
                }
            }
        }
        boolean bl4 = bl = classDescriptor.isExpect() && classDescriptor.getModality() != Modality.ABSTRACT && classDescriptor.getModality() != Modality.SEALED;
        if (bl2 && !bl3) {
            Modality modality = Modality.OPEN;
            if (modality == null) {
                OverridingUtil.$$$reportNull$$$0(89);
            }
            return modality;
        }
        if (!bl2 && bl3) {
            Modality modality = bl ? classDescriptor.getModality() : Modality.ABSTRACT;
            if (modality == null) {
                OverridingUtil.$$$reportNull$$$0(90);
            }
            return modality;
        }
        object2 = new HashSet();
        object = object.iterator();
        while (object.hasNext()) {
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)object.next();
            object2.addAll(OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor));
        }
        return OverridingUtil.getMinimalModality(OverridingUtil.filterOutOverridden(object2), bl, classDescriptor.getModality());
    }

    private static Modality getMinimalModality(Collection<CallableMemberDescriptor> object, boolean bl, Modality modality) {
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(91);
        }
        if (modality == null) {
            OverridingUtil.$$$reportNull$$$0(92);
        }
        Object object2 = Modality.ABSTRACT;
        object = object.iterator();
        while (object.hasNext()) {
            Object object3 = (CallableMemberDescriptor)object.next();
            object3 = bl && object3.getModality() == Modality.ABSTRACT ? modality : object3.getModality();
            if (((Enum)object3).compareTo(object2) >= 0) continue;
            object2 = object3;
        }
        Modality modality2 = object2;
        if (modality2 == null) {
            OverridingUtil.$$$reportNull$$$0(93);
        }
        return modality2;
    }

    public static Collection<CallableMemberDescriptor> filterVisibleFakeOverrides(final ClassDescriptor classDescriptor, Collection<CallableMemberDescriptor> collection) {
        if (classDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(94);
        }
        if (collection == null) {
            OverridingUtil.$$$reportNull$$$0(95);
        }
        List list = CollectionsKt.filter(collection, (Function1)new Function1<CallableMemberDescriptor, Boolean>(){

            public final Boolean invoke(CallableMemberDescriptor callableMemberDescriptor) {
                return !DescriptorVisibilities.isPrivate(callableMemberDescriptor.getVisibility()) && DescriptorVisibilities.isVisibleIgnoringReceiver(callableMemberDescriptor, classDescriptor, false);
            }
        });
        if (list == null) {
            OverridingUtil.$$$reportNull$$$0(96);
        }
        return list;
    }

    public static <H> Collection<H> extractMembersOverridableInBothWays(H h, Collection<H> object, Function1<H, CallableDescriptor> function1, Function1<H, Unit> function12) {
        if (h == null) {
            OverridingUtil.$$$reportNull$$$0(97);
        }
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(98);
        }
        if (function1 == null) {
            OverridingUtil.$$$reportNull$$$0(99);
        }
        if (function12 == null) {
            OverridingUtil.$$$reportNull$$$0(100);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(h);
        CallableDescriptor callableDescriptor = (CallableDescriptor)function1.invoke(h);
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            Object object2 = (CallableDescriptor)function1.invoke(e);
            if (h == e) {
                object.remove();
                continue;
            }
            if ((object2 = OverridingUtil.getBothWaysOverridability(callableDescriptor, object2)) == OverrideCompatibilityInfo.Result.OVERRIDABLE) {
                arrayList.add(e);
                object.remove();
                continue;
            }
            if (object2 != OverrideCompatibilityInfo.Result.CONFLICT) continue;
            function12.invoke(e);
            object.remove();
        }
        return arrayList;
    }

    public static OverrideCompatibilityInfo.Result getBothWaysOverridability(CallableDescriptor object, CallableDescriptor callableDescriptor) {
        OverrideCompatibilityInfo.Result result = DEFAULT.isOverridableBy(callableDescriptor, (CallableDescriptor)object, null).getResult();
        object = DEFAULT.isOverridableBy((CallableDescriptor)object, callableDescriptor, null).getResult();
        if (result == OverrideCompatibilityInfo.Result.OVERRIDABLE && object == OverrideCompatibilityInfo.Result.OVERRIDABLE) {
            return OverrideCompatibilityInfo.Result.OVERRIDABLE;
        }
        if (result == OverrideCompatibilityInfo.Result.CONFLICT || object == OverrideCompatibilityInfo.Result.CONFLICT) {
            return OverrideCompatibilityInfo.Result.CONFLICT;
        }
        return OverrideCompatibilityInfo.Result.INCOMPATIBLE;
    }

    private static Collection<CallableMemberDescriptor> extractMembersOverridableInBothWays(final CallableMemberDescriptor callableMemberDescriptor, Queue<CallableMemberDescriptor> queue, final OverridingStrategy overridingStrategy) {
        if (callableMemberDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(102);
        }
        if (queue == null) {
            OverridingUtil.$$$reportNull$$$0(103);
        }
        if (overridingStrategy == null) {
            OverridingUtil.$$$reportNull$$$0(104);
        }
        return OverridingUtil.extractMembersOverridableInBothWays(callableMemberDescriptor, queue, new Function1<CallableMemberDescriptor, CallableDescriptor>(){

            public final CallableDescriptor invoke(CallableMemberDescriptor callableMemberDescriptor) {
                return callableMemberDescriptor;
            }
        }, new Function1<CallableMemberDescriptor, Unit>(){

            public final Unit invoke(CallableMemberDescriptor callableMemberDescriptor2) {
                overridingStrategy.inheritanceConflict(callableMemberDescriptor, callableMemberDescriptor2);
                return Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void resolveUnknownVisibilityForMember(CallableMemberDescriptor object, Function1<CallableMemberDescriptor, Unit> function1) {
        void var3_6;
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(105);
        }
        for (CallableMemberDescriptor object22 : object.getOverriddenDescriptors()) {
            if (object22.getVisibility() != DescriptorVisibilities.INHERITED) continue;
            OverridingUtil.resolveUnknownVisibilityForMember(object22, function1);
        }
        if (object.getVisibility() != DescriptorVisibilities.INHERITED) {
            return;
        }
        DescriptorVisibility descriptorVisibility = OverridingUtil.computeVisibilityToInherit((CallableMemberDescriptor)object);
        if (descriptorVisibility == null) {
            if (function1 != null) {
                function1.invoke(object);
            }
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
        } else {
            DescriptorVisibility descriptorVisibility3 = descriptorVisibility;
        }
        if (object instanceof PropertyDescriptorImpl) {
            ((PropertyDescriptorImpl)object).setVisibility((DescriptorVisibility)var3_6);
            for (PropertyAccessorDescriptor propertyAccessorDescriptor : ((PropertyDescriptor)object).getAccessors()) {
                OverridingUtil.resolveUnknownVisibilityForMember(propertyAccessorDescriptor, descriptorVisibility == null ? null : function1);
            }
            return;
        }
        if (object instanceof FunctionDescriptorImpl) {
            ((FunctionDescriptorImpl)object).setVisibility((DescriptorVisibility)var3_6);
            return;
        }
        assert (object instanceof PropertyAccessorDescriptorImpl);
        object = (PropertyAccessorDescriptorImpl)object;
        ((PropertyAccessorDescriptorImpl)object).setVisibility((DescriptorVisibility)var3_6);
        if (var3_6 != ((PropertyAccessorDescriptorImpl)object).getCorrespondingProperty().getVisibility()) {
            ((PropertyAccessorDescriptorImpl)object).setDefault(false);
        }
    }

    private static DescriptorVisibility computeVisibilityToInherit(CallableMemberDescriptor object) {
        Object object2;
        DescriptorVisibility descriptorVisibility;
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(106);
        }
        if ((descriptorVisibility = OverridingUtil.findMaxVisibility(object2 = object.getOverriddenDescriptors())) == null) {
            return null;
        }
        if (object.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (CallableMemberDescriptor)object.next();
                if (object2.getModality() == Modality.ABSTRACT || object2.getVisibility().equals(descriptorVisibility)) continue;
                return null;
            }
            return descriptorVisibility;
        }
        return descriptorVisibility.normalize();
    }

    public static DescriptorVisibility findMaxVisibility(Collection<? extends CallableMemberDescriptor> collection) {
        Object object;
        if (collection == null) {
            OverridingUtil.$$$reportNull$$$0(107);
        }
        if (collection.isEmpty()) {
            return DescriptorVisibilities.DEFAULT_VISIBILITY;
        }
        Object object2 = null;
        for (CallableMemberDescriptor callableMemberDescriptor : collection) {
            object = callableMemberDescriptor.getVisibility();
            assert (object != DescriptorVisibilities.INHERITED) : "Visibility should have been computed for " + callableMemberDescriptor;
            if (object2 == null) {
                object2 = object;
                continue;
            }
            Integer n = DescriptorVisibilities.compare((DescriptorVisibility)object, (DescriptorVisibility)object2);
            if (n == null) {
                object2 = null;
                continue;
            }
            if (n <= 0) continue;
            object2 = object;
        }
        if (object2 == null) {
            return null;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : collection) {
            object = DescriptorVisibilities.compare((DescriptorVisibility)object2, callableMemberDescriptor.getVisibility());
            if (object != null && (Integer)object >= 0) continue;
            return null;
        }
        return object2;
    }

    static {
        DEFAULT_TYPE_CONSTRUCTOR_EQUALITY = new KotlinTypeChecker.TypeConstructorEquality(){

            @Override
            public final boolean equals(TypeConstructor typeConstructor2, TypeConstructor typeConstructor3) {
                if (typeConstructor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeConstructor3 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return typeConstructor2.equals(typeConstructor3);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "a";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "b";
                    }
                }
                objectArray[1] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil$1";
                objectArray[2] = "equals";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DEFAULT = new OverridingUtil(DEFAULT_TYPE_CONSTRUCTOR_EQUALITY, KotlinTypeRefiner.Default.INSTANCE, KotlinTypePreparator.Default.INSTANCE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTypeRefiner";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTypePreparator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSubtype";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityAxioms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "axioms";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateSet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformFirst";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 22: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superDescriptor";
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDescriptor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstParameters";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondParameters";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInSuper";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInSub";
                break;
            }
            case 46: 
            case 49: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCheckerState";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypeParameter";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTypeParameter";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersFromSupertypes";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersFromCurrent";
                break;
            }
            case 53: 
            case 59: 
            case 62: 
            case 84: 
            case 87: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 54: 
            case 60: 
            case 64: 
            case 85: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriding";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromSuper";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromCurrent";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsFromSuper";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notOverridden";
                break;
            }
            case 65: 
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 66: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 70: 
            case 86: 
            case 91: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aReturnType";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bReturnType";
                break;
            }
            case 76: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overridables";
                break;
            }
            case 77: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorByHandle";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classModality";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFilter";
                break;
            }
            case 97: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrider";
                break;
            }
            case 98: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractFrom";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onConflict";
                break;
            }
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverrides";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenDeclarations";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isOverridableBy";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "isOverridableByWithoutExternalConditions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeCheckerState";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMostSpecificMember";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "determineModalityForFakeOverride";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimalModality";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "filterVisibleFakeOverrides";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMembersOverridableInBothWays";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWithTypeRefiner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWithTypePreparatorAndCustomSubtype";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterOutOverridden";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterOverrides";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "overrides";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenDeclarations";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectOverriddenDeclarations";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableBy";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableByWithoutExternalConditions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBasicOverridabilityProblem";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createTypeCheckerState";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "areTypesEquivalent";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "areTypeParametersEquivalent";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "generateOverridesInFunctionGroup";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleForOverride";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "extractAndBindOverridesForMember";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "allHasSameContainingDeclaration";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createAndBindFakeOverrides";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isMoreSpecific";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isVisibilityMoreSpecific";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isMoreSpecificThenAllOf";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeMoreSpecific";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "selectMostSpecificMember";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createAndBindFakeOverride";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "determineModalityForFakeOverride";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getMinimalModality";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "filterVisibleFakeOverrides";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "extractMembersOverridableInBothWays";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "resolveUnknownVisibilityForMember";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "computeVisibilityToInherit";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "findMaxVisibility";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }

    public static class OverrideCompatibilityInfo {
        private static final OverrideCompatibilityInfo SUCCESS = new OverrideCompatibilityInfo(Result.OVERRIDABLE, "SUCCESS");
        private final Result overridable;
        private final String debugMessage;

        public static OverrideCompatibilityInfo success() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = SUCCESS;
            if (overrideCompatibilityInfo == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(0);
            }
            return overrideCompatibilityInfo;
        }

        public static OverrideCompatibilityInfo incompatible(String string) {
            if (string == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(1);
            }
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, string);
        }

        public static OverrideCompatibilityInfo conflict(String string) {
            if (string == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(2);
            }
            return new OverrideCompatibilityInfo(Result.CONFLICT, string);
        }

        public OverrideCompatibilityInfo(Result result, String string) {
            if (result == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(3);
            }
            if (string == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(4);
            }
            this.overridable = result;
            this.debugMessage = string;
        }

        public Result getResult() {
            Result result = this.overridable;
            if (result == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(5);
            }
            return result;
        }

        public String toString() {
            return (Object)((Object)this.overridable) + ": " + this.debugMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil$OverrideCompatibilityInfo";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "success";
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "success";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil$OverrideCompatibilityInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugMessage";
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "incompatible";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "conflict";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                }
            }
            throw runtimeException;
        }

        public static enum Result {
            OVERRIDABLE,
            INCOMPATIBLE,
            CONFLICT;

        }
    }
}

