/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class KClassValue
extends ConstantValue<Value> {
    public static final Companion Companion = new Companion(null);

    public KClassValue(Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        super(value);
    }

    public KClassValue(ClassLiteralValue classLiteralValue) {
        Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
        this(new Value.NormalClass(classLiteralValue));
    }

    public KClassValue(ClassId classId, int n) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        this(new ClassLiteralValue(classId, n));
    }

    @Override
    public final KotlinType getType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
        ClassDescriptor classDescriptor = moduleDescriptor.getBuiltIns().getKClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
        return KotlinTypeFactory.simpleNotNullType(typeAttributes, classDescriptor, CollectionsKt.listOf((Object)new TypeProjectionImpl(this.getArgumentType(moduleDescriptor))));
    }

    public final KotlinType getArgumentType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Object object = (Value)this.getValue();
        if (object instanceof Value.LocalClass) {
            return ((Value.LocalClass)this.getValue()).getType();
        }
        if (object instanceof Value.NormalClass) {
            object = ((Value.NormalClass)this.getValue()).getValue();
            Object object2 = ((ClassLiteralValue)object).component1();
            int n = ((ClassLiteralValue)object).component2();
            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object2);
            if (classDescriptor == null) {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = ((ClassId)object2).toString();
                stringArray2[1] = String.valueOf(n);
                return ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_KCLASS_CONSTANT_VALUE, stringArray2);
            }
            object2 = classDescriptor;
            SimpleType simpleType = classDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            object2 = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType);
            for (int i = 0; i < n; ++i) {
                object2 = moduleDescriptor.getBuiltIns().getArrayType(Variance.INVARIANT, (KotlinType)object2);
            }
            return (KotlinType)object2;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final class Companion {
        private Companion() {
        }

        public final ConstantValue<?> create(KotlinType object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            if (KotlinTypeKt.isError((KotlinType)object)) {
                return null;
            }
            Annotated annotated = object;
            int n = 0;
            while (KotlinBuiltIns.isArray(annotated)) {
                annotated = ((TypeProjection)CollectionsKt.single(annotated.getArguments())).getType();
                ++n;
            }
            if ((annotated = annotated.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)annotated);
                if (classId == null) {
                    return new KClassValue(new Value.LocalClass((KotlinType)object));
                }
                object = classId;
                return new KClassValue((ClassId)object, n);
            }
            if (annotated instanceof TypeParameterDescriptor) {
                return new KClassValue(ClassId.Companion.topLevel(StandardNames.FqNames.any.toSafe()), 0);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public static abstract class Value {
        private Value() {
        }

        public /* synthetic */ Value(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public static final class LocalClass
        extends Value {
            private final KotlinType type;

            public LocalClass(KotlinType kotlinType) {
                Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
                super(null);
                this.type = kotlinType;
            }

            public final KotlinType getType() {
                return this.type;
            }

            public final String toString() {
                return "LocalClass(type=" + this.type + ')';
            }

            public final int hashCode() {
                return this.type.hashCode();
            }

            public final boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof LocalClass)) {
                    return false;
                }
                object = (LocalClass)object;
                return Intrinsics.areEqual((Object)this.type, (Object)((LocalClass)object).type);
            }
        }

        public static final class NormalClass
        extends Value {
            private final ClassLiteralValue value;

            public NormalClass(ClassLiteralValue classLiteralValue) {
                Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
                super(null);
                this.value = classLiteralValue;
            }

            public final ClassLiteralValue getValue() {
                return this.value;
            }

            public final ClassId getClassId() {
                return this.value.getClassId();
            }

            public final int getArrayDimensions() {
                return this.value.getArrayNestedness();
            }

            public final String toString() {
                return "NormalClass(value=" + this.value + ')';
            }

            public final int hashCode() {
                return this.value.hashCode();
            }

            public final boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof NormalClass)) {
                    return false;
                }
                object = (NormalClass)object;
                return Intrinsics.areEqual((Object)this.value, (Object)((NormalClass)object).value);
            }
        }
    }
}

