/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToValueClassTypeValueParameters(CallableMemberDescriptor iterator2) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        ClassConstructorDescriptor classConstructorDescriptor = iterator2 instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)((Object)iterator2) : null;
        if (classConstructorDescriptor == null) {
            return false;
        }
        iterator2 = classConstructorDescriptor;
        if (DescriptorVisibilities.isPrivate(classConstructorDescriptor.getVisibility())) {
            return false;
        }
        ClassDescriptor classDescriptor = iterator2.getConstructedClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
        if (InlineClassesUtilsKt.isValueClass(classDescriptor)) {
            return false;
        }
        if (DescriptorUtils.isSealedClass(iterator2.getConstructedClass())) {
            return false;
        }
        List<ValueParameterDescriptor> list = iterator2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        iterator2 = list;
        if (!(iterator2 instanceof Collection) || !((Collection)((Object)iterator2)).isEmpty()) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                object = (ValueParameterDescriptor)object;
                KotlinType kotlinType = object.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                if (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isValueClassThatRequiresMangling(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return InlineClassesUtilsKt.isValueClass(declarationDescriptor) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)declarationDescriptor);
    }

    public static final boolean isValueClassThatRequiresMangling(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            return InlineClassesUtilsKt.isInlineClass(classifierDescriptor) && InlineClassManglingRulesKt.isValueClassThatRequiresMangling(classifierDescriptor2) || InlineClassesUtilsKt.needsMfvcFlattening(kotlinType);
        }
        return false;
    }

    private static final boolean requiresFunctionNameManglingInParameterTypes(KotlinType kotlinType) {
        return InlineClassManglingRulesKt.isValueClassThatRequiresMangling(kotlinType) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling(kotlinType, true);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor) {
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor), (Object)StandardNames.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(KotlinType annotated, boolean bl) {
        TypeParameterDescriptor typeParameterDescriptor = (annotated = annotated.getConstructor().getDeclarationDescriptor()) instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)annotated : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        annotated = typeParameterDescriptor;
        return (bl || !InlineClassesUtilsKt.isMultiFieldValueClass((DeclarationDescriptor)annotated)) && InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)annotated));
    }
}

