/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.FilteredAnnotations;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;

public final class TypeSubstitutionKt {
    public static final KotlinType replace(KotlinType kotlinType, List<? extends TypeProjection> list, Annotations kMappedMarker, List<? extends TypeProjection> list2) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)kMappedMarker, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        if ((list.isEmpty() || list == kotlinType.getArguments()) && kMappedMarker == kotlinType.getAnnotations()) {
            return kotlinType;
        }
        kMappedMarker = TypeAttributesKt.replaceAnnotations(kotlinType.getAttributes(), kMappedMarker instanceof FilteredAnnotations && ((FilteredAnnotations)kMappedMarker).isEmpty() ? Annotations.Companion.getEMPTY() : kMappedMarker);
        if ((kotlinType = kotlinType.unwrap()) instanceof FlexibleType) {
            return KotlinTypeFactory.flexibleType(TypeSubstitutionKt.replace(((FlexibleType)kotlinType).getLowerBound(), list, (TypeAttributes)kMappedMarker), TypeSubstitutionKt.replace(((FlexibleType)kotlinType).getUpperBound(), list2, (TypeAttributes)kMappedMarker));
        }
        if (kotlinType instanceof SimpleType) {
            return TypeSubstitutionKt.replace((SimpleType)kotlinType, list, (TypeAttributes)kMappedMarker);
        }
        throw new NoWhenBranchMatchedException();
    }

    public static /* synthetic */ KotlinType replace$default(KotlinType kotlinType, List list, Annotations annotations, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = kotlinType.getArguments();
        }
        if ((n & 2) != 0) {
            annotations = kotlinType.getAnnotations();
        }
        if ((n & 4) != 0) {
            list2 = list;
        }
        return TypeSubstitutionKt.replace(kotlinType, list, annotations, list2);
    }

    public static final SimpleType replace(SimpleType simpleType, List<? extends TypeProjection> list, TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        if (list.isEmpty() && typeAttributes == simpleType.getAttributes()) {
            return simpleType;
        }
        if (list.isEmpty()) {
            return simpleType.replaceAttributes(typeAttributes);
        }
        if (simpleType instanceof ErrorType) {
            return ((ErrorType)simpleType).replaceArguments(list);
        }
        return KotlinTypeFactory.simpleType$default(typeAttributes, simpleType.getConstructor(), list, simpleType.isMarkedNullable(), null, 16, null);
    }

    public static /* synthetic */ SimpleType replace$default(SimpleType simpleType, List list, TypeAttributes typeAttributes, int n, Object object) {
        if ((n & 1) != 0) {
            list = simpleType.getArguments();
        }
        if ((n & 2) != 0) {
            typeAttributes = simpleType.getAttributes();
        }
        return TypeSubstitutionKt.replace(simpleType, list, typeAttributes);
    }

    public static final SimpleType asSimpleType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        UnwrappedType unwrappedType = kotlinType.unwrap();
        SimpleType simpleType = unwrappedType instanceof SimpleType ? (SimpleType)unwrappedType : null;
        if (simpleType == null) {
            throw new IllegalStateException(("This is should be simple type: " + kotlinType).toString());
        }
        return simpleType;
    }

    public static final KotlinType replace(KotlinType kotlinType, List<? extends TypeProjection> list, Annotations annotations) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"");
        return TypeSubstitutionKt.replace$default(kotlinType, list, annotations, null, 4, null);
    }
}

