/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public abstract class ParallelProcessor<Task> {
    private static final Object SENTINEL = new Object[0];
    private final int numberOfThreads;
    private final ArrayList<Thread> threads;
    private final ArrayBlockingQueue<Object> queue;
    private final CountDownLatch latch;
    private final int totalWorkload;
    private final AtomicInteger currentProgress = new AtomicInteger(0);

    public ParallelProcessor() {
        this(-1, OS.INSTANCE.getOptimumNumberOfThreads(), null);
    }

    public ParallelProcessor(int n) {
        this(n, OS.INSTANCE.getOptimumNumberOfThreads(), null);
    }

    public ParallelProcessor(int n, int n2) {
        this(n, n2, null);
    }

    public ParallelProcessor(int n, int n2, final Logger logger) {
        this.totalWorkload = n;
        this.numberOfThreads = n2;
        this.latch = new CountDownLatch(this.numberOfThreads);
        this.queue = new ArrayBlockingQueue(n2);
        this.threads = new ArrayList(n2);
        Object object = new ThreadGroup(Thread.currentThread().getThreadGroup(), "ParallelProcessor");
        object = new NamedThreadFactory("Processor", (ThreadGroup)object);
        for (int i = 0; i < n2; ++i) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object object = ParallelProcessor.this;
                    object = ((ParallelProcessor)object).queue;
                    Worker worker = ParallelProcessor.this.createWorker();
                    while (true) {
                        Object object2;
                        try {
                            object2 = ((ArrayBlockingQueue)object).take();
                            if (object2 == SENTINEL) {
                                ParallelProcessor.this.latch.countDown();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            return;
                        }
                        try {
                            worker.process(object2);
                            ParallelProcessor.this.workComplete(ParallelProcessor.this, object2);
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (logger != null) {
                                logger.error("Error during execution of work!", throwable);
                                continue;
                            }
                            throwable.printStackTrace();
                            continue;
                        }
                        finally {
                            ParallelProcessor.this.currentProgress.getAndIncrement();
                            object2 = ParallelProcessor.this.currentProgress;
                            synchronized (object2) {
                                ParallelProcessor.this.currentProgress.notifyAll();
                            }
                            continue;
                        }
                        break;
                    }
                }
            };
            Thread runnable2 = ((NamedThreadFactory)object).newThread(runnable);
            this.threads.add(runnable2);
        }
        for (Thread thread : this.threads) {
            thread.start();
        }
    }

    public abstract Worker createWorker();

    public abstract void workComplete(ParallelProcessor var1, Task var2);

    public boolean hasAvailableWorker() {
        return this.queue.size() < this.numberOfThreads;
    }

    public void process(Task Task) {
        this.queue.put(Task);
    }

    public void waitUntilDone() {
        if (this.totalWorkload > 0) {
            while (this.currentProgress.get() - this.totalWorkload != 0) {
                AtomicInteger atomicInteger = this.currentProgress;
                synchronized (atomicInteger) {
                    this.currentProgress.wait(10000L);
                }
            }
        }
        for (int i = 0; i < this.threads.size(); ++i) {
            this.queue.put(SENTINEL);
        }
        this.latch.await();
    }

    public float getProgress() {
        int n = this.currentProgress.get();
        if (this.totalWorkload == -1) {
            return n;
        }
        if (n == 0) {
            return 0.0f;
        }
        if (n == this.totalWorkload) {
            return 1.0f;
        }
        return (float)n / (float)this.totalWorkload;
    }

    public static interface Worker<Task> {
        public boolean process(Task var1);
    }
}

