/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.tcp.XmppTcpTransportModule;

public class XmppTcpTransportModuleDescriptor
extends ModularXmppClientToServerConnectionModuleDescriptor {
    private final boolean startTls;
    private final boolean directTls;

    public XmppTcpTransportModuleDescriptor(Builder builder) {
        this.startTls = builder.startTls;
        this.directTls = builder.directTls;
    }

    protected Set<Class<? extends StateDescriptor>> getStateDescriptors() {
        HashSet<Class<? extends StateDescriptor>> hashSet = new HashSet<Class<? extends StateDescriptor>>();
        hashSet.add(XmppTcpTransportModule.EstablishingTcpConnectionStateDescriptor.class);
        if (this.startTls) {
            hashSet.add(XmppTcpTransportModule.EstablishTlsStateDescriptor.class);
        }
        if (this.directTls) {
            throw new IllegalArgumentException("DirectTLS is not implemented yet");
        }
        return hashSet;
    }

    protected XmppTcpTransportModule constructXmppConnectionModule(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        return new XmppTcpTransportModule(this, modularXmppClientToServerConnectionInternal);
    }

    public boolean isStartTlsEnabled() {
        return this.startTls;
    }

    public boolean isDirectTlsEnabled() {
        return this.directTls;
    }

    public static final class Builder
    extends ModularXmppClientToServerConnectionModuleDescriptor.Builder {
        private boolean startTls = true;
        private boolean directTls = false;

        private Builder(ModularXmppClientToServerConnectionConfiguration.Builder builder) {
            super(builder);
        }

        public final Builder disableDirectTls() {
            this.directTls = false;
            return this;
        }

        public final Builder disableStartTls() {
            this.startTls = false;
            return this;
        }

        protected final XmppTcpTransportModuleDescriptor build() {
            return new XmppTcpTransportModuleDescriptor(this);
        }
    }
}

