/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonIgnoreUnknownKeys;
import kotlinx.serialization.json.JsonNames;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.DescriptorSchemaCache;
import kotlinx.serialization.json.internal.JsonException;
import kotlinx.serialization.json.internal.JsonNamesMapKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0000\u001a'\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\u001c\u0010\u0014\u001a\u00020\u0003*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0012*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u001b\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0000\u001a&\u0010\u001c\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0003H\u0000\u001ac\u0010\u001e\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00042!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b!\u0012\b\b\u0018\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001a0 2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030$2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020&0$H\u0080\b\u00f8\u0001\u0000\u001a\u0014\u0010'\u001a\u00020\u001a*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\"&\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\" \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"JsonDeserializationNamesKey", "Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "", "", "", "getJsonDeserializationNamesKey", "()Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "JsonSerializationNamesKey", "", "getJsonSerializationNamesKey", "buildDeserializationNamesMap", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "json", "Lkotlinx/serialization/json/Json;", "deserializationNamesMap", "descriptor", "serializationNamesIndices", "strategy", "Lkotlinx/serialization/json/JsonNamingStrategy;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonNamingStrategy;)[Ljava/lang/String;", "getJsonElementName", "index", "namingStrategy", "getJsonNameIndexSlowPath", "name", "decodeCaseInsensitive", "", "getJsonNameIndex", "getJsonNameIndexOrThrow", "suffix", "tryCoerceValue", "peekNull", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "consume", "peekString", "Lkotlin/Function0;", "onEnumCoercing", "", "ignoreUnknownKeys", "kotlinx-serialization-json"})
public final class JsonNamesMapKt {
    private static final DescriptorSchemaCache.Key<Map<String, Integer>> JsonDeserializationNamesKey = new DescriptorSchemaCache.Key();
    private static final DescriptorSchemaCache.Key<String[]> JsonSerializationNamesKey = new DescriptorSchemaCache.Key();

    public static final DescriptorSchemaCache.Key<Map<String, Integer>> getJsonDeserializationNamesKey() {
        return JsonDeserializationNamesKey;
    }

    public static final DescriptorSchemaCache.Key<String[]> getJsonSerializationNamesKey() {
        return JsonSerializationNamesKey;
    }

    private static final Map<String, Integer> buildDeserializationNamesMap(SerialDescriptor serialDescriptor, Json object) {
        Map map = new LinkedHashMap();
        boolean bl = JsonNamesMapKt.decodeCaseInsensitive((Json)object, serialDescriptor);
        object = JsonNamesMapKt.namingStrategy(serialDescriptor, (Json)object);
        int n = serialDescriptor.getElementsCount();
        for (int i = 0; i < n; ++i) {
            Object object2;
            Object object3;
            Object object4 = (String[])serialDescriptor.getElementAnnotations(i);
            Collection collection = new ArrayList();
            Object object5 = object4.iterator();
            while (object5.hasNext()) {
                object3 = object5.next();
                if (!(object3 instanceof JsonNames)) continue;
                collection.add(object3);
            }
            String[] stringArray = (String[])CollectionsKt.singleOrNull((List)((List)collection));
            if (stringArray != null && (stringArray = stringArray.names()) != null) {
                object4 = stringArray;
                int n2 = ((String[])object4).length;
                for (int j = 0; j < n2; ++j) {
                    Object object6;
                    object3 = object5 = object4[j];
                    if (bl) {
                        String string = ((String)object3).toLowerCase(Locale.ROOT);
                        object6 = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    } else {
                        object6 = object3;
                    }
                    JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(map, serialDescriptor, (String)object6, i);
                }
            }
            if (bl) {
                String string = serialDescriptor.getElementName(i).toLowerCase(Locale.ROOT);
                object2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            } else {
                Object object7 = object;
                object2 = object4 = object7 != null ? object7.serialNameForJson(serialDescriptor, i, serialDescriptor.getElementName(i)) : null;
            }
            if (object2 == null) continue;
            object4 = object2;
            JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(map, serialDescriptor, (String)object4, i);
        }
        Map map2 = map;
        if (map2.isEmpty()) {
            return MapsKt.emptyMap();
        }
        return map2;
    }

    public static final Map<String, Integer> deserializationNamesMap(Json json, SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        return JsonSchemaCacheKt.getSchemaCache(json).getOrPut(serialDescriptor, JsonDeserializationNamesKey, () -> JsonNamesMapKt.deserializationNamesMap$lambda$3(serialDescriptor, json));
    }

    public static final String[] serializationNamesIndices(SerialDescriptor serialDescriptor, Json json, JsonNamingStrategy jsonNamingStrategy) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonNamingStrategy, (String)"");
        return JsonSchemaCacheKt.getSchemaCache(json).getOrPut(serialDescriptor, JsonSerializationNamesKey, () -> JsonNamesMapKt.serializationNamesIndices$lambda$4(serialDescriptor, jsonNamingStrategy));
    }

    public static final String getJsonElementName(SerialDescriptor serialDescriptor, Json json, int n) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        JsonNamingStrategy jsonNamingStrategy = JsonNamesMapKt.namingStrategy(serialDescriptor, json);
        if (jsonNamingStrategy == null) {
            return serialDescriptor.getElementName(n);
        }
        return JsonNamesMapKt.serializationNamesIndices(serialDescriptor, json, jsonNamingStrategy)[n];
    }

    public static final JsonNamingStrategy namingStrategy(SerialDescriptor serialDescriptor, Json json) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        if (Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)StructureKind.CLASS.INSTANCE)) {
            return json.getConfiguration().getNamingStrategy();
        }
        return null;
    }

    private static final int getJsonNameIndexSlowPath(SerialDescriptor serialDescriptor, Json json, String string) {
        Integer n = JsonNamesMapKt.deserializationNamesMap(json, serialDescriptor).get(string);
        if (n != null) {
            return n;
        }
        return -3;
    }

    private static final boolean decodeCaseInsensitive(Json json, SerialDescriptor serialDescriptor) {
        return json.getConfiguration().getDecodeEnumsCaseInsensitive() && Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE);
    }

    public static final int getJsonNameIndex(SerialDescriptor serialDescriptor, Json json, String string) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (JsonNamesMapKt.decodeCaseInsensitive(json, serialDescriptor)) {
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            return JsonNamesMapKt.getJsonNameIndexSlowPath(serialDescriptor, json, string2);
        }
        JsonNamingStrategy jsonNamingStrategy = JsonNamesMapKt.namingStrategy(serialDescriptor, json);
        if (jsonNamingStrategy != null) {
            return JsonNamesMapKt.getJsonNameIndexSlowPath(serialDescriptor, json, string);
        }
        int n = serialDescriptor.getElementIndex(string);
        if (n != -3) {
            return n;
        }
        if (!json.getConfiguration().getUseAlternativeNames()) {
            return n;
        }
        return JsonNamesMapKt.getJsonNameIndexSlowPath(serialDescriptor, json, string);
    }

    public static final int getJsonNameIndexOrThrow(SerialDescriptor serialDescriptor, Json json, String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        int n = JsonNamesMapKt.getJsonNameIndex(serialDescriptor, json, string);
        if (n == -3) {
            throw new SerializationException(serialDescriptor.getSerialName() + " does not contain element with name '" + string + '\'' + string2);
        }
        return n;
    }

    public static /* synthetic */ int getJsonNameIndexOrThrow$default(SerialDescriptor serialDescriptor, Json json, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return JsonNamesMapKt.getJsonNameIndexOrThrow(serialDescriptor, json, string, string2);
    }

    public static final boolean tryCoerceValue(Json json, SerialDescriptor serialDescriptor, int n, Function1<? super Boolean, Boolean> function1, Function0<String> function0, Function0<Unit> function02) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        Intrinsics.checkNotNullParameter(function02, (String)"");
        boolean bl = serialDescriptor.isElementOptional(n);
        serialDescriptor = serialDescriptor.getElementDescriptor(n);
        if (bl && !serialDescriptor.isNullable() && ((Boolean)function1.invoke((Object)Boolean.TRUE)).booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE)) {
            boolean bl2;
            if (serialDescriptor.isNullable() && ((Boolean)function1.invoke((Object)Boolean.FALSE)).booleanValue()) {
                return false;
            }
            String string = (String)function0.invoke();
            if (string == null) {
                return false;
            }
            String string2 = string;
            int n2 = JsonNamesMapKt.getJsonNameIndex(serialDescriptor, json, string2);
            boolean bl3 = bl2 = !json.getConfiguration().getExplicitNulls() && serialDescriptor.isNullable();
            if (n2 == -3 && (bl || bl2)) {
                function02.invoke();
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean tryCoerceValue$default(Json json, SerialDescriptor serialDescriptor, int n, Function1 function1, Function0 function0, Function0 function02, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            function02 = tryCoerceValue.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"");
        Intrinsics.checkNotNullParameter((Object)function02, (String)"");
        boolean bl = serialDescriptor.isElementOptional(n);
        serialDescriptor = serialDescriptor.getElementDescriptor(n);
        if (bl && !serialDescriptor.isNullable() && ((Boolean)function1.invoke((Object)Boolean.TRUE)).booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE)) {
            boolean bl2;
            if (serialDescriptor.isNullable() && ((Boolean)function1.invoke((Object)Boolean.FALSE)).booleanValue()) {
                return false;
            }
            String string = (String)function0.invoke();
            if (string == null) {
                return false;
            }
            String string2 = string;
            int n3 = JsonNamesMapKt.getJsonNameIndex(serialDescriptor, json, string2);
            boolean bl3 = bl2 = !json.getConfiguration().getExplicitNulls() && serialDescriptor.isNullable();
            if (n3 == -3 && (bl || bl2)) {
                function02.invoke();
                return true;
            }
        }
        return false;
    }

    public static final boolean ignoreUnknownKeys(SerialDescriptor object, Json object2) {
        block7: {
            block6: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                Intrinsics.checkNotNullParameter((Object)object2, (String)"");
                if (((Json)object2).getConfiguration().getIgnoreUnknownKeys()) break block6;
                if (!((object = (Iterable)object.getAnnotations()) instanceof Collection) || !((Collection)object).isEmpty()) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        object2 = object.next();
                        if (!((object2 = (Annotation)object2) instanceof JsonIgnoreUnknownKeys)) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = false;
                }
                if (!bl) break block7;
            }
            return true;
        }
        return false;
    }

    private static final void buildDeserializationNamesMap$putOrThrow(Map<String, Integer> map, SerialDescriptor object, String string, int n) {
        String string2;
        String string3 = string2 = Intrinsics.areEqual((Object)object.getKind(), (Object)SerialKind.ENUM.INSTANCE) ? "enum value" : "property";
        if (map.containsKey(string)) {
            throw new JsonException("The suggested name '" + string + "' for " + string2 + ' ' + object.getElementName(n) + " is already one of the names for " + string2 + ' ' + object.getElementName(((Number)MapsKt.getValue(map, (Object)string)).intValue()) + " in " + object);
        }
        object = n;
        map.put(string, (Integer)object);
    }

    private static final Map deserializationNamesMap$lambda$3(SerialDescriptor serialDescriptor, Json json) {
        return JsonNamesMapKt.buildDeserializationNamesMap(serialDescriptor, json);
    }

    private static final String[] serializationNamesIndices$lambda$4(SerialDescriptor serialDescriptor, JsonNamingStrategy jsonNamingStrategy) {
        int n = 0;
        int n2 = serialDescriptor.getElementsCount();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            String string = serialDescriptor.getElementName(n3);
            stringArray[n3] = jsonNamingStrategy.serialNameForJson(serialDescriptor, n3, string);
        }
        return stringArray;
    }
}

