/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.e.a.i;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StreamError;

public abstract class XMPPException
extends Exception {
    private static final long serialVersionUID = 6881651633890968625L;

    protected XMPPException() {
    }

    protected XMPPException(String string) {
        super(string);
    }

    protected XMPPException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public static class StreamErrorException
    extends XMPPException {
        private static final long serialVersionUID = 3400556867134848886L;
        private final StreamError streamError;

        public StreamErrorException(StreamError streamError) {
            super(streamError.getCondition().toString() + " You can read more about the meaning of this stream error at http://xmpp.org/rfcs/rfc6120.html#streams-error-conditions\n" + streamError.toString());
            this.streamError = streamError;
        }

        public StreamError getStreamError() {
            return this.streamError;
        }
    }

    public static class FailedNonzaException
    extends XMPPException {
        private static final long serialVersionUID = 1L;
        private final StanzaError.Condition condition;
        private final Nonza nonza;

        public FailedNonzaException(Nonza nonza) {
            this(nonza, null);
        }

        public FailedNonzaException(Nonza nonza, StanzaError.Condition condition) {
            this.condition = condition;
            this.nonza = nonza;
        }

        public StanzaError.Condition getCondition() {
            return this.condition;
        }

        public Nonza getNonza() {
            return this.nonza;
        }
    }

    public static class XMPPErrorException
    extends XMPPException {
        private static final long serialVersionUID = 212790389529249604L;
        private final StanzaError error;
        private final Stanza stanza;
        private final Stanza request;

        public XMPPErrorException(Stanza stanza, StanzaError stanzaError) {
            this(stanza, stanzaError, null);
        }

        public XMPPErrorException(Stanza stanza, StanzaError stanzaError, Stanza stanza2) {
            this.error = stanzaError;
            this.stanza = stanza;
            this.request = stanza2;
        }

        public StanzaError getStanzaError() {
            return this.error;
        }

        public Stanza getStanza() {
            return this.stanza;
        }

        public Stanza getRequest() {
            return this.request;
        }

        @Override
        public String getMessage() {
            i i2;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.stanza != null && (i2 = this.stanza.getFrom()) != null) {
                stringBuilder.append("XMPP error reply received from " + i2 + ": ");
            }
            stringBuilder.append(this.error);
            if (this.request != null) {
                stringBuilder.append(" as result of the following request: ");
                stringBuilder.append(this.request);
            }
            return stringBuilder.toString();
        }

        public static void ifHasErrorThenThrow(Stanza stanza) {
            XMPPErrorException.ifHasErrorThenThrow(stanza, null);
        }

        public static void ifHasErrorThenThrow(Stanza stanza, Stanza stanza2) {
            StanzaError stanzaError = stanza.getError();
            if (stanzaError != null) {
                throw new XMPPErrorException(stanza, stanzaError, stanza2);
            }
        }
    }
}

