/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.NoOpState;
import org.jivesoftware.smack.fsm.State;

public abstract class StateDescriptor {
    private static final Logger LOGGER = Logger.getLogger(StateDescriptor.class.getName());
    private final String stateName;
    private final int xepNum;
    private final String rfcSection;
    private final Set<Property> properties;
    private final Class<? extends State> stateClass;
    private final Constructor<? extends State> stateClassConstructor;
    private final Set<Class<? extends StateDescriptor>> successors = new HashSet<Class<? extends StateDescriptor>>();
    private final Set<Class<? extends StateDescriptor>> predecessors = new HashSet<Class<? extends StateDescriptor>>();
    private final Set<Class<? extends StateDescriptor>> precedenceOver = new HashSet<Class<? extends StateDescriptor>>();
    private final Set<Class<? extends StateDescriptor>> inferiorTo = new HashSet<Class<? extends StateDescriptor>>();
    private transient String referenceCache;

    protected StateDescriptor() {
        this(NoOpState.class, new Property[]{null});
    }

    protected StateDescriptor(Property ... propertyArray) {
        this(NoOpState.class, propertyArray);
    }

    protected StateDescriptor(Class<? extends State> clazz) {
        this(clazz, -1, null, Collections.emptySet());
    }

    protected StateDescriptor(Class<? extends State> clazz, Property ... propertyArray) {
        this(clazz, -1, null, new HashSet<Property>(Arrays.asList(propertyArray)));
    }

    protected StateDescriptor(Class<? extends State> clazz, int n) {
        this(clazz, n, null, Collections.emptySet());
    }

    protected StateDescriptor(Class<? extends State> clazz, int n, Property ... propertyArray) {
        this(clazz, n, null, new HashSet<Property>(Arrays.asList(propertyArray)));
    }

    protected StateDescriptor(Class<? extends State> clazz, String string) {
        this(clazz, -1, string, Collections.emptySet());
    }

    private StateDescriptor(Class<? extends State> object, int n, String string, Set<Property> set) {
        this.stateClass = object;
        if (string != null && n > 0) {
            throw new IllegalArgumentException("Must specify either RFC or XEP");
        }
        this.xepNum = n;
        this.rfcSection = string;
        this.properties = set;
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = ((Class)object).getDeclaredConstructors();
        object = constructorArray;
        object = constructorArray;
        int n2 = constructorArray.length;
        for (int k = 0; k < n2; ++k) {
            Constructor<?> constructor2 = object[k];
            Class<?>[] classArray = constructor2.getParameterTypes();
            if (classArray.length != 3 || !ModularXmppClientToServerConnection.class.isAssignableFrom(classArray[0]) || !StateDescriptor.class.isAssignableFrom(classArray[1]) || !ModularXmppClientToServerConnectionInternal.class.isAssignableFrom(classArray[2])) continue;
            constructor = constructor2;
            break;
        }
        this.stateClassConstructor = constructor;
        if (this.stateClassConstructor != null) {
            this.stateClassConstructor.setAccessible(true);
        }
        object = this.getClass().getSimpleName();
        this.stateName = ((String)object).replaceFirst("StateDescriptor", "");
    }

    protected void addSuccessor(Class<? extends StateDescriptor> clazz) {
        StateDescriptor.addAndCheckNonExistent(this.successors, clazz);
    }

    public void addPredeccessor(Class<? extends StateDescriptor> clazz) {
        StateDescriptor.addAndCheckNonExistent(this.predecessors, clazz);
    }

    protected void declarePrecedenceOver(Class<? extends StateDescriptor> clazz) {
        StateDescriptor.addAndCheckNonExistent(this.precedenceOver, clazz);
    }

    protected void declarePrecedenceOver(String string) {
        StateDescriptor.addAndCheckNonExistent(this.precedenceOver, string);
    }

    protected void declareInferiorityTo(Class<? extends StateDescriptor> clazz) {
        StateDescriptor.addAndCheckNonExistent(this.inferiorTo, clazz);
    }

    protected void declareInferiorityTo(String string) {
        StateDescriptor.addAndCheckNonExistent(this.inferiorTo, string);
    }

    private static void addAndCheckNonExistent(Set<Class<? extends StateDescriptor>> set, String string) {
        Class<Object> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.FINEST, "Ignoring unknown state descriptor '" + string + "'", classNotFoundException);
            return;
        }
        if (!StateDescriptor.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is no state descriptor class");
        }
        clazz = clazz.asSubclass(StateDescriptor.class);
        StateDescriptor.addAndCheckNonExistent(set, clazz);
    }

    private static <E> void addAndCheckNonExistent(Set<E> set, E e2) {
        boolean bl = set.add(e2);
        if (!bl) {
            throw new IllegalArgumentException("Element already exists in set");
        }
    }

    public Set<Class<? extends StateDescriptor>> getSuccessors() {
        return Collections.unmodifiableSet(this.successors);
    }

    public Set<Class<? extends StateDescriptor>> getPredeccessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    public Set<Class<? extends StateDescriptor>> getSubordinates() {
        return Collections.unmodifiableSet(this.precedenceOver);
    }

    public Set<Class<? extends StateDescriptor>> getSuperiors() {
        return Collections.unmodifiableSet(this.inferiorTo);
    }

    public String getStateName() {
        return this.stateName;
    }

    /*
     * WARNING - void declaration
     */
    public String getFullStateName(boolean bl) {
        String string = this.getReference();
        if (string != null) {
            void var1_4;
            if (bl) {
                int n = 10;
            } else {
                int n = 32;
            }
            return this.getStateName() + (char)var1_4 + '(' + string + ')';
        }
        return this.getStateName();
    }

    public String getReference() {
        if (this.referenceCache == null) {
            if (this.xepNum > 0) {
                this.referenceCache = "XEP-" + String.format("%04d", this.xepNum);
            } else if (this.rfcSection != null) {
                this.referenceCache = this.rfcSection;
            }
        }
        return this.referenceCache;
    }

    public Class<? extends State> getStateClass() {
        return this.stateClass;
    }

    public boolean isMultiVisitState() {
        return this.properties.contains((Object)Property.multiVisitState);
    }

    public boolean isNotImplemented() {
        return this.properties.contains((Object)Property.notImplemented);
    }

    public boolean isFinalState() {
        return this.properties.contains((Object)Property.finalState);
    }

    protected State constructState(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        ModularXmppClientToServerConnection modularXmppClientToServerConnection = modularXmppClientToServerConnectionInternal.connection;
        try {
            return this.stateClassConstructor.newInstance(modularXmppClientToServerConnection, this, modularXmppClientToServerConnectionInternal);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public String toString() {
        return "StateDescriptor " + this.stateName;
    }

    public static enum Property {
        multiVisitState,
        finalState,
        notImplemented;

    }
}

