/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import org.e.a.i;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.MessageOrPresence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.PresenceView;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class Presence
extends MessageOrPresence<PresenceBuilder>
implements PresenceView {
    public static final String ELEMENT = "presence";
    private Type type = Type.available;
    private String status = null;
    private Byte priority;
    private Mode mode = null;

    @Deprecated
    public Presence(Type type) {
        this.setType(type);
    }

    @Deprecated
    public Presence(i i2, Type type) {
        this(type);
        this.setTo(i2);
    }

    @Deprecated
    public Presence(Type type, String string, int n, Mode mode) {
        this.setType(type);
        this.setStatus(string);
        this.setPriority(n);
        this.setMode(mode);
    }

    Presence(PresenceBuilder presenceBuilder) {
        super(presenceBuilder);
        this.type = presenceBuilder.type;
        this.status = presenceBuilder.status;
        this.priority = presenceBuilder.priority;
        this.mode = presenceBuilder.mode;
    }

    public Presence(Presence presence) {
        super(presence);
        this.type = presence.type;
        this.status = presence.status;
        this.priority = presence.priority;
        this.mode = presence.mode;
    }

    public final boolean isAvailable() {
        return this.type == Type.available;
    }

    public final boolean isAway() {
        return this.type == Type.available && (this.mode == Mode.away || this.mode == Mode.xa || this.mode == Mode.dnd);
    }

    @Override
    public final Type getType() {
        return this.type;
    }

    @Deprecated
    public final void setType(Type type) {
        this.type = Objects.requireNonNull(type, "Type cannot be null");
    }

    @Override
    public final String getStatus() {
        return this.status;
    }

    @Deprecated
    public final void setStatus(String string) {
        this.status = string;
    }

    @Override
    public final int getPriority() {
        return this.getPriorityByte();
    }

    @Override
    public final byte getPriorityByte() {
        if (this.priority == null) {
            return 0;
        }
        return this.priority;
    }

    @Deprecated
    public final void setPriority(int n) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException("Priority value " + n + " is not valid. Valid range is -128 through 127.");
        }
        this.setPriority((byte)n);
    }

    public final void setPriority(byte by) {
        this.priority = by;
    }

    @Override
    public final Mode getMode() {
        if (this.mode == null) {
            return Mode.available;
        }
        return this.mode;
    }

    @Deprecated
    public final void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public final String getElementName() {
        return ELEMENT;
    }

    @Override
    public final PresenceBuilder asBuilder() {
        Presence presence = this;
        return StanzaBuilder.buildPresenceFrom(presence, presence.getStanzaId());
    }

    @Override
    public final PresenceBuilder asBuilder(String string) {
        return StanzaBuilder.buildPresenceFrom(this, string);
    }

    @Override
    public final PresenceBuilder asBuilder(XMPPConnection xMPPConnection) {
        return xMPPConnection.getStanzaFactory().buildPresenceStanzaFrom(this);
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Presence Stanza [");
        this.logCommonAttributes(stringBuilder);
        stringBuilder.append("type=").append((Object)this.type).append(',');
        if (this.mode != null) {
            stringBuilder.append("mode=").append((Object)this.mode).append(',');
        }
        if (!StringUtils.isNullOrEmpty((CharSequence)this.status)) {
            stringBuilder.append("status=").append(this.status).append(',');
        }
        if (this.priority != null) {
            stringBuilder.append("prio=").append(this.priority).append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public final XmlStringBuilder toXML(XmlEnvironment object) {
        object = new XmlStringBuilder(this, (XmlEnvironment)object);
        this.addCommonAttributes((XmlStringBuilder)object);
        if (this.type != Type.available) {
            ((XmlStringBuilder)object).attribute("type", this.type);
        }
        List<ExtensionElement> list = this.getExtensions();
        if (this.status == null && this.priority == null && (this.mode == null || this.mode == Mode.available) && list.isEmpty() && this.getError() == null) {
            return ((XmlStringBuilder)object).closeEmptyElement();
        }
        ((XmlStringBuilder)object).rightAngleBracket();
        ((XmlStringBuilder)object).optElement("status", this.status);
        ((XmlStringBuilder)object).optElement("priority", this.priority);
        if (this.mode != null && this.mode != Mode.available) {
            ((XmlStringBuilder)object).element("show", this.mode);
        }
        ((XmlStringBuilder)object).append(list);
        this.appendErrorIfExists((XmlStringBuilder)object);
        ((XmlStringBuilder)object).closeElement(ELEMENT);
        return object;
    }

    @Deprecated
    public final Presence clone() {
        return new Presence(this);
    }

    @Deprecated
    public final Presence cloneWithNewId() {
        Presence presence = this.clone();
        presence.setNewStanzaId();
        return presence;
    }

    public static enum Mode {
        chat,
        available,
        away,
        xa,
        dnd;


        public static Mode fromString(String string) {
            return Mode.valueOf(string.toLowerCase(Locale.US));
        }
    }

    public static enum Type {
        available,
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        error,
        probe;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

