/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor.listener;

import dorkbox.executor.listener.ProcessDestroyer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldorkbox/executor/listener/ShutdownHookProcessDestroyer;", "Ldorkbox/executor/listener/ProcessDestroyer;", "Ljava/lang/Runnable;", "()V", "destroyProcessThread", "Ldorkbox/executor/listener/ShutdownHookProcessDestroyer$ProcessDestroyerImpl;", "<set-?>", "", "isAddedAsShutdownHook", "()Z", "processes", "", "Ljava/lang/Process;", "running", "shutDownHookExecuted", "add", "process", "addShutdownHook", "", "destroy", "remove", "removeShutdownHook", "run", "size", "", "Companion", "ProcessDestroyerImpl", "Executor"})
public final class ShutdownHookProcessDestroyer
implements ProcessDestroyer,
Runnable {
    public static final Companion Companion = new Companion(null);
    private final List<Process> processes = new ArrayList();
    private ProcessDestroyerImpl destroyProcessThread;
    private boolean isAddedAsShutdownHook;
    private volatile boolean shutDownHookExecuted;
    private volatile boolean running;
    private static final Logger log = LoggerFactory.getLogger(ShutdownHookProcessDestroyer.class);
    private static final ProcessDestroyer INSTANCE = new ShutdownHookProcessDestroyer();

    public final boolean isAddedAsShutdownHook() {
        return this.isAddedAsShutdownHook;
    }

    private final void addShutdownHook() {
        if (!this.running) {
            this.destroyProcessThread = new ProcessDestroyerImpl();
            try {
                Runtime.getRuntime().addShutdownHook(this.destroyProcessThread);
                this.isAddedAsShutdownHook = true;
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void removeShutdownHook() {
        if (this.isAddedAsShutdownHook && !this.running) {
            boolean bl = Runtime.getRuntime().removeShutdownHook(this.destroyProcessThread);
            if (!bl) {
                log.error("Could not remove shutdown hook");
            }
            ProcessDestroyerImpl processDestroyerImpl = this.destroyProcessThread;
            Intrinsics.checkNotNull((Object)processDestroyerImpl);
            processDestroyerImpl.setShouldDestroy(false);
            ProcessDestroyerImpl processDestroyerImpl2 = this.destroyProcessThread;
            Intrinsics.checkNotNull((Object)processDestroyerImpl2);
            processDestroyerImpl2.start();
            try {
                ProcessDestroyerImpl processDestroyerImpl3 = this.destroyProcessThread;
                Intrinsics.checkNotNull((Object)processDestroyerImpl3);
                processDestroyerImpl3.join(20000L);
            }
            catch (InterruptedException interruptedException) {}
            this.destroyProcessThread = null;
            this.isAddedAsShutdownHook = false;
        }
    }

    @Override
    public final boolean add(Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"");
        List<Process> list = this.processes;
        synchronized (list) {
            if (this.processes.size() == 0) {
                try {
                    if (!(!this.shutDownHookExecuted)) {
                        String string2 = "Check failed.";
                        throw new IllegalStateException(string2.toString());
                    }
                    this.addShutdownHook();
                }
                catch (IllegalStateException illegalStateException) {
                    this.destroy(process);
                }
            }
            this.processes.add(process);
            boolean bl = this.processes.contains(process);
            return bl;
        }
    }

    @Override
    public final boolean remove(Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"");
        List<Process> list = this.processes;
        synchronized (list) {
            boolean bl = this.processes.remove(process);
            if (bl && this.processes.size() == 0) {
                try {
                    this.removeShutdownHook();
                }
                catch (IllegalStateException illegalStateException) {
                    this.shutDownHookExecuted = true;
                }
            }
            return bl;
        }
    }

    @Override
    public final int size() {
        return this.processes.size();
    }

    @Override
    public final void run() {
        if (this.shutDownHookExecuted) {
            return;
        }
        List<Process> list = this.processes;
        synchronized (list) {
            this.running = true;
            Object object = this.processes;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Process)object2;
                this.destroy((Process)object2);
            }
            this.processes.clear();
            this.shutDownHookExecuted = true;
            return;
        }
    }

    private final void destroy(Process process) {
        try {
            process.destroy();
            return;
        }
        catch (Throwable throwable) {
            log.error("Unable to terminate process during process shutdown");
            return;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldorkbox/executor/listener/ShutdownHookProcessDestroyer$Companion;", "", "()V", "INSTANCE", "Ldorkbox/executor/listener/ProcessDestroyer;", "getINSTANCE", "()Ldorkbox/executor/listener/ProcessDestroyer;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Executor"})
    public static final class Companion {
        private Companion() {
        }

        public final ProcessDestroyer getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldorkbox/executor/listener/ShutdownHookProcessDestroyer$ProcessDestroyerImpl;", "Ljava/lang/Thread;", "(Ldorkbox/executor/listener/ShutdownHookProcessDestroyer;)V", "shouldDestroy", "", "run", "", "setShouldDestroy", "Executor"})
    private final class ProcessDestroyerImpl
    extends Thread {
        private boolean shouldDestroy;

        public ProcessDestroyerImpl() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = true;
        }

        @Override
        public final void run() {
            if (this.shouldDestroy) {
                ShutdownHookProcessDestroyer.this.run();
            }
        }

        public final void setShouldDestroy(boolean bl) {
            this.shouldDestroy = bl;
        }
    }
}

