/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.ByteObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ByteObjectHashMap<V>
implements ByteObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private byte[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Byte> keySet = new KeySet();
    private final Set<Map.Entry<Byte, V>> entrySet = new EntrySet();
    private final Iterable<ByteObjectMap.PrimitiveEntry<V>> entries = new Iterable<ByteObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<ByteObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public ByteObjectHashMap() {
        this(8, 0.5f);
    }

    public ByteObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public ByteObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        n = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n - 1;
        this.keys = new byte[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        if (t == NULL_VALUE) {
            return null;
        }
        return t;
    }

    private static <T> T toInternal(T t) {
        if (t == null) {
            return (T)NULL_VALUE;
        }
        return t;
    }

    @Override
    public V get(byte by) {
        int n = this.indexOf(by);
        by = (byte)n;
        if (n == -1) {
            return null;
        }
        return ByteObjectHashMap.toExternal(this.values[by]);
    }

    @Override
    public V put(byte by, V v) {
        int n;
        int n2 = n = this.hashIndex(by);
        do {
            if (this.values[n2] == null) {
                this.keys[n2] = by;
                this.values[n2] = ByteObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n2] != by) continue;
            V v2 = this.values[n2];
            this.values[n2] = ByteObjectHashMap.toInternal(v);
            return ByteObjectHashMap.toExternal(v2);
        } while ((n2 = this.probeNext(n2)) != n);
        throw new IllegalStateException("Unable to insert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Byte, ? extends V> object) {
        if (object instanceof ByteObjectHashMap) {
            void entry;
            object = (ByteObjectHashMap)((Object)object);
            boolean i = false;
            while (entry < ((ByteObjectHashMap)((Object)object)).values.length) {
                V v = ((ByteObjectHashMap)((Object)object)).values[entry];
                if (v != null) {
                    this.put(((ByteObjectHashMap)((Object)object)).keys[entry], v);
                }
                ++entry;
            }
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            this.put((Byte)entry.getKey(), (V)entry.getValue());
        }
    }

    @Override
    public V remove(byte by) {
        int n = this.indexOf(by);
        by = (byte)n;
        if (n == -1) {
            return null;
        }
        V v = this.values[by];
        this.removeAt(by);
        return ByteObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(byte by) {
        return this.indexOf(by) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        object = ByteObjectHashMap.toInternal(object);
        V[] VArray = this.values;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            V v = VArray[i];
            if (v == null || !v.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ByteObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ByteObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int n = this.size;
        byte[] byArray = this.keys;
        int n2 = this.keys.length;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[i];
            n ^= ByteObjectHashMap.hashCode(by);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteObjectMap)) {
            return false;
        }
        if (this.size != (object = (ByteObjectMap)object).size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            byte by = this.keys[i];
            Object v2 = object.get(by);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        ByteObjectHashMap byteObjectHashMap = this;
        return byteObjectHashMap.containsKey(byteObjectHashMap.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        ByteObjectHashMap byteObjectHashMap = this;
        return byteObjectHashMap.get(byteObjectHashMap.objectToKey(object));
    }

    @Override
    public V put(Byte by, V v) {
        ByteObjectHashMap byteObjectHashMap = this;
        return byteObjectHashMap.put(byteObjectHashMap.objectToKey(by), v);
    }

    @Override
    public V remove(Object object) {
        ByteObjectHashMap byteObjectHashMap = this;
        return byteObjectHashMap.remove(byteObjectHashMap.objectToKey(object));
    }

    @Override
    public Set<Byte> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Byte, V>> entrySet() {
        return this.entrySet;
    }

    private byte objectToKey(Object object) {
        return (Byte)object;
    }

    private int indexOf(byte by) {
        int n;
        int n2 = n = this.hashIndex(by);
        do {
            if (this.values[n2] == null) {
                return -1;
            }
            if (by != this.keys[n2]) continue;
            return n2;
        } while ((n2 = this.probeNext(n2)) != n);
        return -1;
    }

    private int hashIndex(byte by) {
        return ByteObjectHashMap.hashCode(by) & this.mask;
    }

    private static int hashCode(byte by) {
        return by;
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            ByteObjectHashMap byteObjectHashMap = this;
            byteObjectHashMap.rehash(byteObjectHashMap.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            byte by = this.keys[n3];
            int n4 = this.hashIndex(by);
            if (n3 < n4 && (n4 <= n2 || n2 <= n3) || n4 <= n2 && n2 <= n3) {
                this.keys[n2] = by;
                this.values[n2] = v;
                this.keys[n3] = 0;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        byte[] byArray = this.keys;
        V[] VArray = this.values;
        this.keys = new byte[n];
        Object object = new Object[n];
        this.values = object;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (n = 0; n < VArray.length; ++n) {
            object = VArray[n];
            if (object == null) continue;
            byte by = byArray[n];
            int n2 = this.hashIndex(by);
            while (true) {
                if (this.values[n2] == null) {
                    this.keys[n2] = by;
                    this.values[n2] = object;
                    continue block0;
                }
                n2 = this.probeNext(n2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            ByteObjectHashMap byteObjectHashMap = this;
            stringBuilder.append(byteObjectHashMap.keyToString(byteObjectHashMap.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : ByteObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(byte by) {
        return Byte.toString(by);
    }

    final class MapEntry
    implements Map.Entry<Byte, V> {
        private final int entryIndex;

        MapEntry(int n) {
            this.entryIndex = n;
        }

        @Override
        public final Byte getKey() {
            this.verifyExists();
            return ByteObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V getValue() {
            this.verifyExists();
            return ByteObjectHashMap.toExternal(ByteObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final V setValue(V v) {
            this.verifyExists();
            Object object = ByteObjectHashMap.toExternal(ByteObjectHashMap.this.values[this.entryIndex]);
            ((ByteObjectHashMap)ByteObjectHashMap.this).values[this.entryIndex] = ByteObjectHashMap.toInternal(v);
            return object;
        }

        private void verifyExists() {
            if (ByteObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Byte, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<Byte, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements ByteObjectMap.PrimitiveEntry<V>,
    Iterator<ByteObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != ByteObjectHashMap.this.values.length && ByteObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != ByteObjectHashMap.this.values.length;
        }

        @Override
        public final ByteObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public final void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (ByteObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public final byte key() {
            return ByteObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V value() {
            return ByteObjectHashMap.toExternal(ByteObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final void setValue(V v) {
            ((ByteObjectHashMap)ByteObjectHashMap.this).values[this.entryIndex] = ByteObjectHashMap.toInternal(v);
        }
    }

    private final class KeySet
    extends AbstractSet<Byte> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return ByteObjectHashMap.this.size();
        }

        @Override
        public final boolean contains(Object object) {
            return ByteObjectHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return ByteObjectHashMap.this.remove(object) != null;
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = ByteObjectHashMap.this.entries().iterator();
            while (iterator.hasNext()) {
                ByteObjectMap.PrimitiveEntry primitiveEntry = iterator.next();
                if (collection.contains(primitiveEntry.key())) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public final void clear() {
            ByteObjectHashMap.this.clear();
        }

        @Override
        public final Iterator<Byte> iterator() {
            return new Iterator<Byte>(){
                private final Iterator<Map.Entry<Byte, V>> iter;
                {
                    this.iter = ByteObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Byte next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Byte, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<Byte, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public final int size() {
            return ByteObjectHashMap.this.size();
        }
    }
}

