/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ConcurrentSet;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObjectCleaner {
    private static final int REFERENCE_QUEUE_POLL_TIMEOUT_MS = Math.max(500, SystemPropertyUtil.getInt("io.netty.util.internal.ObjectCleaner.refQueuePollTimeout", 10000));
    static final String CLEANER_THREAD_NAME = ObjectCleaner.class.getSimpleName() + "Thread";
    private static final Set<AutomaticCleanerReference> LIVE_SET = new ConcurrentSet<AutomaticCleanerReference>();
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    private static final AtomicBoolean CLEANER_RUNNING = new AtomicBoolean(false);
    private static final Runnable CLEANER_TASK = new Runnable(){

        @Override
        public final void run() {
            boolean bl = false;
            while (true) {
                if (!LIVE_SET.isEmpty()) {
                    AutomaticCleanerReference automaticCleanerReference;
                    try {
                        automaticCleanerReference = (AutomaticCleanerReference)REFERENCE_QUEUE.remove(REFERENCE_QUEUE_POLL_TIMEOUT_MS);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        continue;
                    }
                    if (automaticCleanerReference == null) continue;
                    try {
                        automaticCleanerReference.cleanup();
                    }
                    catch (Throwable throwable) {}
                    LIVE_SET.remove(automaticCleanerReference);
                    continue;
                }
                CLEANER_RUNNING.set(false);
                if (LIVE_SET.isEmpty() || !CLEANER_RUNNING.compareAndSet(false, true)) break;
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    };

    public static void register(Object object, Runnable runnable) {
        object = new AutomaticCleanerReference(object, ObjectUtil.checkNotNull(runnable, "cleanupTask"));
        LIVE_SET.add((AutomaticCleanerReference)object);
        if (CLEANER_RUNNING.compareAndSet(false, true)) {
            object = new FastThreadLocalThread(CLEANER_TASK);
            ((Thread)object).setPriority(1);
            AccessController.doPrivileged(new PrivilegedAction<Void>((Thread)object){
                final /* synthetic */ Thread val$cleanupThread;
                {
                    this.val$cleanupThread = thread;
                }

                @Override
                public final Void run() {
                    this.val$cleanupThread.setContextClassLoader(null);
                    return null;
                }
            });
            ((Thread)object).setName(CLEANER_THREAD_NAME);
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
    }

    public static int getLiveSetCount() {
        return LIVE_SET.size();
    }

    private ObjectCleaner() {
    }

    private static final class AutomaticCleanerReference
    extends WeakReference<Object> {
        private final Runnable cleanupTask;

        AutomaticCleanerReference(Object object, Runnable runnable) {
            super(object, REFERENCE_QUEUE);
            this.cleanupTask = runnable;
        }

        final void cleanup() {
            this.cleanupTask.run();
        }

        @Override
        public final Thread get() {
            return null;
        }

        @Override
        public final void clear() {
            LIVE_SET.remove(this);
            super.clear();
        }
    }
}

