/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.FormattingTuple;
import io.netty.util.internal.logging.MessageFormatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class JdkLogger
extends AbstractInternalLogger {
    private static final long serialVersionUID = -1767272577989225979L;
    final transient Logger logger;
    static final String SELF = JdkLogger.class.getName();
    static final String SUPER = AbstractInternalLogger.class.getName();

    JdkLogger(Logger logger) {
        super(logger.getName());
        this.logger = logger;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String string) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.log(SELF, Level.FINEST, string, null);
        }
    }

    @Override
    public void trace(String object, Object object2) {
        if (this.logger.isLoggable(Level.FINEST)) {
            object = MessageFormatter.format((String)object, object2);
            this.log(SELF, Level.FINEST, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void trace(String object, Object object2, Object object3) {
        if (this.logger.isLoggable(Level.FINEST)) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.log(SELF, Level.FINEST, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void trace(String object, Object ... objectArray) {
        if (this.logger.isLoggable(Level.FINEST)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.log(SELF, Level.FINEST, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void trace(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.log(SELF, Level.FINEST, string, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String string) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(SELF, Level.FINE, string, null);
        }
    }

    @Override
    public void debug(String object, Object object2) {
        if (this.logger.isLoggable(Level.FINE)) {
            object = MessageFormatter.format((String)object, object2);
            this.log(SELF, Level.FINE, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void debug(String object, Object object2, Object object3) {
        if (this.logger.isLoggable(Level.FINE)) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.log(SELF, Level.FINE, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void debug(String object, Object ... objectArray) {
        if (this.logger.isLoggable(Level.FINE)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.log(SELF, Level.FINE, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(SELF, Level.FINE, string, throwable);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String string) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(SELF, Level.INFO, string, null);
        }
    }

    @Override
    public void info(String object, Object object2) {
        if (this.logger.isLoggable(Level.INFO)) {
            object = MessageFormatter.format((String)object, object2);
            this.log(SELF, Level.INFO, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void info(String object, Object object2, Object object3) {
        if (this.logger.isLoggable(Level.INFO)) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.log(SELF, Level.INFO, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void info(String object, Object ... objectArray) {
        if (this.logger.isLoggable(Level.INFO)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.log(SELF, Level.INFO, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void info(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(SELF, Level.INFO, string, throwable);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String string) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(SELF, Level.WARNING, string, null);
        }
    }

    @Override
    public void warn(String object, Object object2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            object = MessageFormatter.format((String)object, object2);
            this.log(SELF, Level.WARNING, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void warn(String object, Object object2, Object object3) {
        if (this.logger.isLoggable(Level.WARNING)) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.log(SELF, Level.WARNING, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void warn(String object, Object ... objectArray) {
        if (this.logger.isLoggable(Level.WARNING)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.log(SELF, Level.WARNING, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void warn(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(SELF, Level.WARNING, string, throwable);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String string) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(SELF, Level.SEVERE, string, null);
        }
    }

    @Override
    public void error(String object, Object object2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            object = MessageFormatter.format((String)object, object2);
            this.log(SELF, Level.SEVERE, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void error(String object, Object object2, Object object3) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.log(SELF, Level.SEVERE, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void error(String object, Object ... objectArray) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.log(SELF, Level.SEVERE, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(SELF, Level.SEVERE, string, throwable);
        }
    }

    private void log(String string, Level serializable, String string2, Throwable throwable) {
        serializable = new LogRecord((Level)serializable, string2);
        ((LogRecord)serializable).setLoggerName(this.name());
        ((LogRecord)serializable).setThrown(throwable);
        JdkLogger.fillCallerData(string, (LogRecord)serializable);
        this.logger.log((LogRecord)serializable);
    }

    private static void fillCallerData(String string, LogRecord logRecord) {
        int n;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n2 = -1;
        for (n = 0; n < stackTraceElementArray.length; ++n) {
            String string2 = stackTraceElementArray[n].getClassName();
            if (!string2.equals(string) && !string2.equals(SUPER)) continue;
            n2 = n;
            break;
        }
        n = -1;
        for (int i = n2 + 1; i < stackTraceElementArray.length; ++i) {
            String string3 = stackTraceElementArray[i].getClassName();
            if (string3.equals(string) || string3.equals(SUPER)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
        }
    }
}

