/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.util;

import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;

public final class UnsafeRefArrayAccess {
    public static final long REF_ARRAY_BASE;
    public static final int REF_ELEMENT_SHIFT;

    public static <E> void spRefElement(E[] EArray, long l, E e) {
        UnsafeAccess.UNSAFE.putObject(EArray, l, e);
    }

    public static <E> void soRefElement(E[] EArray, long l, E e) {
        UnsafeAccess.UNSAFE.putOrderedObject(EArray, l, e);
    }

    public static <E> E lpRefElement(E[] EArray, long l) {
        return (E)UnsafeAccess.UNSAFE.getObject(EArray, l);
    }

    public static <E> E lvRefElement(E[] EArray, long l) {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(EArray, l);
    }

    public static long calcRefElementOffset(long l) {
        return REF_ARRAY_BASE + (l << REF_ELEMENT_SHIFT);
    }

    public static long calcCircularRefElementOffset(long l, long l2) {
        return REF_ARRAY_BASE + ((l & l2) << REF_ELEMENT_SHIFT);
    }

    public static <E> E[] allocateRefArray(int n) {
        return new Object[n];
    }

    static {
        int n = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == n) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == n) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size: " + n);
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    }
}

