/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.sockets.SocketOptions;
import io.ktor.network.sockets.SocketOptionsPlatformCapabilities;
import io.ktor.network.sockets.TypeOfService;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001b\u0010\u0006\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\"\u001a\u0010\t\u001a\u00020\b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljava/nio/channels/SelectableChannel;", "", "nonBlocking", "(Ljava/nio/channels/SelectableChannel;)V", "Lio/ktor/network/sockets/SocketOptions;", "options", "assignOptions", "(Ljava/nio/channels/SelectableChannel;Lio/ktor/network/sockets/SocketOptions;)V", "", "java7NetworkApisAvailable", "Z", "getJava7NetworkApisAvailable", "()Z", "ktor-network"})
public final class JavaSocketOptionsKt {
    private static final boolean java7NetworkApisAvailable;

    public static final boolean getJava7NetworkApisAvailable() {
        return java7NetworkApisAvailable;
    }

    public static final void nonBlocking(SelectableChannel selectableChannel) {
        Intrinsics.checkNotNullParameter((Object)selectableChannel, (String)"");
        selectableChannel.configureBlocking(false);
    }

    public static final void assignOptions(SelectableChannel selectableChannel, SocketOptions socketOptions) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)selectableChannel, (String)"");
        Intrinsics.checkNotNullParameter((Object)socketOptions, (String)"");
        if (selectableChannel instanceof SocketChannel) {
            if (!TypeOfService.equals-impl0(socketOptions.getTypeOfService-zieKYfw(), TypeOfService.Companion.getUNDEFINED-zieKYfw())) {
                byte by;
                if (java7NetworkApisAvailable) {
                    by = socketOptions.getTypeOfService-zieKYfw();
                    ((SocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)(by & 0xFF));
                } else {
                    by = socketOptions.getTypeOfService-zieKYfw();
                    ((SocketChannel)selectableChannel).socket().setTrafficClass(by & 0xFF);
                }
            }
            if (socketOptions.getReuseAddress()) {
                if (java7NetworkApisAvailable) {
                    ((SocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
                } else {
                    ((SocketChannel)selectableChannel).socket().setReuseAddress(true);
                }
            }
            if (socketOptions.getReusePort()) {
                SocketOptionsPlatformCapabilities.INSTANCE.setReusePort((SocketChannel)selectableChannel);
            }
            if (socketOptions instanceof SocketOptions.PeerSocketOptions) {
                Integer n3 = ((SocketOptions.PeerSocketOptions)socketOptions).getReceiveBufferSize();
                n2 = ((Number)n3).intValue();
                Integer n4 = n2 > 0 ? n3 : null;
                if (n4 != null) {
                    n2 = ((Number)n4).intValue();
                    if (java7NetworkApisAvailable) {
                        ((SocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n2);
                    } else {
                        ((SocketChannel)selectableChannel).socket().setReceiveBufferSize(n2);
                    }
                }
                n3 = ((SocketOptions.PeerSocketOptions)socketOptions).getSendBufferSize();
                n2 = ((Number)n3).intValue();
                Integer n5 = n2 > 0 ? n3 : null;
                if (n5 != null) {
                    n2 = ((Number)n5).intValue();
                    if (java7NetworkApisAvailable) {
                        ((SocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)n2);
                    } else {
                        ((SocketChannel)selectableChannel).socket().setSendBufferSize(n2);
                    }
                }
            }
            if (socketOptions instanceof SocketOptions.TCPClientSocketOptions) {
                Integer n6 = ((SocketOptions.TCPClientSocketOptions)socketOptions).getLingerSeconds();
                n2 = ((Number)n6).intValue();
                Integer n7 = n2 >= 0 ? n6 : null;
                if (n7 != null) {
                    n2 = ((Number)n7).intValue();
                    if (java7NetworkApisAvailable) {
                        ((SocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)n2);
                    } else {
                        ((SocketChannel)selectableChannel).socket().setSoLinger(true, n2);
                    }
                }
                Boolean bl = ((SocketOptions.TCPClientSocketOptions)socketOptions).getKeepAlive();
                if (bl != null) {
                    n2 = bl.booleanValue() ? 1 : 0;
                    if (java7NetworkApisAvailable) {
                        ((SocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)(n2 != 0));
                    } else {
                        ((SocketChannel)selectableChannel).socket().setKeepAlive(n2 != 0);
                    }
                }
                if (java7NetworkApisAvailable) {
                    ((SocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)((SocketOptions.TCPClientSocketOptions)socketOptions).getNoDelay());
                } else {
                    ((SocketChannel)selectableChannel).socket().setTcpNoDelay(((SocketOptions.TCPClientSocketOptions)socketOptions).getNoDelay());
                }
            }
        }
        if (selectableChannel instanceof ServerSocketChannel) {
            if (socketOptions.getReuseAddress()) {
                if (java7NetworkApisAvailable) {
                    ((ServerSocketChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
                } else {
                    ((ServerSocketChannel)selectableChannel).socket().setReuseAddress(true);
                }
            }
            if (socketOptions.getReusePort()) {
                SocketOptionsPlatformCapabilities.INSTANCE.setReusePort((ServerSocketChannel)selectableChannel);
            }
        }
        if (selectableChannel instanceof DatagramChannel) {
            if (!TypeOfService.equals-impl0(socketOptions.getTypeOfService-zieKYfw(), TypeOfService.Companion.getUNDEFINED-zieKYfw())) {
                if (java7NetworkApisAvailable) {
                    byte by = socketOptions.getTypeOfService-zieKYfw();
                    ((DatagramChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)(by & 0xFF));
                } else {
                    byte by = socketOptions.getTypeOfService-zieKYfw();
                    ((DatagramChannel)selectableChannel).socket().setTrafficClass(by & 0xFF);
                }
            }
            if (socketOptions.getReuseAddress()) {
                if (java7NetworkApisAvailable) {
                    ((DatagramChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
                } else {
                    ((DatagramChannel)selectableChannel).socket().setReuseAddress(true);
                }
            }
            if (socketOptions.getReusePort()) {
                SocketOptionsPlatformCapabilities.INSTANCE.setReusePort((DatagramChannel)selectableChannel);
            }
            if (socketOptions instanceof SocketOptions.UDPSocketOptions) {
                if (java7NetworkApisAvailable) {
                    ((DatagramChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)((SocketOptions.UDPSocketOptions)socketOptions).getBroadcast());
                } else {
                    ((DatagramChannel)selectableChannel).socket().setBroadcast(((SocketOptions.UDPSocketOptions)socketOptions).getBroadcast());
                }
            }
            if (socketOptions instanceof SocketOptions.PeerSocketOptions) {
                Integer n8 = ((SocketOptions.PeerSocketOptions)socketOptions).getReceiveBufferSize();
                n2 = ((Number)n8).intValue();
                Integer n9 = n2 > 0 ? n8 : null;
                if (n9 != null) {
                    n2 = ((Number)n9).intValue();
                    if (java7NetworkApisAvailable) {
                        ((DatagramChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n2);
                    } else {
                        ((DatagramChannel)selectableChannel).socket().setReceiveBufferSize(n2);
                    }
                }
                n8 = ((SocketOptions.PeerSocketOptions)socketOptions).getSendBufferSize();
                n2 = ((Number)n8).intValue();
                Integer n10 = n2 > 0 ? n8 : null;
                if (n10 != null) {
                    n2 = ((Number)n10).intValue();
                    if (java7NetworkApisAvailable) {
                        ((DatagramChannel)selectableChannel).setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)n2);
                    } else {
                        ((DatagramChannel)selectableChannel).socket().setSendBufferSize(n2);
                        return;
                    }
                }
            }
        }
    }

    static {
        boolean bl;
        try {
            Class.forName("java.net.StandardSocketOptions");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        java7NetworkApisAvailable = bl;
    }
}

