/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.SecurityUtil;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class PropertyAccess {
    public static final String jnlp_prefix = "jnlp.";
    public static final String javaws_prefix = "javaws.";
    static final HashSet<String> trustedPrefixes = new HashSet<String>();
    static final HashSet<String> trusted;

    protected static final void addTrustedPrefix(String string) {
        SecurityUtil.checkAllPermissions();
        trustedPrefixes.add(string);
    }

    public static final boolean isTrusted(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            return trustedPrefixes.contains(string.substring(0, n + 1)) || trusted.contains(string);
        }
        return false;
    }

    public static final int getIntProperty(String string, boolean bl, int n) {
        try {
            string = PropertyAccess.getProperty(string, bl);
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public static final long getLongProperty(String string, boolean bl, long l) {
        long l2 = l;
        try {
            string = PropertyAccess.getProperty(string, bl);
            if (string != null) {
                l2 = Long.parseLong(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return l2;
    }

    public static final boolean getBooleanProperty(String string, boolean bl) {
        return Boolean.valueOf(PropertyAccess.getProperty(string, bl));
    }

    public static final boolean getBooleanProperty(String string, boolean bl, boolean bl2) {
        if ((string = PropertyAccess.getProperty(string, bl)) != null) {
            return Boolean.valueOf(string);
        }
        return bl2;
    }

    public static final boolean isPropertyDefined(String string, boolean bl) {
        return PropertyAccess.getProperty(string, bl) != null;
    }

    public static final String getProperty(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("propertyKey is NULL");
        }
        if (0 == string.length()) {
            throw new IllegalArgumentException("propertyKey is empty");
        }
        String string2 = PropertyAccess.isTrusted(string) ? PropertyAccess.getTrustedPropKey(string) : System.getProperty(string);
        if (string2 == null && bl && !string.startsWith(jnlp_prefix)) {
            string2 = PropertyAccess.getTrustedPropKey(jnlp_prefix + string);
        }
        return string2;
    }

    public static final String getProperty(String string, boolean bl, String string2) {
        if ((string = PropertyAccess.getProperty(string, bl)) != null) {
            return string;
        }
        return string2;
    }

    private static final String getTrustedPropKey(final String string) {
        return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Could not access trusted property '" + string + "'", securityException);
                }
            }
        });
    }

    static {
        trustedPrefixes.add(javaws_prefix);
        trustedPrefixes.add(jnlp_prefix);
        trusted = new HashSet<String>();
        trusted.add("sun.java2d.opengl");
        trusted.add("sun.java2d.noddraw");
        trusted.add("sun.java2d.d3d");
        trusted.add("sun.awt.noerasebackground");
    }
}

