/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util;

import com.jogamp.common.util.Bitfield;

public class Int32Bitfield
implements Bitfield {
    private static final int UNIT_SIZE = 32;
    private int storage = 0;

    @Override
    public int size() {
        return 32;
    }

    @Override
    public final void clearField(boolean bl) {
        if (bl) {
            this.storage = -1;
            return;
        }
        this.storage = 0;
    }

    private static final void check(int n, int n2) {
        if (n2 < 0 || n2 >= n) {
            throw new IndexOutOfBoundsException("Bitnum should be within [0.." + (n - 1) + "], but is " + n2);
        }
    }

    @Override
    public final int get32(int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n2);
        }
        Int32Bitfield.check(32 - n2 + 1, n);
        int n3 = 32 - n;
        if (32 == n3) {
            n2 = Bitfield.Util.getBitMask(n2);
            return n2 & this.storage;
        }
        n2 = Math.min(n2, n3);
        n2 = (1 << n2) - 1;
        return n2 & this.storage >>> n;
    }

    @Override
    public final void put32(int n, int n2, int n3) {
        if (n2 < 0 || n2 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n2);
        }
        Int32Bitfield.check(32 - n2 + 1, n);
        int n4 = 32 - n;
        if (32 == n4) {
            n2 = Bitfield.Util.getBitMask(n2);
            this.storage = ~n2 & this.storage | n2 & n3;
            return;
        }
        n2 = Math.min(n2, n4);
        n2 = (1 << n2) - 1;
        this.storage = ~(n2 << n) & this.storage | (n2 & n3) << n;
    }

    @Override
    public final int copy32(int n, int n2, int n3) {
        n = this.get32(n, n3);
        this.put32(n2, n3, n);
        return n;
    }

    @Override
    public final boolean get(int n) {
        Int32Bitfield.check(32, n);
        return 0 != (this.storage & 1 << n);
    }

    @Override
    public final boolean put(int n, boolean bl) {
        Int32Bitfield.check(32, n);
        n = 1 << n;
        boolean bl2 = 0 != (this.storage & n);
        if (bl2 != bl) {
            this.storage = bl ? (this.storage |= n) : (this.storage &= ~n);
        }
        return bl2;
    }

    @Override
    public final void set(int n) {
        Int32Bitfield.check(32, n);
        n = 1 << n;
        this.storage |= n;
    }

    @Override
    public final void clear(int n) {
        Int32Bitfield.check(32, n);
        n = 1 << n;
        this.storage &= ~n;
    }

    @Override
    public final boolean copy(int n, int n2) {
        Int32Bitfield.check(32, n);
        Int32Bitfield.check(32, n2);
        n = 0 != (this.storage & 1 << n) ? 1 : 0;
        n2 = 1 << n2;
        this.storage = n != 0 ? (this.storage |= n2) : (this.storage &= ~n2);
        return n != 0;
    }

    @Override
    public int bitCount() {
        return Bitfield.Util.bitCount(this.storage);
    }
}

