/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.changelist;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RememberManager;
import androidx.compose.runtime.SlotWriter;
import androidx.compose.runtime.changelist.Operation;
import androidx.compose.runtime.changelist.OperationErrorContext;
import androidx.compose.runtime.changelist.Operations;
import androidx.compose.runtime.changelist.OperationsDebugStringFormattable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J&\u0010\u0019\u001a\u00020\u000f2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u000fJ>\u0010!\u001a\u00020\u000f\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#2\u0006\u0010$\u001a\u0002H\"2\u001d\u0010%\u001a\u0019\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u00020\u000f0&\u00a2\u0006\u0002\b'\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006,"}, d2={"Landroidx/compose/runtime/changelist/FixupList;", "Landroidx/compose/runtime/changelist/OperationsDebugStringFormattable;", "<init>", "()V", "operations", "Landroidx/compose/runtime/changelist/Operations;", "pendingOperations", "size", "", "getSize", "()I", "isEmpty", "", "isNotEmpty", "clear", "", "executeAndFlushAllPendingFixups", "applier", "Landroidx/compose/runtime/Applier;", "slots", "Landroidx/compose/runtime/SlotWriter;", "rememberManager", "Landroidx/compose/runtime/RememberManager;", "errorContext", "Landroidx/compose/runtime/changelist/OperationErrorContext;", "createAndInsertNode", "factory", "Lkotlin/Function0;", "", "insertIndex", "groupAnchor", "Landroidx/compose/runtime/Anchor;", "endNodeInsert", "updateNode", "V", "T", "value", "block", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "toDebugString", "", "linePrefix", "runtime"})
public final class FixupList
extends OperationsDebugStringFormattable {
    private final Operations operations = new Operations();
    private final Operations pendingOperations = new Operations();
    public static final int $stable = 8;

    public final int getSize() {
        return this.operations.getSize();
    }

    public final boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public final boolean isNotEmpty() {
        return this.operations.isNotEmpty();
    }

    public final void clear() {
        this.pendingOperations.clear();
        this.operations.clear();
    }

    public final void executeAndFlushAllPendingFixups(Applier<?> applier, SlotWriter slotWriter, RememberManager rememberManager, OperationErrorContext operationErrorContext) {
        boolean bl = this.pendingOperations.isEmpty();
        if (!bl) {
            ComposerKt.composeImmediateRuntimeError("FixupList has pending fixup operations that were not realized. Were there mismatched insertNode() and endNodeInsert() calls?");
        }
        this.operations.executeAndFlushAllPendingOperations(applier, slotWriter, rememberManager, operationErrorContext);
    }

    public final void createAndInsertNode(Function0<? extends Object> object, int n2, Anchor anchor) {
        Operations operations = this.operations;
        Operation operation = Operation.InsertNodeFixup.INSTANCE;
        operations.pushOp(operation);
        Operations operations2 = Operations.WriteScope.constructor-impl(operations);
        Operations.WriteScope.setObject-DKhxnng(operations2, Operation.ObjectParameter.constructor-impl(0), object);
        Operations operations3 = operations2;
        Object object2 = object = operations3;
        object = object2;
        operations3.intArgs[object2.intArgsSize - object.opCodes[object.opCodesSize - 1].getInts()] = n2;
        Operations.WriteScope.setObject-DKhxnng(operations2, Operation.ObjectParameter.constructor-impl(1), anchor);
        operations.ensureAllArgumentsPushedFor(operation);
        operations = this.pendingOperations;
        operation = Operation.PostInsertNodeFixup.INSTANCE;
        operations.pushOp(operation);
        operations2 = Operations.WriteScope.constructor-impl(operations);
        Operations operations4 = operations2;
        Object object3 = object = operations4;
        object = object3;
        operations4.intArgs[object3.intArgsSize - object.opCodes[object.opCodesSize - 1].getInts()] = n2;
        Operations.WriteScope.setObject-DKhxnng(operations2, Operation.ObjectParameter.constructor-impl(0), anchor);
        operations.ensureAllArgumentsPushedFor(operation);
    }

    public final void endNodeInsert() {
        boolean bl = this.pendingOperations.isNotEmpty();
        if (!bl) {
            ComposerKt.composeImmediateRuntimeError("Cannot end node insertion, there are no pending operations that can be realized.");
        }
        this.pendingOperations.popInto(this.operations);
    }

    public final <V, T> void updateNode(V v2, Function2<? super T, ? super V, Unit> function2) {
        Operations operations = this.operations;
        Operation operation = Operation.UpdateNode.INSTANCE;
        operations.pushOp(operation);
        Operations operations2 = Operations.WriteScope.constructor-impl(operations);
        Operations.WriteScope.setObject-DKhxnng(operations2, Operation.ObjectParameter.constructor-impl(0), v2);
        int n2 = Operation.ObjectParameter.constructor-impl(1);
        Intrinsics.checkNotNull(function2);
        Operations.WriteScope.setObject-DKhxnng(operations2, n2, (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function2, (int)2));
        operations.ensureAllArgumentsPushedFor(operation);
    }

    @Override
    public final String toDebugString(String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append("FixupList instance containing " + this.getSize() + " operations");
        if (((CharSequence)stringBuilder2).length() > 0) {
            stringBuilder2.append(":\n" + ((OperationsDebugStringFormattable)this.operations).toDebugString(string));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }
}

