/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5.packet;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.e.a.i;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.InternetAddress;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class Bytestream
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private String sessionID;
    private Mode mode = Mode.tcp;
    private final List<StreamHost> streamHosts = new ArrayList<StreamHost>();
    private StreamHostUsed usedHost;
    private Activate toActivate;

    public Bytestream() {
        super(ELEMENT, NAMESPACE);
    }

    public Bytestream(String string) {
        this();
        this.setSessionID(string);
    }

    public void setSessionID(String string) {
        this.sessionID = string;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public StreamHost addStreamHost(i i2, String string) {
        return this.addStreamHost(i2, string, 0);
    }

    public StreamHost addStreamHost(i object, String string, int n) {
        object = new StreamHost((i)object, string, n);
        this.addStreamHost((StreamHost)object);
        return object;
    }

    public void addStreamHost(StreamHost streamHost) {
        this.streamHosts.add(streamHost);
    }

    public List<StreamHost> getStreamHosts() {
        return Collections.unmodifiableList(this.streamHosts);
    }

    public StreamHost getStreamHost(i i2) {
        if (i2 == null) {
            return null;
        }
        for (StreamHost streamHost : this.streamHosts) {
            if (!streamHost.getJID().a((CharSequence)i2)) continue;
            return streamHost;
        }
        return null;
    }

    public int countStreamHosts() {
        return this.streamHosts.size();
    }

    public void setUsedHost(i i2) {
        this.usedHost = new StreamHostUsed(i2);
    }

    public StreamHostUsed getUsedHost() {
        return this.usedHost;
    }

    public Activate getToActivate() {
        return this.toActivate;
    }

    public void setToActivate(i i2) {
        this.toActivate = new Activate(i2);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        switch (this.getType()) {
            case set: {
                iQChildElementXmlStringBuilder.optAttribute("sid", this.getSessionID());
                iQChildElementXmlStringBuilder.optAttribute("mode", (Enum)this.getMode());
                iQChildElementXmlStringBuilder.rightAngleBracket();
                if (this.getToActivate() == null) {
                    for (StreamHost streamHost : this.getStreamHosts()) {
                        iQChildElementXmlStringBuilder.append(streamHost.toXML());
                    }
                    break;
                }
                iQChildElementXmlStringBuilder.append(this.getToActivate().toXML());
                break;
            }
            case result: {
                iQChildElementXmlStringBuilder.rightAngleBracket();
                iQChildElementXmlStringBuilder.optAppend((Element)this.getUsedHost());
                for (StreamHost streamHost : this.streamHosts) {
                    iQChildElementXmlStringBuilder.append(streamHost.toXML());
                }
                break;
            }
            case get: {
                iQChildElementXmlStringBuilder.setEmptyElement();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return iQChildElementXmlStringBuilder;
    }

    public static enum Mode {
        tcp,
        udp;


        public static Mode fromName(String object) {
            try {
                object = Mode.valueOf(object);
            }
            catch (Exception exception) {
                object = tcp;
            }
            return object;
        }
    }

    public static class Activate
    extends BytestreamExtensionElement {
        public static String ELEMENTNAME = "activate";
        private final i target;

        public Activate(i i2) {
            this.target = i2;
        }

        public i getTarget() {
            return this.target;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.escape((CharSequence)this.getTarget());
            xmlEnvironment.closeElement((NamedElement)this);
            return xmlEnvironment;
        }
    }

    public static class StreamHostUsed
    extends BytestreamExtensionElement {
        public static String ELEMENTNAME = "streamhost-used";
        private final i jid;

        public StreamHostUsed(i i2) {
            this.jid = i2;
        }

        public i getJID() {
            return this.jid;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.attribute("jid", (CharSequence)this.getJID());
            xmlEnvironment.closeEmptyElement();
            return xmlEnvironment;
        }
    }

    public static class StreamHost
    extends BytestreamExtensionElement {
        public static String ELEMENTNAME = "streamhost";
        private final i jid;
        private final InternetAddress address;
        private final int port;

        public StreamHost(i i2, String string) {
            this(i2, string, 0);
        }

        public StreamHost(i i2, String string, int n) {
            this(i2, InternetAddress.fromIgnoringZoneId((String)string), n);
        }

        public StreamHost(i i2, InetAddress inetAddress, int n) {
            this(i2, InternetAddress.from((InetAddress)inetAddress), n);
        }

        public StreamHost(i i2, InternetAddress internetAddress, int n) {
            this.jid = (i)Objects.requireNonNull((Object)i2, (String)"StreamHost JID must not be null");
            this.address = (InternetAddress)Objects.requireNonNull((Object)internetAddress);
            this.port = n;
        }

        public i getJID() {
            return this.jid;
        }

        public InternetAddress getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.attribute("jid", (CharSequence)this.getJID());
            xmlEnvironment.attribute("host", (CharSequence)this.address);
            if (this.getPort() != 0) {
                xmlEnvironment.attribute("port", Integer.toString(this.getPort()));
            } else {
                xmlEnvironment.attribute("zeroconf", "_jabber.bytestreams");
            }
            xmlEnvironment.closeEmptyElement();
            return xmlEnvironment;
        }

        public String toString() {
            return "SOCKS5 Stream Host: " + this.jid + "[" + this.address + ":" + this.port + "]";
        }
    }

    private static abstract class BytestreamExtensionElement
    implements ExtensionElement {
        private BytestreamExtensionElement() {
        }

        public final String getNamespace() {
            return Bytestream.NAMESPACE;
        }
    }
}

