/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.LocalCommand;
import org.jivesoftware.smackx.commands.LocalCommandFactory;
import org.jivesoftware.smackx.commands.RemoteCommand;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class AdHocCommandManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/commands";
    private static final Logger LOGGER = Logger.getLogger(AdHocCommandManager.class.getName());
    private static final int SESSION_TIMEOUT = 120;
    private static final Map<XMPPConnection, AdHocCommandManager> instances = new WeakHashMap<XMPPConnection, AdHocCommandManager>();
    private final Map<String, AdHocCommandInfo> commands = new ConcurrentHashMap<String, AdHocCommandInfo>();
    private final Map<String, LocalCommand> executingCommands = new ConcurrentHashMap<String, LocalCommand>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private boolean sessionSweeperScheduled;

    public static synchronized AdHocCommandManager getAddHocCommandsManager(XMPPConnection xMPPConnection) {
        AdHocCommandManager adHocCommandManager = instances.get(xMPPConnection);
        if (adHocCommandManager == null) {
            adHocCommandManager = new AdHocCommandManager(xMPPConnection);
            instances.put(xMPPConnection, adHocCommandManager);
        }
        return adHocCommandManager;
    }

    private AdHocCommandManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature(NAMESPACE);
        ServiceDiscoveryManager.getInstanceFor(xMPPConnection).setNodeInformationProvider(NAMESPACE, new AbstractNodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                ArrayList<DiscoverItems.Item> arrayList = new ArrayList<DiscoverItems.Item>();
                Object object = AdHocCommandManager.this.getRegisteredCommands();
                object = object.iterator();
                while (object.hasNext()) {
                    AdHocCommandInfo adHocCommandInfo = (AdHocCommandInfo)object.next();
                    DiscoverItems.Item item = new DiscoverItems.Item(adHocCommandInfo.getOwnerJID());
                    item.setName(adHocCommandInfo.getName());
                    item.setNode(adHocCommandInfo.getNode());
                    arrayList.add(item);
                }
                return arrayList;
            }
        });
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("command", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                iQ = (AdHocCommandData)iQ;
                try {
                    return AdHocCommandManager.this.processAdHocCommand((AdHocCommandData)iQ);
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException throwable) {
                    LOGGER.log(Level.INFO, "processAdHocCommand threw exception", throwable);
                    return null;
                }
            }
        });
    }

    public final void registerCommand(String string, String string2, final Class<? extends LocalCommand> clazz) {
        this.registerCommand(string, string2, new LocalCommandFactory(){

            @Override
            public LocalCommand getInstance() {
                return (LocalCommand)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        });
    }

    public final void registerCommand(String string, final String string2, LocalCommandFactory object) {
        object = new AdHocCommandInfo(string, string2, (i)this.connection().getUser(), (LocalCommandFactory)object);
        this.commands.put(string, (AdHocCommandInfo)object);
        this.serviceDiscoveryManager.setNodeInformationProvider(string, new AbstractNodeInformationProvider(){

            @Override
            public List<String> getNodeFeatures() {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(AdHocCommandManager.NAMESPACE);
                arrayList.add("jabber:x:data");
                return arrayList;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                ArrayList<DiscoverInfo.Identity> arrayList = new ArrayList<DiscoverInfo.Identity>();
                DiscoverInfo.Identity identity = new DiscoverInfo.Identity("automation", string2, "command-node");
                arrayList.add(identity);
                return arrayList;
            }
        });
    }

    public final DiscoverItems discoverCommands(i i2) {
        return this.serviceDiscoveryManager.discoverItems(i2, NAMESPACE);
    }

    public final RemoteCommand getRemoteCommand(i i2, String string) {
        return new RemoteCommand(this.connection(), string, i2);
    }

    private IQ processAdHocCommand(AdHocCommandData object) {
        AdHocCommandData adHocCommandData = new AdHocCommandData();
        adHocCommandData.setTo(object.getFrom());
        adHocCommandData.setStanzaId(object.getStanzaId());
        adHocCommandData.setNode(((AdHocCommandData)((Object)object)).getNode());
        adHocCommandData.setId(object.getTo());
        String string = ((AdHocCommandData)((Object)object)).getSessionID();
        Object object2 = ((AdHocCommandData)((Object)object)).getNode();
        if (string == null) {
            if (!this.commands.containsKey(object2)) {
                return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.item_not_found);
            }
            string = StringUtils.randomString((int)15);
            try {
                try {
                    object2 = this.newInstanceOfCmd((String)object2, string);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.internal_server_error).setDescriptiveEnText(exception.getMessage())).build();
                    return AdHocCommandManager.respondError(adHocCommandData, stanzaError);
                }
                adHocCommandData.setType(IQ.Type.result);
                ((LocalCommand)object2).setData(adHocCommandData);
                if (!((LocalCommand)object2).hasPermission(object.getFrom())) {
                    return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.forbidden);
                }
                AdHocCommand.Action action = ((AdHocCommandData)((Object)object)).getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                }
                if (action != null && !action.equals((Object)AdHocCommand.Action.execute)) {
                    return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                }
                ((LocalCommand)object2).incrementStage();
                ((AdHocCommand)object2).execute();
                if (((LocalCommand)object2).isLastStage()) {
                    adHocCommandData.setStatus(AdHocCommand.Status.completed);
                } else {
                    adHocCommandData.setStatus(AdHocCommand.Status.executing);
                    this.executingCommands.put(string, (LocalCommand)object2);
                    this.maybeWindUpSessionSweeper();
                }
                return adHocCommandData;
            }
            catch (XMPPException.XMPPErrorException xMPPErrorException) {
                object2 = xMPPErrorException;
                StanzaError stanzaError = xMPPErrorException.getStanzaError();
                if (StanzaError.Type.CANCEL.equals((Object)stanzaError.getType())) {
                    adHocCommandData.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(string);
                }
                return AdHocCommandManager.respondError(adHocCommandData, stanzaError);
            }
        }
        object2 = this.executingCommands.get(string);
        if (object2 == null) {
            return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badSessionid);
        }
        long l = ((LocalCommand)object2).getCreationDate();
        if (System.currentTimeMillis() - l > 120000L) {
            this.executingCommands.remove(string);
            return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.not_allowed, AdHocCommand.SpecificErrorCondition.sessionExpired);
        }
        Object object3 = object2;
        synchronized (object3) {
            AdHocCommand.Action action = ((AdHocCommandData)((Object)object)).getAction();
            if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
            }
            if (action == null || AdHocCommand.Action.execute.equals((Object)action)) {
                action = ((AdHocCommand)object2).getExecuteAction();
            }
            if (!((AdHocCommand)object2).isValidAction(action)) {
                return AdHocCommandManager.respondError(adHocCommandData, StanzaError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
            }
            try {
                adHocCommandData.setType(IQ.Type.result);
                ((LocalCommand)object2).setData(adHocCommandData);
                if (AdHocCommand.Action.next.equals((Object)action)) {
                    ((LocalCommand)object2).incrementStage();
                    object = ((AdHocCommandData)((Object)object)).getForm();
                    ((AdHocCommand)object2).next(new FillableForm((DataForm)object));
                    if (((LocalCommand)object2).isLastStage()) {
                        adHocCommandData.setStatus(AdHocCommand.Status.completed);
                    } else {
                        adHocCommandData.setStatus(AdHocCommand.Status.executing);
                    }
                } else if (AdHocCommand.Action.complete.equals((Object)action)) {
                    ((LocalCommand)object2).incrementStage();
                    object = ((AdHocCommandData)((Object)object)).getForm();
                    ((AdHocCommand)object2).complete(new FillableForm((DataForm)object));
                    adHocCommandData.setStatus(AdHocCommand.Status.completed);
                    this.executingCommands.remove(string);
                } else if (AdHocCommand.Action.prev.equals((Object)action)) {
                    ((LocalCommand)object2).decrementStage();
                    ((AdHocCommand)object2).prev();
                } else if (AdHocCommand.Action.cancel.equals((Object)action)) {
                    ((AdHocCommand)object2).cancel();
                    adHocCommandData.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(string);
                }
                return adHocCommandData;
            }
            catch (XMPPException.XMPPErrorException xMPPErrorException) {
                object = xMPPErrorException;
                object = xMPPErrorException.getStanzaError();
                if (StanzaError.Type.CANCEL.equals((Object)object.getType())) {
                    adHocCommandData.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(string);
                }
                return AdHocCommandManager.respondError(adHocCommandData, (StanzaError)object);
            }
        }
    }

    private void sessionSweeper() {
        long l = System.currentTimeMillis();
        AdHocCommandManager adHocCommandManager = this;
        synchronized (adHocCommandManager) {
            Iterator<Map.Entry<String, LocalCommand>> iterator = this.executingCommands.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                long l2 = ((LocalCommand)(object = object.getValue())).getCreationDate();
                if (l - l2 <= 240000L) continue;
                iterator.remove();
            }
            this.sessionSweeperScheduled = false;
        }
        if (!this.executingCommands.isEmpty()) {
            this.maybeWindUpSessionSweeper();
        }
    }

    private synchronized void maybeWindUpSessionSweeper() {
        if (this.sessionSweeperScheduled) {
            return;
        }
        this.sessionSweeperScheduled = true;
        AdHocCommandManager.schedule(this::sessionSweeper, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    private static IQ respondError(AdHocCommandData adHocCommandData, StanzaError.Condition condition) {
        return AdHocCommandManager.respondError(adHocCommandData, StanzaError.getBuilder((StanzaError.Condition)condition).build());
    }

    private static IQ respondError(AdHocCommandData adHocCommandData, StanzaError.Condition condition, AdHocCommand.SpecificErrorCondition specificErrorCondition) {
        condition = ((StanzaError.Builder)StanzaError.getBuilder((StanzaError.Condition)condition).addExtension((ExtensionElement)new AdHocCommandData.SpecificError(specificErrorCondition))).build();
        return AdHocCommandManager.respondError(adHocCommandData, (StanzaError)condition);
    }

    private static IQ respondError(AdHocCommandData adHocCommandData, StanzaError stanzaError) {
        adHocCommandData.setType(IQ.Type.error);
        adHocCommandData.setError(stanzaError);
        return adHocCommandData;
    }

    private LocalCommand newInstanceOfCmd(String object, String string) {
        object = this.commands.get(object);
        LocalCommand localCommand = ((AdHocCommandInfo)object).getCommandInstance();
        localCommand.setSessionID(string);
        localCommand.setName(((AdHocCommandInfo)object).getName());
        localCommand.setNode(((AdHocCommandInfo)object).getNode());
        return localCommand;
    }

    private Collection<AdHocCommandInfo> getRegisteredCommands() {
        return this.commands.values();
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                AdHocCommandManager.getAddHocCommandsManager(xMPPConnection);
            }
        });
    }

    private static final class AdHocCommandInfo {
        private String node;
        private String name;
        private final i ownerJID;
        private LocalCommandFactory factory;

        private AdHocCommandInfo(String string, String string2, i i2, LocalCommandFactory localCommandFactory) {
            this.node = string;
            this.name = string2;
            this.ownerJID = i2;
            this.factory = localCommandFactory;
        }

        public final LocalCommand getCommandInstance() {
            return this.factory.getInstance();
        }

        public final String getName() {
            return this.name;
        }

        public final String getNode() {
            return this.node;
        }

        public final i getOwnerJID() {
            return this.ownerJID;
        }
    }
}

