/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import org.e.a.h;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smackx.jingle.FullJidAndSessionId;
import org.jivesoftware.smackx.jingle.JingleSessionHandler;
import org.jivesoftware.smackx.jingle.Role;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;

public abstract class JingleSession
implements JingleSessionHandler {
    protected HashSet<String> failedTransportMethods = new HashSet();
    protected final h local;
    protected final h remote;
    protected final Role role;
    protected final String sid;
    protected final List<JingleContent> contents = new ArrayList<JingleContent>();
    protected ArrayList<Future<?>> queued = new ArrayList();
    protected JingleTransportSession<?> transportSession;

    public JingleSession(h h2, h h3, Role role, String string) {
        this(h2, h3, role, string, null);
    }

    public JingleSession(h h2, h h3, Role role, String string, List<JingleContent> list) {
        if (role == Role.initiator) {
            this.local = h2;
            this.remote = h3;
        } else {
            this.local = h3;
            this.remote = h2;
        }
        this.sid = string;
        this.role = role;
        if (list != null) {
            this.contents.addAll(list);
        }
    }

    public h getInitiator() {
        if (this.isInitiator()) {
            return this.local;
        }
        return this.remote;
    }

    public boolean isInitiator() {
        return this.role == Role.initiator;
    }

    public h getResponder() {
        if (this.isResponder()) {
            return this.local;
        }
        return this.remote;
    }

    public boolean isResponder() {
        return this.role == Role.responder;
    }

    public h getRemote() {
        return this.remote;
    }

    public h getLocal() {
        return this.local;
    }

    public String getSessionId() {
        return this.sid;
    }

    public FullJidAndSessionId getFullJidAndSessionId() {
        return new FullJidAndSessionId(this.remote, this.sid);
    }

    public List<JingleContent> getContents() {
        return this.contents;
    }

    public JingleTransportSession<?> getTransportSession() {
        return this.transportSession;
    }

    protected void setTransportSession(JingleTransportSession<?> jingleTransportSession) {
        this.transportSession = jingleTransportSession;
    }

    public int hashCode() {
        return HashCode.builder().append((Object)this.getInitiator()).append((Object)this.getResponder()).append((Object)this.getSessionId()).build();
    }

    public boolean equals(Object object) {
        return EqualsUtil.equals((Object)this, (Object)object, (builder, jingleSession) -> builder.append((Object)this.getInitiator(), (Object)jingleSession.getInitiator()).append((Object)this.getResponder(), (Object)jingleSession.getResponder()).append((Object)this.sid, (Object)jingleSession.sid));
    }

    @Override
    public IQ handleJingleSessionRequest(Jingle jingle) {
        switch (jingle.getAction()) {
            case content_accept: {
                return this.handleContentAccept(jingle);
            }
            case content_add: {
                return this.handleContentAdd(jingle);
            }
            case content_modify: {
                return this.handleContentModify(jingle);
            }
            case content_reject: {
                return this.handleContentReject(jingle);
            }
            case content_remove: {
                return this.handleContentRemove(jingle);
            }
            case description_info: {
                return this.handleDescriptionInfo(jingle);
            }
            case session_info: {
                return this.handleSessionInfo(jingle);
            }
            case security_info: {
                return this.handleSecurityInfo(jingle);
            }
            case session_accept: {
                return this.handleSessionAccept(jingle);
            }
            case transport_accept: {
                return this.handleTransportAccept(jingle);
            }
            case transport_info: {
                return this.transportSession.handleTransportInfo(jingle);
            }
            case session_initiate: {
                return this.handleSessionInitiate(jingle);
            }
            case transport_reject: {
                return this.handleTransportReject(jingle);
            }
            case session_terminate: {
                return this.handleSessionTerminate(jingle);
            }
            case transport_replace: {
                return this.handleTransportReplace(jingle);
            }
        }
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleSessionInitiate(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleSessionTerminate(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleSessionInfo(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleSessionAccept(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleContentAdd(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleContentAccept(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleContentModify(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleContentReject(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleContentRemove(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleDescriptionInfo(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleSecurityInfo(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleTransportAccept(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleTransportReplace(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    protected IQ handleTransportReject(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    public abstract XMPPConnection getConnection();

    public abstract void onTransportMethodFailed(String var1);
}

