/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.element;

import java.util.HashMap;
import java.util.Map;

public enum JingleAction {
    content_accept,
    content_add,
    content_modify,
    content_reject,
    content_remove,
    description_info,
    security_info,
    session_accept,
    session_info,
    session_initiate,
    session_terminate,
    transport_accept,
    transport_info,
    transport_reject,
    transport_replace;

    private static final Map<String, JingleAction> map;
    private final String asString = this.name().replace('_', '-');

    public final String toString() {
        return this.asString;
    }

    public static JingleAction fromString(String string) {
        JingleAction jingleAction = map.get(string);
        if (jingleAction == null) {
            throw new IllegalArgumentException("Unknown jingle action: " + string);
        }
        return jingleAction;
    }

    static {
        map = new HashMap<String, JingleAction>(JingleAction.values().length);
        for (JingleAction jingleAction : JingleAction.values()) {
            map.put(jingleAction.toString(), jingleAction);
        }
    }
}

