/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.packet;

import java.util.Objects;
import org.jivesoftware.smack.datatypes.UInt32;

public class PrivacyItem {
    public static final String SUBSCRIPTION_BOTH = "both";
    public static final String SUBSCRIPTION_TO = "to";
    public static final String SUBSCRIPTION_FROM = "from";
    public static final String SUBSCRIPTION_NONE = "none";
    private final boolean allow;
    private final UInt32 order;
    private final Type type;
    private final String value;
    private boolean filterIQ = false;
    private boolean filterMessage = false;
    private boolean filterPresenceIn = false;
    private boolean filterPresenceOut = false;

    public PrivacyItem(boolean bl, long l) {
        this(null, null, bl, UInt32.from((long)l));
    }

    public PrivacyItem(boolean bl, UInt32 uInt32) {
        this(null, null, bl, uInt32);
    }

    public PrivacyItem(Type type, String string, boolean bl, long l) {
        this(type, string, bl, UInt32.from((long)l));
    }

    public PrivacyItem(Type type, String string, boolean bl, UInt32 uInt32) {
        this.type = type;
        this.value = string;
        this.allow = bl;
        this.order = Objects.requireNonNull(uInt32);
    }

    public PrivacyItem(Type type, CharSequence charSequence, boolean bl, long l) {
        this(type, charSequence != null ? charSequence.toString() : null, bl, l);
    }

    public boolean isAllow() {
        return this.allow;
    }

    public boolean isFilterIQ() {
        return this.filterIQ;
    }

    public void setFilterIQ(boolean bl) {
        this.filterIQ = bl;
    }

    public boolean isFilterMessage() {
        return this.filterMessage;
    }

    public void setFilterMessage(boolean bl) {
        this.filterMessage = bl;
    }

    public boolean isFilterPresenceIn() {
        return this.filterPresenceIn;
    }

    public void setFilterPresenceIn(boolean bl) {
        this.filterPresenceIn = bl;
    }

    public boolean isFilterPresenceOut() {
        return this.filterPresenceOut;
    }

    public void setFilterPresenceOut(boolean bl) {
        this.filterPresenceOut = bl;
    }

    public UInt32 getOrder() {
        return this.order;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isFilterEverything() {
        return !this.isFilterIQ() && !this.isFilterMessage() && !this.isFilterPresenceIn() && !this.isFilterPresenceOut();
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<item");
        if (this.isAllow()) {
            stringBuilder.append(" action=\"allow\"");
        } else {
            stringBuilder.append(" action=\"deny\"");
        }
        stringBuilder.append(" order=\"").append((CharSequence)this.getOrder()).append('\"');
        if (this.getType() != null) {
            stringBuilder.append(" type=\"").append((Object)this.getType()).append('\"');
        }
        if (this.getValue() != null) {
            stringBuilder.append(" value=\"").append(this.getValue()).append('\"');
        }
        if (this.isFilterEverything()) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append('>');
            if (this.isFilterIQ()) {
                stringBuilder.append("<iq/>");
            }
            if (this.isFilterMessage()) {
                stringBuilder.append("<message/>");
            }
            if (this.isFilterPresenceIn()) {
                stringBuilder.append("<presence-in/>");
            }
            if (this.isFilterPresenceOut()) {
                stringBuilder.append("<presence-out/>");
            }
            stringBuilder.append("</item>");
        }
        return stringBuilder.toString();
    }

    public static enum Type {
        group,
        jid,
        subscription;

    }
}

