/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.packet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.e;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.vcardtemp.VCardManager;

public final class VCard
extends IQ {
    public static final String ELEMENT = "vCard";
    public static final String NAMESPACE = "vcard-temp";
    private static final Logger LOGGER = Logger.getLogger(VCard.class.getName());
    private static final String DEFAULT_MIME_TYPE = "image/jpeg";
    private final Map<String, String> homePhones = new HashMap<String, String>();
    private final Map<String, String> workPhones = new HashMap<String, String>();
    private final Map<String, String> homeAddr = new HashMap<String, String>();
    private final Map<String, String> workAddr = new HashMap<String, String>();
    private String firstName;
    private String lastName;
    private String middleName;
    private String prefix;
    private String suffix;
    private String emailHome;
    private String emailWork;
    private String organization;
    private String organizationUnit;
    private String photoMimeType;
    private String photoBinval;
    private final Map<String, String> otherSimpleFields = new HashMap<String, String>();
    private final Map<String, String> otherUnescapableFields = new HashMap<String, String>();

    public VCard() {
        super(ELEMENT, NAMESPACE);
    }

    public final String getField(String string) {
        return this.otherSimpleFields.get(string);
    }

    public final void setField(String string, String string2) {
        this.setField(string, string2, false);
    }

    public final void setField(String string, String string2, boolean bl) {
        if (!bl) {
            this.otherSimpleFields.put(string, string2);
            return;
        }
        this.otherUnescapableFields.put(string, string2);
    }

    public final String getFirstName() {
        return this.firstName;
    }

    public final void setFirstName(String string) {
        this.firstName = string;
        this.updateFN();
    }

    public final String getLastName() {
        return this.lastName;
    }

    public final void setLastName(String string) {
        this.lastName = string;
        this.updateFN();
    }

    public final String getMiddleName() {
        return this.middleName;
    }

    public final void setMiddleName(String string) {
        this.middleName = string;
        this.updateFN();
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String string) {
        this.prefix = string;
        this.updateFN();
    }

    public final String getSuffix() {
        return this.suffix;
    }

    public final void setSuffix(String string) {
        this.suffix = string;
        this.updateFN();
    }

    public final String getNickName() {
        return this.otherSimpleFields.get("NICKNAME");
    }

    public final void setNickName(String string) {
        this.otherSimpleFields.put("NICKNAME", string);
    }

    public final String getEmailHome() {
        return this.emailHome;
    }

    public final void setEmailHome(String string) {
        this.emailHome = string;
    }

    public final String getEmailWork() {
        return this.emailWork;
    }

    public final void setEmailWork(String string) {
        this.emailWork = string;
    }

    public final String getJabberId() {
        return this.otherSimpleFields.get("JABBERID");
    }

    public final void setJabberId(CharSequence charSequence) {
        this.otherSimpleFields.put("JABBERID", charSequence.toString());
    }

    public final String getOrganization() {
        return this.organization;
    }

    public final void setOrganization(String string) {
        this.organization = string;
    }

    public final String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public final void setOrganizationUnit(String string) {
        this.organizationUnit = string;
    }

    public final String getAddressFieldHome(String string) {
        return this.homeAddr.get(string);
    }

    public final void setAddressFieldHome(String string, String string2) {
        this.homeAddr.put(string, string2);
    }

    public final String getAddressFieldWork(String string) {
        return this.workAddr.get(string);
    }

    public final void setAddressFieldWork(String string, String string2) {
        this.workAddr.put(string, string2);
    }

    public final void setPhoneHome(String string, String string2) {
        this.homePhones.put(string, string2);
    }

    public final String getPhoneHome(String string) {
        return this.homePhones.get(string);
    }

    public final void setPhoneWork(String string, String string2) {
        this.workPhones.put(string, string2);
    }

    public final String getPhoneWork(String string) {
        return this.workPhones.get(string);
    }

    public final void setAvatar(URL uRL) {
        byte[] byArray = new byte[]{};
        try {
            byArray = VCard.getBytes(uRL);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Error getting bytes from URL: " + uRL, iOException);
        }
        this.setAvatar(byArray);
    }

    public final void removeAvatar() {
        this.photoBinval = null;
        this.photoMimeType = null;
    }

    public final void setAvatar(byte[] byArray) {
        this.setAvatar(byArray, DEFAULT_MIME_TYPE);
    }

    public final void setAvatar(byte[] object, String string) {
        if (object == null) {
            this.removeAvatar();
            return;
        }
        object = Base64.encodeToString((byte[])object);
        this.setAvatar((String)object, string);
    }

    public final void setAvatar(String string, String string2) {
        this.photoBinval = string;
        this.photoMimeType = string2;
    }

    @Deprecated
    public final void setEncodedImage(String string) {
        this.setAvatar(string, DEFAULT_MIME_TYPE);
    }

    public final byte[] getAvatar() {
        if (this.photoBinval == null) {
            return null;
        }
        return Base64.decode((String)this.photoBinval);
    }

    public final String getAvatarMimeType() {
        return this.photoMimeType;
    }

    public static byte[] getBytes(URL object) {
        object = ((URL)object).getPath();
        if (((File)(object = new File((String)object))).exists()) {
            return VCard.getFileBytes((File)object);
        }
        return null;
    }

    private static byte[] getFileBytes(File file) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            n = bufferedInputStream.read(byArray);
            if (n != byArray.length) {
                throw new IOException("Entire file not read");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    public final String getAvatarHash() {
        MessageDigest messageDigest;
        byte[] byArray = this.getAvatar();
        if (byArray == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.SEVERE, "Failed to get message digest", noSuchAlgorithmException);
            return null;
        }
        messageDigest.update(byArray);
        return StringUtils.encodeHex((byte[])messageDigest.digest());
    }

    private void updateFN() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.firstName != null) {
            stringBuilder.append(StringUtils.escapeForXml((CharSequence)this.firstName)).append(' ');
        }
        if (this.middleName != null) {
            stringBuilder.append(StringUtils.escapeForXml((CharSequence)this.middleName)).append(' ');
        }
        if (this.lastName != null) {
            stringBuilder.append(StringUtils.escapeForXml((CharSequence)this.lastName));
        }
        this.setField("FN", stringBuilder.toString());
    }

    @Deprecated
    public final void save(XMPPConnection xMPPConnection) {
        VCardManager.getInstanceFor(xMPPConnection).saveVCard(this);
    }

    @Deprecated
    public final void load(XMPPConnection xMPPConnection) {
        this.load(xMPPConnection, null);
    }

    @Deprecated
    public final void load(XMPPConnection object, e e2) {
        object = VCardManager.getInstanceFor(object).loadVCard(e2);
        this.copyFieldsFrom((VCard)((Object)object));
    }

    protected final IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        String string;
        if (!this.hasContent()) {
            iQChildElementXmlStringBuilder.setEmptyElement();
            return iQChildElementXmlStringBuilder;
        }
        iQChildElementXmlStringBuilder.rightAngleBracket();
        if (this.hasNameField()) {
            iQChildElementXmlStringBuilder.openElement("N");
            iQChildElementXmlStringBuilder.optElement("FAMILY", this.lastName);
            iQChildElementXmlStringBuilder.optElement("GIVEN", this.firstName);
            iQChildElementXmlStringBuilder.optElement("MIDDLE", this.middleName);
            iQChildElementXmlStringBuilder.optElement("PREFIX", this.prefix);
            iQChildElementXmlStringBuilder.optElement("SUFFIX", this.suffix);
            iQChildElementXmlStringBuilder.closeElement("N");
        }
        if (this.hasOrganizationFields()) {
            iQChildElementXmlStringBuilder.openElement("ORG");
            iQChildElementXmlStringBuilder.optElement("ORGNAME", this.organization);
            iQChildElementXmlStringBuilder.optElement("ORGUNIT", this.organizationUnit);
            iQChildElementXmlStringBuilder.closeElement("ORG");
        }
        for (Map.Entry<String, String> entry : this.otherSimpleFields.entrySet()) {
            iQChildElementXmlStringBuilder.optElement(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.otherUnescapableFields.entrySet()) {
            string = entry.getValue();
            if (string == null) continue;
            iQChildElementXmlStringBuilder.openElement(entry.getKey());
            iQChildElementXmlStringBuilder.append((CharSequence)string);
            iQChildElementXmlStringBuilder.closeElement(entry.getKey());
        }
        if (this.photoBinval != null) {
            iQChildElementXmlStringBuilder.openElement("PHOTO");
            iQChildElementXmlStringBuilder.escapedElement("BINVAL", this.photoBinval);
            iQChildElementXmlStringBuilder.element("TYPE", this.photoMimeType);
            iQChildElementXmlStringBuilder.closeElement("PHOTO");
        }
        if (this.emailWork != null) {
            iQChildElementXmlStringBuilder.openElement("EMAIL");
            iQChildElementXmlStringBuilder.emptyElement("WORK");
            iQChildElementXmlStringBuilder.emptyElement("INTERNET");
            iQChildElementXmlStringBuilder.emptyElement("PREF");
            iQChildElementXmlStringBuilder.element("USERID", this.emailWork);
            iQChildElementXmlStringBuilder.closeElement("EMAIL");
        }
        if (this.emailHome != null) {
            iQChildElementXmlStringBuilder.openElement("EMAIL");
            iQChildElementXmlStringBuilder.emptyElement("HOME");
            iQChildElementXmlStringBuilder.emptyElement("INTERNET");
            iQChildElementXmlStringBuilder.emptyElement("PREF");
            iQChildElementXmlStringBuilder.element("USERID", this.emailHome);
            iQChildElementXmlStringBuilder.closeElement("EMAIL");
        }
        for (Map.Entry<String, String> entry : this.workPhones.entrySet()) {
            string = entry.getValue();
            if (string == null) continue;
            iQChildElementXmlStringBuilder.openElement("TEL");
            iQChildElementXmlStringBuilder.emptyElement("WORK");
            iQChildElementXmlStringBuilder.emptyElement(entry.getKey());
            iQChildElementXmlStringBuilder.element("NUMBER", string);
            iQChildElementXmlStringBuilder.closeElement("TEL");
        }
        for (Map.Entry<String, String> entry : this.homePhones.entrySet()) {
            string = entry.getValue();
            if (string == null) continue;
            iQChildElementXmlStringBuilder.openElement("TEL");
            iQChildElementXmlStringBuilder.emptyElement("HOME");
            iQChildElementXmlStringBuilder.emptyElement(entry.getKey());
            iQChildElementXmlStringBuilder.element("NUMBER", string);
            iQChildElementXmlStringBuilder.closeElement("TEL");
        }
        if (!this.workAddr.isEmpty()) {
            iQChildElementXmlStringBuilder.openElement("ADR");
            iQChildElementXmlStringBuilder.emptyElement("WORK");
            for (Map.Entry<String, String> entry : this.workAddr.entrySet()) {
                string = entry.getValue();
                if (string == null) continue;
                iQChildElementXmlStringBuilder.element(entry.getKey(), string);
            }
            iQChildElementXmlStringBuilder.closeElement("ADR");
        }
        if (!this.homeAddr.isEmpty()) {
            iQChildElementXmlStringBuilder.openElement("ADR");
            iQChildElementXmlStringBuilder.emptyElement("HOME");
            for (Map.Entry<String, String> entry : this.homeAddr.entrySet()) {
                string = entry.getValue();
                if (string == null) continue;
                iQChildElementXmlStringBuilder.element(entry.getKey(), string);
            }
            iQChildElementXmlStringBuilder.closeElement("ADR");
        }
        return iQChildElementXmlStringBuilder;
    }

    private void copyFieldsFrom(VCard vCard) {
        Field[] fieldArray = VCard.class.getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n = fieldArray.length;
        for (int j = 0; j < n; ++j) {
            Field field = fieldArray2[j];
            if (field.getDeclaringClass() != VCard.class || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set((Object)this, field.get((Object)vCard));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("This cannot happen:" + field, illegalAccessException);
            }
        }
    }

    private boolean hasContent() {
        return this.hasNameField() || this.hasOrganizationFields() || this.emailHome != null || this.emailWork != null || this.otherSimpleFields.size() > 0 || this.otherUnescapableFields.size() > 0 || this.homeAddr.size() > 0 || this.homePhones.size() > 0 || this.workAddr.size() > 0 || this.workPhones.size() > 0 || this.photoBinval != null;
    }

    private boolean hasNameField() {
        return this.firstName != null || this.lastName != null || this.middleName != null || this.prefix != null || this.suffix != null;
    }

    private boolean hasOrganizationFields() {
        return this.organization != null || this.organizationUnit != null;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        object = (VCard)((Object)object);
        if (this.emailHome != null ? !this.emailHome.equals(((VCard)((Object)object)).emailHome) : ((VCard)((Object)object)).emailHome != null) {
            return false;
        }
        if (this.emailWork != null ? !this.emailWork.equals(((VCard)((Object)object)).emailWork) : ((VCard)((Object)object)).emailWork != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(((VCard)((Object)object)).firstName) : ((VCard)((Object)object)).firstName != null) {
            return false;
        }
        if (!this.homeAddr.equals(((VCard)((Object)object)).homeAddr)) {
            return false;
        }
        if (!this.homePhones.equals(((VCard)((Object)object)).homePhones)) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(((VCard)((Object)object)).lastName) : ((VCard)((Object)object)).lastName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(((VCard)((Object)object)).middleName) : ((VCard)((Object)object)).middleName != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(((VCard)((Object)object)).organization) : ((VCard)((Object)object)).organization != null) {
            return false;
        }
        if (this.organizationUnit != null ? !this.organizationUnit.equals(((VCard)((Object)object)).organizationUnit) : ((VCard)((Object)object)).organizationUnit != null) {
            return false;
        }
        if (!this.otherSimpleFields.equals(((VCard)((Object)object)).otherSimpleFields)) {
            return false;
        }
        if (!this.workAddr.equals(((VCard)((Object)object)).workAddr)) {
            return false;
        }
        if (this.photoBinval != null ? !this.photoBinval.equals(((VCard)((Object)object)).photoBinval) : ((VCard)((Object)object)).photoBinval != null) {
            return false;
        }
        return this.workPhones.equals(((VCard)((Object)object)).workPhones);
    }

    public final int hashCode() {
        int n = this.homePhones.hashCode();
        n = n * 29 + this.workPhones.hashCode();
        n = n * 29 + this.homeAddr.hashCode();
        n = n * 29 + this.workAddr.hashCode();
        n = n * 29 + (this.firstName != null ? this.firstName.hashCode() : 0);
        n = n * 29 + (this.lastName != null ? this.lastName.hashCode() : 0);
        n = n * 29 + (this.middleName != null ? this.middleName.hashCode() : 0);
        n = n * 29 + (this.emailHome != null ? this.emailHome.hashCode() : 0);
        n = n * 29 + (this.emailWork != null ? this.emailWork.hashCode() : 0);
        n = n * 29 + (this.organization != null ? this.organization.hashCode() : 0);
        n = n * 29 + (this.organizationUnit != null ? this.organizationUnit.hashCode() : 0);
        n = n * 29 + this.otherSimpleFields.hashCode();
        n = n * 29 + (this.photoBinval != null ? this.photoBinval.hashCode() : 0);
        return n;
    }
}

