/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao.id;

import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.EntityIDFactory;
import org.jetbrains.exposed.dao.id.IdTable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\t\u001a\u0002H\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/exposed/dao/id/EntityIDFunctionProvider;", "", "()V", "factory", "Lorg/jetbrains/exposed/dao/id/EntityIDFactory;", "createEntityID", "Lorg/jetbrains/exposed/dao/id/EntityID;", "T", "", "value", "table", "Lorg/jetbrains/exposed/dao/id/IdTable;", "(Ljava/lang/Comparable;Lorg/jetbrains/exposed/dao/id/IdTable;)Lorg/jetbrains/exposed/dao/id/EntityID;", "exposed-core"})
public final class EntityIDFunctionProvider {
    public static final EntityIDFunctionProvider INSTANCE = new EntityIDFunctionProvider();
    private static final EntityIDFactory factory;

    private EntityIDFunctionProvider() {
    }

    public final <T extends Comparable<? super T>> EntityID<T> createEntityID(T t, IdTable<T> idTable) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        Intrinsics.checkNotNullParameter(idTable, (String)"");
        return factory.createEntityID(t, idTable);
    }

    static {
        ServiceLoader<EntityIDFactory> serviceLoader = ServiceLoader.load(EntityIDFactory.class, EntityIDFactory.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"");
        EntityIDFactory entityIDFactory = (EntityIDFactory)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (entityIDFactory == null) {
            entityIDFactory = new EntityIDFactory(){

                @Override
                public final <T extends Comparable<? super T>> EntityID<T> createEntityID(T t, IdTable<T> idTable) {
                    Intrinsics.checkNotNullParameter(t, (String)"");
                    Intrinsics.checkNotNullParameter(idTable, (String)"");
                    return new EntityID<T>(t, idTable);
                }
            };
        }
        factory = entityIDFactory;
    }
}

