/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ForUpdateOption;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 H*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00050\u0004:\u0002HIB\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ&\u0010/\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u000300\u0012\u0006\u0012\u0004\u0018\u0001010\u001e0\u00070\u0007H\u0016J\u0016\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004J\u0013\u0010\u0012\u001a\u00028\u00002\u0006\u00105\u001a\u00020\u0011\u00a2\u0006\u0002\u00106J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000308H\u0096\u0002J\u001d\u0010\u0016\u001a\u00028\u00002\u0006\u00105\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u00109JA\u0010:\u001a\u00028\u000022\u0010;\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u00020 0\u001e0<\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0016\u00a2\u0006\u0002\u0010=J!\u0010:\u001a\u00028\u00002\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u001f2\b\b\u0002\u0010;\u001a\u00020 \u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH&J\u0018\u0010@\u001a\u00020A2\u0006\u0010+\u001a\u00020,2\u0006\u0010D\u001a\u00020\u000bH\u0016J\u0017\u0010E\u001a\u00028\u00002\b\b\u0002\u0010F\u001a\u00020\u000bH&\u00a2\u0006\u0002\u0010GR\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dRJ\u0010!\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u00020 0\u001e0\u00072\u001c\u0010\u0010\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u00020 0\u001e0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0012\u0010'\u001a\u00020(X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006J"}, d2={"Lorg/jetbrains/exposed/sql/AbstractQuery;", "T", "Lorg/jetbrains/exposed/sql/SizedIterable;", "Lorg/jetbrains/exposed/sql/ResultRow;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "targets", "", "Lorg/jetbrains/exposed/sql/Table;", "(Ljava/util/List;)V", "count", "", "getCount", "()Z", "setCount", "(Z)V", "<set-?>", "", "fetchSize", "getFetchSize", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "limit", "getLimit", "setLimit", "(Ljava/lang/Integer;)V", "", "offset", "getOffset", "()J", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Expression;", "Lorg/jetbrains/exposed/sql/SortOrder;", "orderByExpressions", "getOrderByExpressions", "()Ljava/util/List;", "queryToExecute", "getQueryToExecute", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "set", "Lorg/jetbrains/exposed/sql/FieldSet;", "getSet", "()Lorg/jetbrains/exposed/sql/FieldSet;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "getTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "arguments", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "copyTo", "", "other", "n", "(I)Lorg/jetbrains/exposed/sql/AbstractQuery;", "iterator", "", "(IJ)Lorg/jetbrains/exposed/sql/AbstractQuery;", "orderBy", "order", "", "([Lkotlin/Pair;)Lorg/jetbrains/exposed/sql/AbstractQuery;", "column", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/SortOrder;)Lorg/jetbrains/exposed/sql/AbstractQuery;", "prepareSQL", "", "builder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "prepared", "withDistinct", "value", "(Z)Lorg/jetbrains/exposed/sql/AbstractQuery;", "Companion", "ResultIterator", "exposed-core"})
public abstract class AbstractQuery<T extends AbstractQuery<T>>
extends Statement<ResultSet>
implements SizedIterable<ResultRow> {
    public static final Companion Companion = new Companion(null);
    private List<? extends Pair<? extends Expression<?>, ? extends SortOrder>> orderByExpressions;
    private Integer limit;
    private long offset;
    private Integer fetchSize;
    private boolean count;

    public AbstractQuery(List<? extends Table> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        super(StatementType.SELECT, list);
        this.orderByExpressions = new ArrayList();
    }

    protected final Transaction getTransaction() {
        return TransactionManager.Companion.current();
    }

    public final List<Pair<Expression<?>, SortOrder>> getOrderByExpressions() {
        return this.orderByExpressions;
    }

    public final Integer getLimit() {
        return this.limit;
    }

    protected final void setLimit(Integer n) {
        this.limit = n;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final Integer getFetchSize() {
        return this.fetchSize;
    }

    public abstract FieldSet getSet();

    protected final void copyTo(AbstractQuery<T> abstractQuery) {
        Intrinsics.checkNotNullParameter(abstractQuery, (String)"");
        abstractQuery.orderByExpressions = CollectionsKt.toMutableList((Collection)this.orderByExpressions);
        abstractQuery.limit = this.limit;
        abstractQuery.offset = this.offset;
        abstractQuery.fetchSize = this.fetchSize;
    }

    @Override
    public String prepareSQL(Transaction transaction2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return this.prepareSQL(new QueryBuilder(bl));
    }

    public abstract String prepareSQL(QueryBuilder var1);

    @Override
    public List<List<Pair<IColumnType<?>, Object>>> arguments() {
        QueryBuilder queryBuilder = new QueryBuilder(true);
        this.prepareSQL(queryBuilder);
        if (!((Collection)queryBuilder.getArgs()).isEmpty()) {
            return CollectionsKt.listOf(queryBuilder.getArgs());
        }
        return CollectionsKt.emptyList();
    }

    public abstract T withDistinct(boolean var1);

    public static /* synthetic */ AbstractQuery withDistinct$default(AbstractQuery abstractQuery, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withDistinct");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return abstractQuery.withDistinct(bl);
    }

    public T limit(int n, long l) {
        AbstractQuery abstractQuery;
        AbstractQuery abstractQuery2 = abstractQuery = this;
        abstractQuery.limit = n;
        abstractQuery2.offset = l;
        AbstractQuery abstractQuery3 = abstractQuery;
        Intrinsics.checkNotNull((Object)abstractQuery3);
        return (T)abstractQuery3;
    }

    public final T orderBy(Expression<?> expression, SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"");
        Pair[] pairArray = new Pair[1];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to(expression, (Object)((Object)sortOrder));
        return (T)this.orderBy(pairArray2);
    }

    public static /* synthetic */ AbstractQuery orderBy$default(AbstractQuery abstractQuery, Expression expression, SortOrder sortOrder, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: orderBy");
        }
        if ((n & 2) != 0) {
            sortOrder = SortOrder.ASC;
        }
        return abstractQuery.orderBy(expression, sortOrder);
    }

    public T orderBy(Pair<? extends Expression<?>, ? extends SortOrder> ... pairArray) {
        AbstractQuery abstractQuery;
        Intrinsics.checkNotNullParameter(pairArray, (String)"");
        AbstractQuery abstractQuery2 = abstractQuery = this;
        List<? extends Pair<? extends Expression<?>, ? extends SortOrder>> list = abstractQuery.orderByExpressions;
        Intrinsics.checkNotNull(list);
        CollectionsKt.addAll((Collection)TypeIntrinsics.asMutableList(list), (Object[])pairArray);
        AbstractQuery abstractQuery3 = abstractQuery;
        Intrinsics.checkNotNull((Object)abstractQuery3);
        return (T)abstractQuery3;
    }

    public final T fetchSize(int n) {
        AbstractQuery abstractQuery;
        AbstractQuery abstractQuery2 = abstractQuery = this;
        abstractQuery.fetchSize = n;
        AbstractQuery abstractQuery3 = abstractQuery;
        Intrinsics.checkNotNull((Object)abstractQuery3);
        return (T)abstractQuery3;
    }

    protected final boolean getCount() {
        return this.count;
    }

    protected final void setCount(boolean bl) {
        this.count = bl;
    }

    protected abstract Statement<ResultSet> getQueryToExecute();

    @Override
    public Iterator<ResultRow> iterator() {
        AbstractQuery abstractQuery = this;
        ResultSet resultSet = abstractQuery.getTransaction().exec(this.getQueryToExecute());
        Intrinsics.checkNotNull((Object)resultSet);
        ResultIterator resultIterator = abstractQuery.new ResultIterator(resultSet);
        if (this.getTransaction().getDb().getSupportsMultipleResultSets()) {
            return resultIterator;
        }
        return CollectionsKt.toList((Iterable)new Iterable<ResultRow>(resultIterator){
            final /* synthetic */ ResultIterator $resultIterator$inlined;
            {
                this.$resultIterator$inlined = resultIterator;
            }

            public final Iterator<ResultRow> iterator() {
                return this.$resultIterator$inlined;
            }
        }).iterator();
    }

    @Override
    public SizedIterable<ResultRow> forUpdate(ForUpdateOption forUpdateOption) {
        return SizedIterable.DefaultImpls.forUpdate(this, forUpdateOption);
    }

    @Override
    public SizedIterable<ResultRow> notForUpdate() {
        return SizedIterable.DefaultImpls.notForUpdate(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/AbstractQuery$Companion;", "", "()V", "trackResultSet", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void trackResultSet(Transaction transaction2) {
            int n = transaction2.getDb().getConfig().getLogTooMuchResultSetsThreshold();
            if (n > 0 && n < transaction2.getOpenResultSetsCount$exposed_core()) {
                String string = "Current opened result sets size " + transaction2.getOpenResultSetsCount$exposed_core() + " exceeds " + n + " threshold for transaction " + transaction2.getId() + ' ';
                string = ExceptionsKt.stackTraceToString((Throwable)new Exception(string));
                SQLLogKt.getExposedLogger().error(string);
            }
            n = transaction2.getOpenResultSetsCount$exposed_core();
            transaction2.setOpenResultSetsCount$exposed_core(n + 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u000bH\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0002H\u0096\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/sql/AbstractQuery$ResultIterator;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "rs", "Ljava/sql/ResultSet;", "(Lorg/jetbrains/exposed/sql/AbstractQuery;Ljava/sql/ResultSet;)V", "fieldsIndex", "", "Lorg/jetbrains/exposed/sql/Expression;", "", "value", "", "hasNext", "setHasNext", "(Z)V", "getRs", "()Ljava/sql/ResultSet;", "next", "exposed-core"})
    private final class ResultIterator
    implements Iterator<ResultRow>,
    KMappedMarker {
        private final ResultSet rs;
        private boolean hasNext;
        private final Map<Expression<?>, Integer> fieldsIndex;

        public ResultIterator(ResultSet iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
            this.rs = iterator2;
            ResultIterator resultIterator = this;
            AbstractQuery.this = CollectionsKt.toSet((Iterable)resultIterator.AbstractQuery.this.getSet().getRealFields());
            ResultIterator resultIterator2 = resultIterator;
            iterator2 = AbstractQuery.this;
            AbstractQuery.this = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)AbstractQuery.this, (int)10));
            int n = 0;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                int n2;
                Object object = iterator2.next();
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (Expression)object;
                Iterable<ResultRow> iterable2 = AbstractQuery.this;
                iterable2.add(TuplesKt.to(object, (Object)n2));
            }
            resultIterator2.fieldsIndex = MapsKt.toMap((Iterable)((List)AbstractQuery.this));
            ResultIterator resultIterator3 = this;
            resultIterator3.setHasNext(resultIterator3.rs.next());
            if (this.hasNext) {
                Companion.trackResultSet(AbstractQuery.this.getTransaction());
            }
        }

        public final ResultSet getRs() {
            return this.rs;
        }

        private final void setHasNext(boolean bl) {
            this.hasNext = bl;
            if (!this.hasNext) {
                java.sql.Statement statement = this.rs.getStatement();
                if (statement != null) {
                    statement.close();
                }
                Transaction transaction2 = AbstractQuery.this.getTransaction();
                int n = transaction2.getOpenResultSetsCount$exposed_core();
                transaction2.setOpenResultSetsCount$exposed_core(n + -1);
            }
        }

        @Override
        public final ResultRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            ResultRow resultRow = ResultRow.Companion.create(this.rs, this.fieldsIndex);
            ResultIterator resultIterator = this;
            resultIterator.setHasNext(resultIterator.rs.next());
            return resultRow;
        }

        @Override
        public final boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

