/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u00042\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016\u00a8\u0006 "}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "booleanFromStringToBoolean", "", "value", "dateTimeType", "hexToDb", "hexString", "jsonBType", "largeTextType", "mediumTextType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "processForDefaultValue", "e", "textType", "timestampWithTimeZoneType", "ubyteType", "uintegerAutoincType", "uintegerType", "ulongAutoincType", "ulongType", "ushortType", "exposed-core"})
public final class MysqlDataTypeProvider
extends DataTypeProvider {
    public static final MysqlDataTypeProvider INSTANCE = new MysqlDataTypeProvider();

    private MysqlDataTypeProvider() {
    }

    @Override
    public final String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    public final String dateTimeType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        boolean bl = mysqlDialect != null ? mysqlDialect.isFractionDateTimeSupported() : false;
        if (bl) {
            return "DATETIME(6)";
        }
        return "DATETIME";
    }

    @Override
    public final String timestampWithTimeZoneType() {
        String string;
        Object object = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = object instanceof MysqlDialect ? (MysqlDialect)object : null;
        boolean bl = mysqlDialect != null ? mysqlDialect.isTimeZoneOffsetSupported() : false;
        if (bl) {
            return "TIMESTAMP(6)";
        }
        Object object2 = new StringBuilder("This vendor does not support timestamp with time zone data type");
        object = DatabaseDialectKt.getCurrentDialect();
        if ((object instanceof MariaDBDialect ? (MariaDBDialect)object : null) != null) {
            object = object2;
            string = "";
            object2 = object;
        } else {
            string = " for this version";
        }
        object = DatabaseDialectKt.getCurrentDialect();
        String string2 = ((StringBuilder)object2).append(string).toString();
        throw new UnsupportedByDialectException(string2, (DatabaseDialect)object);
    }

    @Override
    public final String ubyteType() {
        return "TINYINT UNSIGNED";
    }

    @Override
    public final String ushortType() {
        return "SMALLINT UNSIGNED";
    }

    @Override
    public final String uintegerType() {
        return "INT UNSIGNED";
    }

    @Override
    public final String uintegerAutoincType() {
        return "INT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    public final String ulongType() {
        return "BIGINT UNSIGNED";
    }

    @Override
    public final String ulongAutoincType() {
        return "BIGINT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    public final String textType() {
        return "text";
    }

    @Override
    public final String mediumTextType() {
        return "MEDIUMTEXT";
    }

    @Override
    public final String largeTextType() {
        return "LONGTEXT";
    }

    @Override
    public final boolean booleanFromStringToBoolean(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        String string2 = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"0")) {
            return false;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"1")) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    @Override
    public final String jsonBType() {
        return "JSON";
    }

    @Override
    public final String processForDefaultValue(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        if (expression instanceof LiteralOp && ((ExpressionWithColumnType)((LiteralOp)expression)).getColumnType() instanceof JsonColumnMarker && !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect)) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
            boolean bl = mysqlDialect != null ? mysqlDialect.isMysql8$exposed_core() : false;
            if (bl) {
                return "(" + super.processForDefaultValue(expression) + ')';
            }
            throw new UnsupportedByDialectException("MySQL versions prior to 8.0.13 do not accept default values on JSON columns", DatabaseDialectKt.getCurrentDialect());
        }
        return super.processForDefaultValue(expression);
    }

    @Override
    public final void precessOrderByClause(QueryBuilder objectArray, Expression<?> expressionAlias, SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        Intrinsics.checkNotNullParameter(expressionAlias, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause((QueryBuilder)objectArray, expressionAlias, sortOrder);
                return;
            }
            case 3: {
                super.precessOrderByClause((QueryBuilder)objectArray, expressionAlias, SortOrder.ASC);
                return;
            }
            case 4: {
                super.precessOrderByClause((QueryBuilder)objectArray, expressionAlias, SortOrder.DESC);
                return;
            }
        }
        ExpressionAlias expressionAlias2 = expressionAlias instanceof ExpressionAlias ? (ExpressionAlias)expressionAlias : null;
        if (expressionAlias2 == null || (expressionAlias2 = expressionAlias2.getAlias()) == null) {
            expressionAlias2 = expressionAlias;
        }
        expressionAlias = expressionAlias2;
        sortOrder = sortOrder == SortOrder.ASC_NULLS_LAST ? SortOrder.DESC : SortOrder.ASC;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[4];
        objectArray = objectArray3;
        objectArray3[0] = "-";
        objectArray[1] = expressionAlias;
        objectArray[2] = " ";
        objectArray[3] = sortOrder.getCode();
        ExpressionKt.append((QueryBuilder)objectArray2, objectArray);
    }

    @Override
    public final String hexToDb(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "0x" + string;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

