/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

public final class DelegatingChannelPromiseNotifier
implements ChannelFutureListener,
ChannelPromise {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DelegatingChannelPromiseNotifier.class);
    private final ChannelPromise delegate;
    private final boolean logNotifyFailure;

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise) {
        ChannelPromise channelPromise2 = channelPromise;
        this(channelPromise2, !(channelPromise2 instanceof VoidChannelPromise));
    }

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise, boolean bl) {
        this.delegate = (ChannelPromise)ObjectUtil.checkNotNull((Object)channelPromise, (String)"delegate");
        this.logNotifyFailure = bl;
    }

    public final void operationComplete(ChannelFuture object) {
        InternalLogger internalLogger;
        Object object2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (object.isSuccess()) {
            object = (Void)object.get();
            PromiseNotificationUtil.trySuccess((Promise)this.delegate, (Object)object, (InternalLogger)internalLogger);
            return;
        }
        if (object.isCancelled()) {
            PromiseNotificationUtil.tryCancel((Promise)this.delegate, (InternalLogger)internalLogger);
            return;
        }
        object = object.cause();
        PromiseNotificationUtil.tryFailure((Promise)this.delegate, (Throwable)object, (InternalLogger)internalLogger);
    }

    @Override
    public final Channel channel() {
        return this.delegate.channel();
    }

    @Override
    public final ChannelPromise setSuccess(Void void_) {
        this.delegate.setSuccess(void_);
        return this;
    }

    @Override
    public final ChannelPromise setSuccess() {
        this.delegate.setSuccess();
        return this;
    }

    @Override
    public final boolean trySuccess() {
        return this.delegate.trySuccess();
    }

    public final boolean trySuccess(Void void_) {
        return this.delegate.trySuccess(void_);
    }

    @Override
    public final ChannelPromise setFailure(Throwable throwable) {
        this.delegate.setFailure(throwable);
        return this;
    }

    @Override
    public final ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.addListener(genericFutureListener);
        return this;
    }

    @Override
    public final ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        this.delegate.addListeners(genericFutureListenerArray);
        return this;
    }

    @Override
    public final ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.removeListener(genericFutureListener);
        return this;
    }

    @Override
    public final ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        this.delegate.removeListeners(genericFutureListenerArray);
        return this;
    }

    public final boolean tryFailure(Throwable throwable) {
        return this.delegate.tryFailure(throwable);
    }

    public final boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    @Override
    public final ChannelPromise await() {
        this.delegate.await();
        return this;
    }

    @Override
    public final ChannelPromise awaitUninterruptibly() {
        this.delegate.awaitUninterruptibly();
        return this;
    }

    @Override
    public final boolean isVoid() {
        return this.delegate.isVoid();
    }

    @Override
    public final ChannelPromise unvoid() {
        if (this.isVoid()) {
            return new DelegatingChannelPromiseNotifier(this.delegate.unvoid());
        }
        return this;
    }

    public final boolean await(long l, TimeUnit timeUnit) {
        return this.delegate.await(l, timeUnit);
    }

    public final boolean await(long l) {
        return this.delegate.await(l);
    }

    public final boolean awaitUninterruptibly(long l, TimeUnit timeUnit) {
        return this.delegate.awaitUninterruptibly(l, timeUnit);
    }

    public final boolean awaitUninterruptibly(long l) {
        return this.delegate.awaitUninterruptibly(l);
    }

    public final Void getNow() {
        return (Void)this.delegate.getNow();
    }

    public final boolean cancel(boolean bl) {
        return this.delegate.cancel(bl);
    }

    public final boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public final boolean isDone() {
        return this.delegate.isDone();
    }

    public final Void get() {
        return (Void)this.delegate.get();
    }

    public final Void get(long l, TimeUnit timeUnit) {
        return (Void)this.delegate.get(l, timeUnit);
    }

    @Override
    public final ChannelPromise sync() {
        this.delegate.sync();
        return this;
    }

    @Override
    public final ChannelPromise syncUninterruptibly() {
        this.delegate.syncUninterruptibly();
        return this;
    }

    public final boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public final boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public final Throwable cause() {
        return this.delegate.cause();
    }
}

