/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.ServerChannel;
import io.netty.channel.ServerChannelRecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioDomainSocketUtil;
import io.netty.channel.socket.nio.SelectorProviderUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class NioServerDomainSocketChannel
extends AbstractNioMessageChannel
implements ServerChannel {
    private static final Method OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openServerSocketChannel");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerDomainSocketChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private final NioDomainServerSocketChannelConfig config;
    private volatile boolean bound;

    static ServerSocketChannel newChannel(SelectorProvider object) {
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported with Java 16+");
        }
        try {
            object = (ServerSocketChannel)SelectorProviderUtil.newDomainSocketChannel(OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY, (SelectorProvider)object);
            if (object == null) {
                throw new ChannelException("Failed to open a socket.");
            }
            return object;
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    @Override
    protected final ServerSocketChannel javaChannel() {
        return (ServerSocketChannel)super.javaChannel();
    }

    public NioServerDomainSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioServerDomainSocketChannel(SelectorProvider selectorProvider) {
        this(NioServerDomainSocketChannel.newChannel(selectorProvider));
    }

    public NioServerDomainSocketChannel(ServerSocketChannel serverSocketChannel) {
        super(null, serverSocketChannel, 16);
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported with Java 16+");
        }
        NioServerDomainSocketChannel nioServerDomainSocketChannel = this;
        this.config = nioServerDomainSocketChannel.new NioDomainServerSocketChannelConfig(nioServerDomainSocketChannel);
        try {
            this.bound = serverSocketChannel.getLocalAddress() != null;
            return;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final ChannelConfig config() {
        return this.config;
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final boolean isActive() {
        return this.isOpen() && this.bound;
    }

    @Override
    protected final void doBind(SocketAddress socketAddress) {
        this.javaChannel().bind(socketAddress, this.config.getBacklog());
        this.bound = true;
    }

    @Override
    protected final void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final int doReadMessages(List<Object> list) {
        SocketChannel socketChannel = SocketUtils.accept((ServerSocketChannel)this.javaChannel());
        try {
            if (socketChannel != null) {
                list.add(new NioDomainSocketChannel((Channel)this, socketChannel));
                return 1;
            }
        }
        catch (Throwable throwable) {
            logger.warn("Failed to create a new channel from an accepted socket.", throwable);
            try {
                socketChannel.close();
            }
            catch (Throwable throwable2) {
                logger.warn("Failed to close a socket.", throwable2);
            }
        }
        return 0;
    }

    @Override
    protected final boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void doClose() {
        SocketAddress socketAddress = this.localAddress();
        try {
            super.doClose();
        }
        catch (Throwable throwable) {
            this.javaChannel().close();
            if (socketAddress != null) {
                NioDomainSocketUtil.deleteSocketFile(socketAddress);
            }
            throw throwable;
        }
        this.javaChannel().close();
        if (socketAddress != null) {
            NioDomainSocketUtil.deleteSocketFile(socketAddress);
            return;
        }
    }

    @Override
    protected final SocketAddress localAddress0() {
        try {
            return this.javaChannel().getLocalAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected final SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected final boolean closeOnReadError(Throwable throwable) {
        return super.closeOnReadError(throwable);
    }

    @Override
    protected final boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void doFinishConnect() {
        throw new UnsupportedOperationException();
    }

    private final class NioDomainServerSocketChannelConfig
    extends DefaultChannelConfig {
        private volatile int backlog;

        private NioDomainServerSocketChannelConfig(NioServerDomainSocketChannel nioServerDomainSocketChannel2) {
            super(nioServerDomainSocketChannel2, new ServerChannelRecvByteBufAllocator());
            this.backlog = NetUtil.SOMAXCONN;
        }

        @Override
        protected final void autoReadCleared() {
            NioServerDomainSocketChannel.this.clearReadPending();
        }

        @Override
        public final Map<ChannelOption<?>, Object> getOptions() {
            ArrayList<ChannelOption> arrayList = new ArrayList<ChannelOption>();
            arrayList.add(ChannelOption.SO_BACKLOG);
            for (ChannelOption channelOption : NioChannelOption.getOptions(this.jdkChannel())) {
                arrayList.add(channelOption);
            }
            NioDomainServerSocketChannelConfig nioDomainServerSocketChannelConfig = this;
            return nioDomainServerSocketChannelConfig.getOptions(super.getOptions(), arrayList.toArray(new ChannelOption[0]));
        }

        @Override
        public final <T> T getOption(ChannelOption<T> channelOption) {
            if (channelOption == ChannelOption.SO_BACKLOG) {
                return (T)Integer.valueOf(this.getBacklog());
            }
            if (channelOption instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)channelOption);
            }
            return super.getOption(channelOption);
        }

        @Override
        public final <T> boolean setOption(ChannelOption<T> channelOption, T t) {
            if (channelOption != ChannelOption.SO_BACKLOG) {
                if (channelOption instanceof NioChannelOption) {
                    return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)channelOption, t);
                }
                return super.setOption(channelOption, t);
            }
            this.validate(channelOption, t);
            this.setBacklog((Integer)t);
            return true;
        }

        private int getBacklog() {
            return this.backlog;
        }

        private NioDomainServerSocketChannelConfig setBacklog(int n) {
            ObjectUtil.checkPositiveOrZero((int)n, (String)"backlog");
            this.backlog = n;
            return this;
        }

        private ServerSocketChannel jdkChannel() {
            return ((NioServerDomainSocketChannel)this.channel).javaChannel();
        }
    }
}

