/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.ClassLoadersKt;
import io.ktor.server.engine.EmbeddedServerJvmKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.OverridingClassLoader;
import io.ktor.server.engine.ServerHostUtilsKt;
import io.ktor.server.engine.ShutdownHookKt;
import io.ktor.server.engine.internal.ApplicationUtilsJvmKt;
import io.ktor.server.engine.internal.AutoReloadUtilsKt;
import io.ktor.server.engine.internal.CallableUtilsKt;
import io.ktor.server.engine.internal.EngineUtilsJvmKt;
import io.ktor.server.engine.internal.ReloadingException;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.text.StringsKt;
import kotlinx.b.t;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.G;
import kotlinx.coroutines.W;
import kotlinx.coroutines.g;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0004*\u00020\u00032\u00020\u0005B>\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0019\b\u0002\u0010\r\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\"\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010!\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b$\u0010\u0011J\u001d\u0010'\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0002\u00a2\u0006\u0004\b'\u0010(J#\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J&\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010*\u001a\u00020)H\u0086@\u00a2\u0006\u0004\b-\u0010.J%\u00104\u001a\u00020\u000b2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b4\u00105J!\u00104\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020/2\b\b\u0002\u00107\u001a\u00020/\u00a2\u0006\u0004\b4\u00108J$\u00109\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020/2\b\b\u0002\u00107\u001a\u00020/H\u0086@\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010<\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b<\u0010=J'\u0010A\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020>2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u001d\u0010E\u001a\u00020\u000b2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000b0CH\u0002\u00a2\u0006\u0004\bE\u0010FJ%\u0010H\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020>2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000b0CH\u0002\u00a2\u0006\u0004\bH\u0010IJ\u000f\u0010J\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bJ\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010KR\u0017\u0010M\u001a\u00020L8\u0006\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR\u0017\u0010R\u001a\u00020Q8\u0006\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010UR\u0011\u0010!\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bV\u0010\u0014R\u0017\u0010W\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010ZR\u0014\u0010\\\u001a\u00020[8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u0016\u0010^\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0018\u0010`\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u001c\u0010c\u001a\b\u0012\u0004\u0012\u00020b0\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bc\u0010dR\u001a\u0010e\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010dR\u001a\u0010f\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bf\u0010dR\u001a\u0010g\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bg\u0010dR\u001a\u0010h\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u0010dR\u0018\u0010i\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u0017\u0010k\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\bk\u0010l\u001a\u0004\bm\u0010nR\u001d\u0010t\u001a\u0004\u0018\u00010o8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bp\u0010q\u001a\u0004\br\u0010s\u00a8\u0006u"}, d2={"Lio/ktor/server/engine/EmbeddedServer;", "Lio/ktor/server/engine/ApplicationEngine;", "TEngine", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "TConfiguration", "", "Lio/ktor/server/application/ServerConfig;", "rootConfig", "Lio/ktor/server/engine/ApplicationEngineFactory;", "engineFactory", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "engineConfigBlock", "<init>", "(Lio/ktor/server/application/ServerConfig;Lio/ktor/server/engine/ApplicationEngineFactory;Lkotlin/jvm/functions/Function1;)V", "reload", "()V", "Lio/ktor/server/application/Application;", "currentApplication", "()Lio/ktor/server/application/Application;", "", "Ljava/nio/file/WatchEvent;", "getFileChanges", "()Ljava/util/List;", "Lkotlin/Pair;", "Ljava/lang/ClassLoader;", "createApplication", "()Lkotlin/Pair;", "createClassLoader", "()Ljava/lang/ClassLoader;", "Lio/ktor/events/EventDefinition;", "event", "application", "safeRaiseEvent", "(Lio/ktor/events/EventDefinition;Lio/ktor/server/application/Application;)V", "destroyApplication", "Ljava/net/URL;", "urls", "watchUrls", "(Ljava/util/List;)V", "", "wait", "start", "(Z)Lio/ktor/server/engine/EmbeddedServer;", "startSuspend", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "shutdownGracePeriod", "shutdownTimeout", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "stop", "(JJLjava/util/concurrent/TimeUnit;)V", "gracePeriodMillis", "timeoutMillis", "(JJ)V", "stopSuspend", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "currentClassLoader", "instantiateAndConfigureApplication", "(Ljava/lang/ClassLoader;)Lio/ktor/server/application/Application;", "", "name", "newInstance", "launchModuleByName", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lio/ktor/server/application/Application;)V", "Lkotlin/Function0;", "block", "avoidingDoubleStartup", "(Lkotlin/jvm/functions/Function0;)V", "fqName", "avoidingDoubleStartupFor", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "cleanupWatcher", "Lio/ktor/server/application/ServerConfig;", "Lio/ktor/events/Events;", "monitor", "Lio/ktor/events/Events;", "getMonitor", "()Lio/ktor/events/Events;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "getApplication", "engineConfig", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "getEngineConfig", "()Lio/ktor/server/engine/ApplicationEngine$Configuration;", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "applicationInstanceLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "recreateInstance", "Z", "applicationClassLoader", "Ljava/lang/ClassLoader;", "Ljava/nio/file/WatchKey;", "packageWatchKeys", "Ljava/util/List;", "configuredWatchPath", "watchPatterns", "configModulesNames", "modulesNames", "applicationInstance", "Lio/ktor/server/application/Application;", "engine", "Lio/ktor/server/engine/ApplicationEngine;", "getEngine", "()Lio/ktor/server/engine/ApplicationEngine;", "Ljava/nio/file/WatchService;", "watcher$delegate", "Lkotlin/Lazy;", "getWatcher", "()Ljava/nio/file/WatchService;", "watcher", "ktor-server-core"})
public final class EmbeddedServer<TEngine extends ApplicationEngine, TConfiguration extends ApplicationEngine.Configuration> {
    private final ServerConfig rootConfig;
    private final Events monitor;
    private final ApplicationEnvironment environment;
    private final TConfiguration engineConfig;
    private final ReentrantReadWriteLock applicationInstanceLock;
    private boolean recreateInstance;
    private ClassLoader applicationClassLoader;
    private List<? extends WatchKey> packageWatchKeys;
    private final List<String> configuredWatchPath;
    private final List<String> watchPatterns;
    private final List<String> configModulesNames;
    private final List<String> modulesNames;
    private Application applicationInstance;
    private final TEngine engine;
    private final Lazy watcher$delegate;

    public EmbeddedServer(ServerConfig object, ApplicationEngineFactory<? extends TEngine, TConfiguration> applicationEngineFactory, Function1<? super TConfiguration, Unit> object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(applicationEngineFactory, (String)"");
        Intrinsics.checkNotNullParameter(object2, (String)"");
        this.rootConfig = object;
        this.monitor = this.rootConfig.getEnvironment().getMonitor();
        this.environment = this.rootConfig.getEnvironment();
        this.engineConfig = applicationEngineFactory.configuration((Function1<TConfiguration, Unit>)object2);
        this.applicationInstanceLock = new ReentrantReadWriteLock();
        this.packageWatchKeys = CollectionsKt.emptyList();
        ApplicationConfigValue applicationConfigValue = this.environment.getConfig().propertyOrNull("ktor.deployment.watch");
        List list = applicationConfigValue != null ? applicationConfigValue.getList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.configuredWatchPath = list;
        this.watchPatterns = CollectionsKt.plus((Collection)this.configuredWatchPath, (Iterable)this.rootConfig.getWatchPaths$ktor_server_core());
        object = this;
        object2 = object;
        Object object3 = ((EmbeddedServer)object).environment.getConfig().propertyOrNull("ktor.application.modules");
        if (object3 == null || (object3 = object3.getList()) == null) {
            object3 = CollectionsKt.emptyList();
        }
        object2.configModulesNames = object3;
        this.modulesNames = this.configModulesNames;
        this.applicationInstance = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

            public final Object get() {
                return ((EmbeddedServer)((CallableReference)this).receiver).getEngine();
            }
        }));
        this.engine = applicationEngineFactory.create(this.environment, this.monitor, this.rootConfig.getDevelopmentMode(), this.engineConfig, (Function0<Application>)((Function0)new Function0<Application>((Object)this){

            public final Application invoke() {
                return EmbeddedServer.access$currentApplication((EmbeddedServer)((CallableReference)this).receiver);
            }
        }));
        this.watcher$delegate = LazyKt.lazy(EmbeddedServer::watcher_delegate$lambda$2);
    }

    public /* synthetic */ EmbeddedServer(ServerConfig serverConfig, ApplicationEngineFactory applicationEngineFactory, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function1 = EmbeddedServer::_init_$lambda$0;
        }
        this(serverConfig, applicationEngineFactory, function1);
    }

    public final Events getMonitor() {
        return this.monitor;
    }

    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    public final Application getApplication() {
        return this.currentApplication();
    }

    public final TConfiguration getEngineConfig() {
        return this.engineConfig;
    }

    public final TEngine getEngine() {
        return this.engine;
    }

    private final WatchService getWatcher() {
        Lazy lazy = this.watcher$delegate;
        return (WatchService)lazy.getValue();
    }

    public final void reload() {
        Object object = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = object.readLock();
        int n2 = object.getWriteHoldCount() == 0 ? object.getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = object.writeLock();
        writeLock.lock();
        try {
            this.destroyApplication();
            object = this.createApplication();
            Application application = (Application)((Object)object.component1());
            object = (ClassLoader)object.component2();
            this.applicationInstance = application;
            this.applicationClassLoader = object;
            return;
        }
        finally {
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final Application currentApplication() {
        ReentrantReadWriteLock.ReadLock readLock = this.applicationInstanceLock.readLock();
        readLock.lock();
        try {
            Application application;
            Application application2 = this.applicationInstance;
            if (application2 == null) {
                throw new IllegalStateException("EmbeddedServer was stopped".toString());
            }
            Object object = application2;
            if (!this.rootConfig.getDevelopmentMode()) {
                application = object;
            } else {
                Object object2 = this.getFileChanges();
                if (object2 == null || object2.isEmpty()) {
                    application = object;
                } else {
                    object2 = this.applicationInstanceLock;
                    object = object2.readLock();
                    int n2 = object2.getWriteHoldCount() == 0 ? object2.getReadHoldCount() : 0;
                    for (int i = 0; i < n2; ++i) {
                        ((ReentrantReadWriteLock.ReadLock)object).unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = object2.writeLock();
                    writeLock.lock();
                    try {
                        this.destroyApplication();
                        object2 = this.createApplication();
                        Application application3 = (Application)((Object)object2.component1());
                        object2 = (ClassLoader)object2.component2();
                        this.applicationInstance = application3;
                        this.applicationClassLoader = object2;
                    }
                    finally {
                        for (int i = 0; i < n2; ++i) {
                            ((ReentrantReadWriteLock.ReadLock)object).lock();
                        }
                        writeLock.unlock();
                    }
                    application = this.applicationInstance;
                    if (application == null) {
                        throw new IllegalStateException("EmbeddedServer was stopped".toString());
                    }
                }
            }
            object = application;
            return object;
        }
        finally {
            readLock.unlock();
        }
    }

    private final List<WatchEvent<?>> getFileChanges() {
        try {
            Object object;
            Iterable iterable = this.packageWatchKeys;
            Object object2 = iterable;
            iterable = new ArrayList();
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = object3.next();
                object2 = (WatchKey)object;
                List<WatchEvent<?>> list = object2.pollEvents();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                object2 = list;
                CollectionsKt.addAll((Collection)iterable, (Iterable)object2);
            }
            object = (List)iterable;
            if (object.isEmpty()) {
                return object;
            }
            this.environment.getLog().info("Changes in application detected.");
            int n2 = object.size();
            while (true) {
                Thread.sleep(200L);
                object2 = this.packageWatchKeys;
                object3 = new ArrayList();
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object object4 = object2.next();
                    object4 = (WatchKey)object4;
                    List<WatchEvent<?>> list = object4.pollEvents();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"");
                    object4 = list;
                    CollectionsKt.addAll((Collection)object3, object4);
                }
                object2 = (List)object3;
                if (object2.isEmpty()) break;
                this.environment.getLog().debug("Waiting for more changes.");
                n2 += object2.size();
            }
            this.environment.getLog().debug("Changes to " + n2 + " files caused application restart.");
            object2 = CollectionsKt.take((Iterable)((Iterable)object), (int)5);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object3 = (WatchEvent)object2;
                this.environment.getLog().debug("...  {}", object3.context());
            }
            return object;
        }
        catch (InterruptedException interruptedException) {
            this.environment.getLog().debug("Watch service was interrupted", (Throwable)interruptedException);
            return null;
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            this.environment.getLog().debug("Watch service was closed", (Throwable)closedWatchServiceException);
            return null;
        }
    }

    private final Pair<Application, ClassLoader> createApplication() {
        ClassLoader classLoader = this.createClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            classLoader = TuplesKt.to((Object)((Object)this.instantiateAndConfigureApplication(classLoader)), (Object)classLoader);
            return classLoader;
        }
        finally {
            thread.setContextClassLoader(classLoader2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ClassLoader createClassLoader() {
        var1_1 = this.environment.getClassLoader();
        if (!this.rootConfig.getDevelopmentMode()) {
            this.environment.getLog().info("Autoreload is disabled because the development mode is off.");
            return var1_1;
        }
        var2_2 = this.watchPatterns;
        if (var2_2.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns specified, automatic reload is not active.");
            return var1_1;
        }
        var3_3 = ClassLoadersKt.allURLs(var1_1);
        var4_4 = new File(System.getProperty("java.home")).getParent();
        var6_6 = var5_5 = (Object[])var3_3;
        var5_5 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var5_5, (int)10));
        var6_6 = var6_6.iterator();
        while (var6_6.hasNext()) {
            var7_7 = var6_6.next();
            var8_8 = (URL)var7_7;
            var9_9 /* !! */  = var5_5;
            var9_9 /* !! */ .add(var8_8.getFile());
        }
        var5_5 = (List)var5_5;
        this.environment.getLog().debug("Java Home: " + var4_4);
        var10_10 /* !! */  = new StringBuilder("Class Loader: ").append(var1_1).append(": ");
        var9_9 /* !! */  = this.environment.getLog();
        var6_6 = var5_5;
        var5_5 = new ArrayList<E>();
        var6_6 = var6_6.iterator();
        while (var6_6.hasNext()) {
            var7_7 = var6_6.next();
            var8_8 = (String)var7_7;
            v0 = var8_8.toString();
            Intrinsics.checkNotNull((Object)var4_4);
            if (!(StringsKt.startsWith$default((String)v0, (String)var4_4, (boolean)false, (int)2, null) == false)) continue;
            var5_5.add(var7_7);
        }
        var5_5 = (List)var5_5;
        var9_9 /* !! */ .debug(var10_10 /* !! */ .append(var5_5).toString());
        v1 = new Class[8];
        var5_5 = v1;
        v1[0] = ApplicationEnvironment.class;
        var5_5[1] = Pipeline.class;
        var5_5[2] = HttpStatusCode.class;
        var5_5[3] = Function1.class;
        var5_5[4] = Logger.class;
        var5_5[5] = ByteReadChannel.class;
        var5_5[6] = t.class;
        var5_5[7] = Attributes.class;
        var5_5 = CollectionsKt.listOf((Object[])var5_5);
        var6_6 = new HashSet<E>();
        var7_7 = var5_5;
        var7_7 = var7_7.iterator();
        while (var7_7.hasNext()) {
            var8_8 = var7_7.next();
            var9_9 /* !! */  = var8_8;
            var5_5 = (Class)var8_8;
            v2 = var5_5.getProtectionDomain().getCodeSource().getLocation();
            if (v2 == null) continue;
            var5_5 = v2;
            var6_6.add(var5_5);
        }
        var5_5 = (HashSet)var6_6;
        var7_7 = var6_6 = (Iterable)var3_3;
        var6_6 = new ArrayList<E>();
        var8_8 = var7_7.iterator();
        while (var8_8.hasNext()) {
            var9_9 /* !! */  = var8_8.next();
            var3_3 = (URL)var9_9 /* !! */ ;
            if (var5_5.contains(var3_3)) ** GOTO lbl-1000
            var7_7 = var2_2;
            if (!(var7_7 instanceof Collection) || !((Collection)var7_7).isEmpty()) {
                var7_7 = var7_7.iterator();
                while (var7_7.hasNext()) {
                    var10_10 /* !! */  = var7_7.next();
                    if (!EmbeddedServerJvmKt.checkUrlMatches((URL)var3_3, (String)(var10_10 /* !! */  = (String)var10_10 /* !! */ ))) continue;
                    v3 = true;
                    break;
                }
            } else {
                v3 = false;
            }
            if (!v3) ** GOTO lbl-1000
            v4 = var3_3.getPath();
            if (v4 == null) {
                v4 = "";
            }
            Intrinsics.checkNotNull((Object)var4_4);
            if (!StringsKt.startsWith$default((String)v4, (String)var4_4, (boolean)false, (int)2, null)) {
                v5 = true;
            } else lbl-1000:
            // 3 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            var6_6.add(var9_9 /* !! */ );
        }
        var5_5 = (List)var6_6;
        if (var5_5.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns match classpath entries, automatic reload is not active");
            return var1_1;
        }
        this.watchUrls((List<URL>)var5_5);
        return new OverridingClassLoader((List<URL>)var5_5, var1_1);
    }

    private final void safeRaiseEvent(EventDefinition<Application> eventDefinition, Application application) {
        EventsKt.raiseCatching$default((Events)this.monitor, eventDefinition, (Object)((Object)application), null, (int)4, null);
    }

    private final void destroyApplication() {
        Object object = this.applicationInstance;
        Object object2 = this.applicationClassLoader;
        this.applicationInstance = null;
        this.applicationClassLoader = null;
        if (object != null) {
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopping(), (Application)((Object)object));
            try {
                ((Application)((Object)object)).dispose();
                OverridingClassLoader overridingClassLoader = object2 instanceof OverridingClassLoader ? (OverridingClassLoader)object2 : null;
                if (overridingClassLoader != null) {
                    overridingClassLoader.close();
                }
            }
            catch (Throwable throwable) {
                this.environment.getLog().error("Failed to destroy application instance.", throwable);
            }
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopped(), (Application)((Object)object));
        }
        object = this.packageWatchKeys;
        object = object.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            object2 = (WatchKey)object2;
            object2.cancel();
        }
        this.packageWatchKeys = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    private final void watchUrls(List<URL> modifierArray) {
        WatchEvent.Modifier[] modifierArray2;
        Object object;
        WatchEvent.Kind[] kindArray = new HashSet();
        modifierArray = modifierArray.iterator();
        while (modifierArray.hasNext()) {
            void var3_10;
            void var3_11;
            String string;
            URL throwable = (URL)modifierArray.next();
            if (throwable.getPath() == null) continue;
            String string2 = URLDecoder.decode(string, "utf-8");
            EmbeddedServer embeddedServer = this;
            try {
                Object object2 = Result.constructor-impl((Object)new File(string2).toPath());
            }
            catch (Throwable throwable2) {
                Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            if ((Path)(Result.isFailure-impl((Object)(var3_11 = var3_10)) ? null : var3_11) == null || !Files.exists((Path)object, new LinkOption[0])) continue;
            SimpleFileVisitor<Path> simpleFileVisitor = new SimpleFileVisitor<Path>(kindArray){
                final /* synthetic */ HashSet<Path> $paths;
                {
                    this.$paths = hashSet;
                }

                public final FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"");
                    Intrinsics.checkNotNullParameter((Object)basicFileAttributes, (String)"");
                    this.$paths.add(path);
                    return FileVisitResult.CONTINUE;
                }

                public final FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"");
                    Intrinsics.checkNotNullParameter((Object)basicFileAttributes, (String)"");
                    path = path.getParent();
                    if (path != null) {
                        this.$paths.add(path);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            if (!Files.isDirectory((Path)object, new LinkOption[0])) continue;
            Files.walkFileTree((Path)object, (FileVisitor<? super Path>)simpleFileVisitor);
        }
        modifierArray = (Iterable)kindArray;
        Iterator iterator = modifierArray.iterator();
        while (iterator.hasNext()) {
            Object t2 = iterator.next();
            object = (Path)t2;
            this.environment.getLog().debug("Watching " + object + " for changes.");
        }
        WatchEvent.Modifier modifier2 = AutoReloadUtilsKt.get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH();
        if (modifier2 != null) {
            object = modifier2;
            WatchEvent.Modifier[] modifierArray3 = new WatchEvent.Modifier[1];
            WatchEvent.Modifier[] modifierArray4 = modifierArray3;
            modifierArray3[0] = object;
            modifierArray2 = modifierArray4;
        } else {
            modifierArray2 = new WatchEvent.Modifier[]{};
        }
        modifierArray = modifierArray2;
        Iterable iterable = (Iterable)kindArray;
        EmbeddedServer embeddedServer = this;
        Iterable iterable2 = iterable;
        object = new ArrayList();
        Iterable iterable3 = iterable2;
        for (Object t3 : iterable3) {
            WatchKey watchKey;
            kindArray = t3;
            kindArray = t3;
            kindArray = (Path)t3;
            if (this.getWatcher() != null) {
                WatchService watchService;
                Iterable<Object> iterable4 = kindArray;
                WatchEvent.Kind[] kindArray2 = new WatchEvent.Kind[3];
                kindArray = kindArray2;
                kindArray2[0] = StandardWatchEventKinds.ENTRY_CREATE;
                kindArray[1] = StandardWatchEventKinds.ENTRY_DELETE;
                kindArray[2] = StandardWatchEventKinds.ENTRY_MODIFY;
                Object object4 = modifierArray;
                watchKey = iterable4.register(watchService, kindArray, (WatchEvent.Modifier[])Arrays.copyOf(object4, ((Object)object4).length));
            } else {
                watchKey = null;
            }
            if (watchKey == null) continue;
            kindArray = watchKey;
            object.add(kindArray);
        }
        embeddedServer.packageWatchKeys = (List)object;
    }

    public final EmbeddedServer<TEngine, TConfiguration> start(boolean bl) {
        EmbeddedServer embeddedServer = this;
        ShutdownHookKt.addShutdownHook(embeddedServer, (Function0<Unit>)((Function0)() -> EmbeddedServer.start$lambda$20(embeddedServer)));
        Object object = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = object.readLock();
        int n2 = object.getWriteHoldCount() == 0 ? object.getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = object.writeLock();
        writeLock.lock();
        try {
            try {
                object = this.createApplication();
            }
            catch (Throwable throwable) {
                this.destroyApplication();
                if (!((Collection)this.watchPatterns).isEmpty()) {
                    this.cleanupWatcher();
                }
                throw throwable;
            }
            Object object2 = object;
            object = (Application)((Object)object2.component1());
            object2 = (ClassLoader)object2.component2();
            this.applicationInstance = object;
            this.applicationClassLoader = object2;
        }
        finally {
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        g.a((CoroutineScope)G.a((CoroutineContext)this.getApplication().getCoroutineContext()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            {
                this.this$0 = embeddedServer;
                super(2, continuation);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getEngine().resolvedConnectors((Continuation<List<EngineConnectorConfig>>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = var1_1;
lbl13:
                        // 2 sources

                        var1_1 = (Iterable)v0;
                        var2_2 = this.this$0;
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var3_3 = var1_1.next();
                            var3_3 = (EngineConnectorConfig)var3_3;
                            var4_4 = EngineUtilsJvmKt.escapeHostname(var3_3.getHost());
                            v1 = var2_2.getEnvironment().getLog();
                            v2 = new StringBuilder("Responding at ");
                            v3 = var3_3.getType().getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"");
                            v1.info(v2.append(v3).append("://").append(var4_4).append(':').append(var3_3.getPort()).toString());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.engine.start(bl);
        return this;
    }

    public static /* synthetic */ EmbeddedServer start$default(EmbeddedServer embeddedServer, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return embeddedServer.start(bl);
    }

    public final Object startSuspend(boolean bl, Continuation<? super EmbeddedServer<TEngine, TConfiguration>> continuation) {
        return g.a((CoroutineContext)((CoroutineContext)ApplicationUtilsJvmKt.getIOBridge(W.a)), (Function2)new Function2<CoroutineScope, Continuation<? super EmbeddedServer<TEngine, TConfiguration>>, Object>(this, bl, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ boolean $wait;
            {
                this.this$0 = embeddedServer;
                this.$wait = bl;
                super(2, continuation);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return this.this$0.start(this.$wait);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super EmbeddedServer<TEngine, TConfiguration>> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }, continuation);
    }

    public static /* synthetic */ Object startSuspend$default(EmbeddedServer embeddedServer, boolean bl, Continuation continuation, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return embeddedServer.startSuspend(bl, continuation);
    }

    public final void stop(long l2, long l3, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        try {
            this.engine.stop(timeUnit.toMillis(l2), timeUnit.toMillis(l3));
        }
        catch (Exception exception) {
            this.environment.getLog().warn("Exception occurred during engine shutdown", (Throwable)exception);
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.destroyApplication();
        }
        finally {
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (!((Collection)this.watchPatterns).isEmpty()) {
            this.cleanupWatcher();
        }
    }

    public final void stop(long l2, long l3) {
        this.stop(l2, l3, TimeUnit.MILLISECONDS);
    }

    public static /* synthetic */ void stop$default(EmbeddedServer embeddedServer, long l2, long l3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n2 & 2) != 0) {
            l3 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        embeddedServer.stop(l2, l3);
    }

    public final Object stopSuspend(long l2, long l3, Continuation<? super Unit> continuation) {
        Object object = g.a((CoroutineContext)((CoroutineContext)ApplicationUtilsJvmKt.getIOBridge(W.a)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, l2, l3, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ long $gracePeriodMillis;
            final /* synthetic */ long $timeoutMillis;
            {
                this.this$0 = embeddedServer;
                this.$gracePeriodMillis = l2;
                this.$timeoutMillis = l3;
                super(2, continuation);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.stop(this.$gracePeriodMillis, this.$timeoutMillis);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object stopSuspend$default(EmbeddedServer embeddedServer, long l2, long l3, Continuation continuation, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n2 & 2) != 0) {
            l3 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        return embeddedServer.stopSuspend(l2, l3, (Continuation<Unit>)continuation);
    }

    private final Application instantiateAndConfigureApplication(ClassLoader classLoader) {
        Application application;
        if (this.recreateInstance || this.applicationInstance == null) {
            application = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

                public final Object get() {
                    return ((EmbeddedServer)((CallableReference)this).receiver).getEngine();
                }
            }));
        } else {
            this.recreateInstance = true;
            Application application2 = this.applicationInstance;
            application = application2;
            Intrinsics.checkNotNull((Object)((Object)application2));
        }
        Application application3 = application;
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarting(), application3);
        EmbeddedServer embeddedServer = this;
        embeddedServer.avoidingDoubleStartup((Function0<Unit>)((Function0)() -> EmbeddedServer.instantiateAndConfigureApplication$lambda$25(embeddedServer, classLoader, application3)));
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarted(), application3);
        return application3;
    }

    private final void launchModuleByName(String string, ClassLoader classLoader, Application application) {
        this.avoidingDoubleStartupFor(string, (Function0<Unit>)((Function0)() -> EmbeddedServer.launchModuleByName$lambda$26(classLoader, string, application)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void avoidingDoubleStartup(Function0<Unit> object) {
        List<String> list;
        try {
            object.invoke();
            list = AutoReloadUtilsKt.getCurrentStartupModules().get();
        }
        catch (Throwable throwable) {
            List<String> list2 = AutoReloadUtilsKt.getCurrentStartupModules().get();
            if (list2 == null) throw throwable;
            List<String> list3 = list2;
            if (!list2.isEmpty()) throw throwable;
            AutoReloadUtilsKt.getCurrentStartupModules().remove();
            throw throwable;
        }
        if (list == null) return;
        object = list;
        if (!list.isEmpty()) return;
        AutoReloadUtilsKt.getCurrentStartupModules().remove();
    }

    private final void avoidingDoubleStartupFor(String string, Function0<Unit> function0) {
        Object object;
        ThreadLocal<List<String>> threadLocal = AutoReloadUtilsKt.getCurrentStartupModules();
        Object object2 = threadLocal.get();
        if (object2 == null) {
            object = new ArrayList(1);
            List list = object;
            threadLocal.set(list);
            object2 = object = object;
        }
        if (!(!object2.contains(string))) {
            object = "Module startup is already in progress for function " + string + " (recursive module startup from module main?)";
            throw new IllegalStateException(object.toString());
        }
        object.add(string);
        try {
            function0.invoke();
            return;
        }
        finally {
            object.remove(string);
        }
    }

    private final void cleanupWatcher() {
        EmbeddedServer embeddedServer = this;
        try {
            Unit unit;
            WatchService watchService = embeddedServer.getWatcher();
            if (watchService != null) {
                watchService.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Result.constructor-impl((Object)unit);
            return;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
    }

    private static final Unit _init_$lambda$0(ApplicationEngine.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"");
        return Unit.INSTANCE;
    }

    private static final WatchService watcher_delegate$lambda$2() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            watchService = null;
        }
        return watchService;
    }

    private static final Unit start$lambda$20(EmbeddedServer embeddedServer) {
        EmbeddedServer.stop$default(embeddedServer, 0L, 0L, 3, null);
        return Unit.INSTANCE;
    }

    private static final Unit instantiateAndConfigureApplication$lambda$25(EmbeddedServer embeddedServer, ClassLoader classLoader, Application application) {
        Object object;
        Iterator iterator = embeddedServer.modulesNames;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            object = (String)object;
            embeddedServer.launchModuleByName((String)object, classLoader, application);
        }
        iterator = embeddedServer.rootConfig.getModules$ktor_server_core();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            object = (Function1)object;
            String string = ServerHostUtilsKt.methodName((Function)object);
            try {
                embeddedServer.launchModuleByName(string, classLoader, application);
            }
            catch (ReloadingException reloadingException) {
                object.invoke((Object)application);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit launchModuleByName$lambda$26(ClassLoader classLoader, String string, Application application) {
        CallableUtilsKt.executeModuleFunction(classLoader, string, application);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Application access$currentApplication(EmbeddedServer embeddedServer) {
        return embeddedServer.currentApplication();
    }
}

