/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;

public class IncludeModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    private String attributeInUse;
    private boolean optional;

    public IncludeModelHandler(Context context) {
        super(context);
    }

    public static IncludeModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new IncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext object, Model model) {
        model = (IncludeModel)model;
        this.optional = OptionHelper.toBoolean(((IncludeModel)model).getOptional(), false);
        if (!this.checkAttributes((IncludeModel)model)) {
            this.inError = true;
            return;
        }
        Object object2 = this.getInputStream((ModelInterpretationContext)object, (IncludeModel)model);
        if (object2 == null) {
            this.inError = true;
            return;
        }
        try {
            object2 = this.populateSaxEventRecorder((InputStream)object2);
            List<SaxEvent> list = ((SaxEventRecorder)object2).getSaxEventList();
            if (list.isEmpty()) {
                this.addWarn("Empty sax event list");
                return;
            }
            if ((object = ((ModelInterpretationContext)object).getConfiguratorSupplier()) == null) {
                IncludeModelHandler includeModelHandler = this;
                includeModelHandler.addError("null configurator supplier. Abandoning inclusion of [" + includeModelHandler.attributeInUse + "]");
                this.inError = true;
                return;
            }
            object = (GenericXMLConfigurator)object.get();
            ((GenericXMLConfigurator)object).getRuleStore().addPathPathMapping("included", "configuration");
            object = ((GenericXMLConfigurator)object).buildModelFromSaxEventList(((SaxEventRecorder)object2).getSaxEventList());
            if (object == null) {
                this.addError("Could not find valid configuration instructions. Exiting.");
                return;
            }
            model.getSubModels().addAll(((Model)object).getSubModels());
            return;
        }
        catch (JoranException joranException) {
            this.inError = true;
            IncludeModelHandler includeModelHandler = this;
            includeModelHandler.addError("Error processing XML data in [" + includeModelHandler.attributeInUse + "]", joranException);
            return;
        }
    }

    public SaxEventRecorder populateSaxEventRecorder(InputStream inputStream) {
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        saxEventRecorder.recordEvents(inputStream);
        return saxEventRecorder;
    }

    private void trimHeadAndTail(List<SaxEvent> list) {
        if (list.size() == 0) {
            return;
        }
        SaxEvent saxEvent = list.get(0);
        if (saxEvent != null && saxEvent.qName.equalsIgnoreCase("included")) {
            list.remove(0);
        }
        List<SaxEvent> list2 = list;
        saxEvent = list2.get(list2.size() - 1);
        if (saxEvent != null && saxEvent.qName.equalsIgnoreCase("included")) {
            List<SaxEvent> list3 = list;
            list3.remove(list3.size() - 1);
        }
    }

    InputStream getInputStream(ModelInterpretationContext object, IncludeModel includeModel) {
        if ((object = this.getInputURL((ModelInterpretationContext)object, includeModel)) == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, (URL)object);
        return this.openURL((URL)object);
    }

    InputStream openURL(URL uRL) {
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            this.optionalWarning("Failed to open [" + uRL.toString() + "]");
            return null;
        }
    }

    private boolean checkAttributes(IncludeModel object) {
        String string = ((IncludeModel)object).getFile();
        String string2 = ((IncludeModel)object).getUrl();
        object = ((IncludeModel)object).getResource();
        int n = 0;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            ++n;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string2)) {
            ++n;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)object)) {
            ++n;
        }
        if (n == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (n > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (n == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + n + "] is not expected");
    }

    URL getInputURL(ModelInterpretationContext modelInterpretationContext, IncludeModel object) {
        String string = ((IncludeModel)object).getFile();
        String string2 = ((IncludeModel)object).getUrl();
        object = ((IncludeModel)object).getResource();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            this.attributeInUse = modelInterpretationContext.subst(string);
            IncludeModelHandler includeModelHandler = this;
            return includeModelHandler.filePathAsURL(includeModelHandler.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string2)) {
            this.attributeInUse = modelInterpretationContext.subst(string2);
            IncludeModelHandler includeModelHandler = this;
            return includeModelHandler.attributeToURL(includeModelHandler.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)object)) {
            this.attributeInUse = modelInterpretationContext.subst((String)object);
            IncludeModelHandler includeModelHandler = this;
            return includeModelHandler.resourceAsURL(includeModelHandler.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned at this stage");
    }

    URL filePathAsURL(String object) {
        object = new File((String)object).toURI();
        try {
            return ((URI)object).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            object = malformedURLException;
            malformedURLException.printStackTrace();
            return null;
        }
    }

    URL attributeToURL(String object) {
        try {
            return new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            object = "URL [" + (String)object + "] is not well formed.";
            this.addError((String)object, malformedURLException);
            return null;
        }
    }

    URL resourceAsURL(String string) {
        URL uRL = Loader.getResourceBySelfClassLoader(string);
        if (uRL == null) {
            this.optionalWarning("Could not find resource corresponding to [" + string + "]");
            return null;
        }
        return uRL;
    }

    private void optionalWarning(String string) {
        if (!this.optional) {
            this.addWarn(string);
        }
    }
}

