/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeCellEditor;

public class FlatUIUtils {
    private static boolean useSharedUIs = true;
    private static final WeakHashMap<LookAndFeel, IdentityHashMap<Object, ComponentUI>> sharedUIinstances = new WeakHashMap();
    private static UIDefaults lightAWTPeerDefaults;
    public static final double MOVE_TO = -1.000000000001E12;
    public static final double QUAD_TO = -1.000000000002E12;
    public static final double CURVE_TO = -1.000000000003E12;
    public static final double ROUNDED = -1.000000000004E12;
    public static final double CLOSE_PATH = -1.000000000005E12;

    public static Rectangle addInsets(Rectangle rectangle, Insets insets) {
        return new Rectangle(rectangle.x - insets.left, rectangle.y - insets.top, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
    }

    public static Rectangle subtractInsets(Rectangle rectangle, Insets insets) {
        return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
    }

    public static Dimension addInsets(Dimension dimension, Insets insets) {
        return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    public static Insets addInsets(Insets insets, Insets insets2) {
        if (insets == null) {
            return insets2;
        }
        if (insets2 == null) {
            return insets;
        }
        return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
    }

    public static void setInsets(Insets insets, Insets insets2) {
        insets.top = insets2.top;
        insets.left = insets2.left;
        insets.bottom = insets2.bottom;
        insets.right = insets2.right;
    }

    public static Color getUIColor(String object, int n) {
        if ((object = UIManager.getColor(object)) != null) {
            return object;
        }
        return new Color(n);
    }

    public static Color getUIColor(String object, Color color) {
        if ((object = UIManager.getColor(object)) != null) {
            return object;
        }
        return color;
    }

    public static Color getUIColor(String object, String string) {
        if ((object = UIManager.getColor(object)) != null) {
            return object;
        }
        return UIManager.getColor(string);
    }

    public static boolean getUIBoolean(String object, boolean bl) {
        if ((object = UIManager.get(object)) instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public static int getUIInt(String object, int n) {
        if ((object = UIManager.get(object)) instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    public static float getUIFloat(String object, float f) {
        if ((object = UIManager.get(object)) instanceof Number) {
            return ((Number)object).floatValue();
        }
        return f;
    }

    public static <T extends Enum<T>> T getUIEnum(String object, Class<T> clazz, T t) {
        if ((object = UIManager.get(object)) instanceof String) {
            try {
                return Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return t;
    }

    public static Color getSubUIColor(String string, String object) {
        if (object != null && (object = UIManager.getColor(FlatUIUtils.buildSubKey(string, (String)object))) != null) {
            return object;
        }
        return UIManager.getColor(string);
    }

    public static boolean getSubUIBoolean(String string, String object, boolean bl) {
        if (object != null && (object = UIManager.get(FlatUIUtils.buildSubKey(string, (String)object))) instanceof Boolean) {
            return (Boolean)object;
        }
        return FlatUIUtils.getUIBoolean(string, bl);
    }

    public static int getSubUIInt(String string, String object, int n) {
        if (object != null && (object = UIManager.get(FlatUIUtils.buildSubKey(string, (String)object))) instanceof Integer) {
            return (Integer)object;
        }
        return FlatUIUtils.getUIInt(string, n);
    }

    public static Insets getSubUIInsets(String string, String object) {
        if (object != null && (object = UIManager.getInsets(FlatUIUtils.buildSubKey(string, (String)object))) != null) {
            return object;
        }
        return UIManager.getInsets(string);
    }

    public static Dimension getSubUIDimension(String string, String object) {
        if (object != null && (object = UIManager.getDimension(FlatUIUtils.buildSubKey(string, (String)object))) != null) {
            return object;
        }
        return UIManager.getDimension(string);
    }

    public static Icon getSubUIIcon(String string, String object) {
        if (object != null && (object = UIManager.getIcon(FlatUIUtils.buildSubKey(string, (String)object))) != null) {
            return object;
        }
        return UIManager.getIcon(string);
    }

    public static Font getSubUIFont(String string, String object) {
        if (object != null && (object = UIManager.getFont(FlatUIUtils.buildSubKey(string, (String)object))) != null) {
            return object;
        }
        return UIManager.getFont(string);
    }

    private static String buildSubKey(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n) + '.' + string2 + '.' + string.substring(n + 1);
        }
        return string;
    }

    public static boolean getBoolean(JComponent jComponent, String object, String string, String string2, boolean bl) {
        if ((object = FlatSystemProperties.getBooleanStrict((String)object, null)) != null) {
            return (Boolean)object;
        }
        object = FlatClientProperties.clientPropertyBooleanStrict(jComponent, string, null);
        if (object != null) {
            return (Boolean)object;
        }
        return FlatUIUtils.getUIBoolean(string2, bl);
    }

    public static boolean isChevron(String string) {
        return !"triangle".equals(string);
    }

    public static Color nonUIResource(Color color) {
        if (color instanceof UIResource) {
            return new Color(color.getRGB(), true);
        }
        return color;
    }

    public static Font nonUIResource(Font font) {
        if (font instanceof UIResource) {
            Font font2 = font;
            return font2.deriveFont(font2.getStyle());
        }
        return font;
    }

    public static Border nonUIResource(Border border) {
        if (border instanceof UIResource) {
            return new NonUIResourceBorder(border);
        }
        return border;
    }

    static Border unwrapNonUIResourceBorder(Border border) {
        if (border instanceof NonUIResourceBorder) {
            return ((NonUIResourceBorder)border).delegate;
        }
        return border;
    }

    public static int minimumWidth(JComponent jComponent, int n) {
        return FlatClientProperties.clientPropertyInt(jComponent, "JComponent.minimumWidth", n);
    }

    public static int minimumHeight(JComponent jComponent, int n) {
        return FlatClientProperties.clientPropertyInt(jComponent, "JComponent.minimumHeight", n);
    }

    public static boolean isCellEditor(Component component) {
        if (component == null) {
            return false;
        }
        Object object = component.getParent();
        if (object instanceof JTable && ((JTable)object).getEditorComponent() == component) {
            return true;
        }
        if (object instanceof DefaultTreeCellEditor.EditorContainer) {
            return true;
        }
        object = component.getName();
        if ("Table.editor".equals(object) || "Tree.cellEditor".equals(object)) {
            return true;
        }
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("JComboBox.isTableCellEditor"));
    }

    public static boolean isPermanentFocusOwner(Component component) {
        Object object;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("JComponent.focusOwner")) instanceof Predicate) {
            return ((Predicate)object).test((JComponent)component) && FlatUIUtils.isInActiveWindow(component, keyboardFocusManager.getActiveWindow());
        }
        if (component.hasFocus()) {
            return true;
        }
        return keyboardFocusManager.getPermanentFocusOwner() == component && FlatUIUtils.isInActiveWindow(component, keyboardFocusManager.getActiveWindow());
    }

    static boolean isInActiveWindow(Component component, Window window) {
        return (component = SwingUtilities.windowForComponent(component)) == window || component != null && ((Window)component).getType() == Window.Type.POPUP && ((Window)component).getOwner() == window;
    }

    static boolean isAWTPeer(Component component) {
        if (SystemInfo.isMacOS) {
            return component.getClass().getName().startsWith("sun.lwawt.LW");
        }
        return false;
    }

    static boolean needsLightAWTPeer(JComponent jComponent) {
        return FlatUIUtils.isAWTPeer(jComponent) && FlatLaf.isLafDark();
    }

    static void runWithLightAWTPeerUIDefaults(Runnable runnable) {
        if (lightAWTPeerDefaults == null) {
            FlatLightLaf flatLightLaf = UIManager.getInt("Component.focusWidth") >= 2 ? new FlatIntelliJLaf() : new FlatLightLaf();
            lightAWTPeerDefaults = flatLightLaf.getDefaults();
        }
        FlatLaf.runWithUIDefaultsGetter(object -> {
            if ((object = lightAWTPeerDefaults.get(object)) != null) {
                return object;
            }
            return FlatLaf.NULL_VALUE;
        }, runnable);
    }

    public static boolean isFullScreen(Component component) {
        Object object = component.getGraphicsConfiguration();
        object = object != null ? ((GraphicsConfiguration)object).getDevice() : null;
        return (object = object != null ? ((GraphicsDevice)object).getFullScreenWindow() : null) != null && object == SwingUtilities.windowForComponent(component);
    }

    public static Boolean isRoundRect(Component component) {
        if (component instanceof JComponent) {
            return FlatClientProperties.clientPropertyBooleanStrict((JComponent)component, "JComponent.roundRect", null);
        }
        return null;
    }

    public static float getBorderFocusWidth(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        if (flatBorder != null) {
            return UIScale.scale((float)flatBorder.getFocusWidth(jComponent));
        }
        return 0.0f;
    }

    public static float getBorderLineWidth(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        if (flatBorder != null) {
            return UIScale.scale((float)flatBorder.getLineWidth(jComponent));
        }
        return 0.0f;
    }

    public static int getBorderFocusAndLineWidth(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        if (flatBorder != null) {
            return Math.round(UIScale.scale((float)flatBorder.getFocusWidth(jComponent)) + UIScale.scale((float)flatBorder.getLineWidth(jComponent)));
        }
        return 0;
    }

    public static float getBorderArc(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        if (flatBorder != null) {
            return UIScale.scale((float)flatBorder.getArc(jComponent));
        }
        return 0.0f;
    }

    public static boolean hasRoundBorder(JComponent jComponent) {
        return FlatUIUtils.getBorderArc(jComponent) >= (float)jComponent.getHeight();
    }

    public static FlatBorder getOutsideFlatBorder(JComponent object) {
        object = ((JComponent)object).getBorder();
        while (true) {
            if (object instanceof FlatBorder) {
                return (FlatBorder)object;
            }
            if (!(object instanceof CompoundBorder)) break;
            object = ((CompoundBorder)object).getOutsideBorder();
        }
        return null;
    }

    public static Object[] setRenderingHints(Graphics graphics) {
        graphics = (Graphics2D)graphics;
        Object[] objectArray = new Object[]{((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING), ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return objectArray;
    }

    public static void resetRenderingHints(Graphics graphics, Object[] objectArray) {
        graphics = (Graphics2D)graphics;
        if (objectArray[0] != null) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, objectArray[0]);
        }
        if (objectArray[1] != null) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, objectArray[1]);
        }
    }

    public static void runWithoutRenderingHints(Graphics graphics, Object[] objectArray, Runnable runnable) {
        if (objectArray == null) {
            runnable.run();
            return;
        }
        graphics = (Graphics2D)graphics;
        Object[] objectArray2 = new Object[]{((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING), ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
        runnable.run();
        FlatUIUtils.resetRenderingHints(graphics, objectArray2);
    }

    public static Color deriveColor(Color color, Color color2) {
        if (color instanceof DerivedColor) {
            return ((DerivedColor)color).derive(color2);
        }
        return color;
    }

    public static void paintComponentBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f, float f2) {
        FlatUIUtils.paintOutlinedComponent(graphics2D, n, n2, n3, n4, f, 0.0f, 0.0f, 0.0f, f2, null, null, graphics2D.getPaint());
    }

    public static void paintOutlinedComponent(Graphics2D graphics2D2, int n5, int n6, int n7, int n8, float f, float f2, float f3, float f4, float f5, Paint paint, Paint paint2, Paint paint3) {
        double d2 = UIScale.getSystemScaleFactor(graphics2D2);
        if (d2 != 1.0 && d2 != 2.0) {
            HiDPIUtils.paintAtScale1x(graphics2D2, n5, n6, n7, n8, (graphics2D, n, n2, n3, n4, d) -> FlatUIUtils.paintOutlinedComponentImpl(graphics2D, n, n2, n3, n4, (float)((double)f * d), f2, (float)((double)f3 * d), (float)((double)f4 * d), (float)((double)f5 * d), paint, paint2, paint3));
            return;
        }
        FlatUIUtils.paintOutlinedComponentImpl(graphics2D2, n5, n6, n7, n8, f, f2, f3, f4, f5, paint, paint2, paint3);
    }

    private static void paintOutlinedComponentImpl(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, Paint paint, Paint paint2, Paint paint3) {
        float f6 = (float)n + f;
        float f7 = (float)n2 + f;
        float f8 = (float)n3 - f * 2.0f;
        float f9 = (float)n4 - f * 2.0f;
        if (paint3 != null) {
            graphics2D.setPaint(paint3);
            graphics2D.fill(FlatUIUtils.createComponentRectangle(f6, f7, f8, f9, f5));
        }
        if (paint2 != null && paint2.equals(paint)) {
            paint2 = null;
            f3 = Math.max(f3, f4);
        }
        float f10 = f * f2 + f3;
        if (paint != null && f10 != 0.0f) {
            float f11 = f;
            float f12 = f11 - f11 * f2;
            float f13 = (float)n + f12;
            float f14 = (float)n2 + f12;
            float f15 = (float)n3 - f12 * 2.0f;
            float f16 = (float)n4 - f12 * 2.0f;
            f12 = f5 + f * 2.0f;
            f3 = f5 - f3 * 2.0f;
            if (f > 0.0f && f5 > 0.0f && f5 < (float)UIScale.scale(10)) {
                f12 -= UIScale.scale(2.0f);
            }
            if (f2 != 1.0f) {
                f12 = f5 + (f12 - f5) * f2;
            }
            graphics2D.setPaint(paint);
            FlatUIUtils.paintOutline(graphics2D, f13, f14, f15, f16, f10, f12, f3);
        }
        if (paint2 != null && f4 != 0.0f) {
            graphics2D.setPaint(paint2);
            FlatUIUtils.paintOutline(graphics2D, f6, f7, f8, f9, f4, f5);
        }
    }

    public static void paintOutline(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f6;
        FlatUIUtils.paintOutline(graphics2D, f, f2, f3, f4, f5, f7, f7 - f5 * 2.0f);
    }

    public static void paintOutline(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f5 == 0.0f || f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        float f8 = f5 * 2.0f;
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(FlatUIUtils.createComponentRectangle(f, f2, f3, f4, f6), false);
        float_.append(FlatUIUtils.createComponentRectangle(f + f5, f2 + f5, f3 - f8, f4 - f8, f7), false);
        graphics2D.fill(float_);
    }

    public static Shape createComponentRectangle(float f, float f2, float f3, float f4, float f5) {
        if (f5 <= 0.0f) {
            return new Rectangle2D.Float(f, f2, f3, f4);
        }
        if (f3 == f4 && f5 >= f3) {
            return new Ellipse2D.Float(f, f2, f3, f4);
        }
        float f6 = f5 = Math.min(f5, Math.min(f3, f4));
        return new RoundRectangle2D.Float(f, f2, f3, f4, f6, f6);
    }

    static void paintFilledRectangle(Graphics graphics, Color color, float f, float f2, float f3, float f4) {
        graphics = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics);
            graphics.setColor(color);
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(f, f2, f3, f4));
            return;
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void paintSelection(Graphics2D graphics2D2, int n5, int n6, int n7, int n8, Insets insets, float f, float f2, float f3, float f4, int n9) {
        if (insets != null) {
            n5 += insets.left;
            n6 += insets.top;
            n7 -= insets.left + insets.right;
            n8 -= insets.top + insets.bottom;
        }
        if (!(f > 0.0f || f2 > 0.0f || f3 > 0.0f || f4 > 0.0f)) {
            graphics2D2.fillRect(n5, n6, n7, n8);
            return;
        }
        double d2 = UIScale.getSystemScaleFactor(graphics2D2);
        if (d2 != 1.0 && d2 != 2.0) {
            HiDPIUtils.paintAtScale1x(graphics2D2, n5, n6, n7, n8, (graphics2D, n, n2, n3, n4, d) -> FlatUIUtils.paintRoundedSelectionImpl(graphics2D, n, n2, n3, n4, (float)((double)f * d), (float)((double)f2 * d), (float)((double)f3 * d), (float)((double)f4 * d)));
            return;
        }
        FlatUIUtils.paintRoundedSelectionImpl(graphics2D2, n5, n6, n7, n8, f, f2, f3, f4);
    }

    private static void paintRoundedSelectionImpl(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics2D);
        graphics2D.fill(FlatUIUtils.createRoundRectanglePath(n, n2, n3, n4, f, f2, f3, f4));
        FlatUIUtils.resetRenderingHints(graphics2D, objectArray);
    }

    public static void paintGrip(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, boolean bl2) {
        float f;
        float f2;
        n6 = UIScale.scale(n6);
        n7 = UIScale.scale(n7);
        int n8 = n6 * n5 + n7 * (n5 - 1);
        if (bl) {
            f2 = n + Math.round((float)(n3 - n8) / 2.0f);
            f = (float)n2 + (float)(n4 - n6) / 2.0f;
            if (!bl2) {
                f = Math.round(f);
            }
        } else {
            f2 = (float)n + (float)(n3 - n6) / 2.0f;
            f = n2 + Math.round((float)(n4 - n8) / 2.0f);
            if (!bl2) {
                f2 = Math.round(f2);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            ((Graphics2D)graphics).fill(new Ellipse2D.Float(f2, f, n6, n6));
            if (bl) {
                f2 += (float)(n6 + n7);
                continue;
            }
            f += (float)(n6 + n7);
        }
    }

    public static void paintParentBackground(Graphics graphics, JComponent jComponent) {
        Color color = FlatUIUtils.getParentBackground(jComponent);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    public static Color getParentBackground(JComponent jComponent) {
        Serializable serializable = FlatUIUtils.findOpaqueParent(jComponent);
        serializable = serializable != null ? serializable.getBackground() : null;
        if (serializable != null) {
            return serializable;
        }
        if (FlatUIUtils.isAWTPeer(jComponent)) {
            if (jComponent instanceof JTextField || jComponent instanceof JScrollPane || jComponent.getBackground() == null) {
                return SystemColor.window;
            }
            return jComponent.getBackground();
        }
        return UIManager.getColor("Panel.background");
    }

    private static Container findOpaqueParent(Container container) {
        while ((container = container.getParent()) != null) {
            if (!container.isOpaque()) continue;
            return container;
        }
        return null;
    }

    public static Path2D createRectangle(float f, float f2, float f3, float f4, float f5) {
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(new Rectangle2D.Float(f, f2, f3, f4), false);
        float_.append(new Rectangle2D.Float(f + f5, f2 + f5, f3 - f5 * 2.0f, f4 - f5 * 2.0f), false);
        return float_;
    }

    public static Path2D createRoundRectangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(FlatUIUtils.createRoundRectanglePath(f, f2, f3, f4, f6, f7, f8, f9), false);
        float_.append(FlatUIUtils.createRoundRectanglePath(f + f5, f2 + f5, f3 - f5 * 2.0f, f4 - f5 * 2.0f, f6 - f5, f7 - f5, f8 - f5, f9 - f5), false);
        return float_;
    }

    public static Shape createRoundRectanglePath(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (f5 <= 0.0f && f6 <= 0.0f && f7 <= 0.0f && f8 <= 0.0f) {
            return new Rectangle2D.Float(f, f2, f3, f4);
        }
        float f9 = Math.min(f3, f4) / 2.0f;
        f5 = f5 > 0.0f ? Math.min(f5, f9) : 0.0f;
        f6 = f6 > 0.0f ? Math.min(f6, f9) : 0.0f;
        f7 = f7 > 0.0f ? Math.min(f7, f9) : 0.0f;
        f8 = f8 > 0.0f ? Math.min(f8, f9) : 0.0f;
        f3 = f + f3;
        f4 = f2 + f4;
        double d = (double)f5 * 0.44771525016920666;
        double d2 = (double)f6 * 0.44771525016920666;
        double d3 = (double)f7 * 0.44771525016920666;
        double d4 = (double)f8 * 0.44771525016920666;
        Path2D.Float float_ = new Path2D.Float(1, 16);
        ((Path2D)float_).moveTo(f3 - f6, f2);
        ((Path2D)float_).curveTo((double)f3 - d2, f2, f3, (double)f2 + d2, f3, f2 + f6);
        ((Path2D)float_).lineTo(f3, f4 - f8);
        ((Path2D)float_).curveTo(f3, (double)f4 - d4, (double)f3 - d4, f4, f3 - f8, f4);
        ((Path2D)float_).lineTo(f + f7, f4);
        ((Path2D)float_).curveTo((double)f + d3, f4, f, (double)f4 - d3, f, f4 - f7);
        ((Path2D)float_).lineTo(f, f2 + f5);
        ((Path2D)float_).curveTo(f, (double)f2 + d, (double)f + d, f2, f + f5, f2);
        float_.closePath();
        return float_;
    }

    public static Shape createRoundTrianglePath(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        double d = (FlatUIUtils.distance(f, f2, f3, f4) + FlatUIUtils.distance(f3, f4, f5, f6) + FlatUIUtils.distance(f5, f6, f, f2)) / 3.0;
        double d2 = 1.0 / d * (double)f7;
        double d3 = 1.0 - d2;
        return FlatUIUtils.createPath(FlatUIUtils.lerp(f5, f, d3), FlatUIUtils.lerp(f6, f2, d3), -1.000000000002E12, f, f2, FlatUIUtils.lerp(f, f3, d2), FlatUIUtils.lerp(f2, f4, d2), FlatUIUtils.lerp(f, f3, d3), FlatUIUtils.lerp(f2, f4, d3), -1.000000000002E12, f3, f4, FlatUIUtils.lerp(f3, f5, d2), FlatUIUtils.lerp(f4, f6, d2), FlatUIUtils.lerp(f3, f5, d3), FlatUIUtils.lerp(f4, f6, d3), -1.000000000002E12, f5, f6, FlatUIUtils.lerp(f5, f, d2), FlatUIUtils.lerp(f6, f2, d2));
    }

    public static void paintArrow(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, float f, float f2, float f3) {
        float f4 = UIScale.scale(n6 + (bl ? -1 : 0));
        float f5 = bl ? f4 / 2.0f : (float)UIScale.scale(n6 / 2 + 1);
        boolean bl2 = n5 == 1 || n5 == 5;
        if (!bl2) {
            float f6 = f4;
            f4 = f5;
            f5 = f6;
        }
        bl2 = bl;
        float f7 = ((float)n3 - (f4 + (float)bl2)) / 2.0f + UIScale.scale(f2);
        float f8 = ((float)n4 - (f5 + (float)bl2)) / 2.0f + UIScale.scale(f3);
        float f9 = (float)n + (n5 == 7 ? (float)(-Math.round(-(f7 + f4))) - f4 : (float)Math.round(f7));
        float f10 = (float)n2 + (n5 == 1 ? (float)(-Math.round(-(f8 + f5))) - f5 : (float)Math.round(f8));
        graphics2D.translate(f9, f10);
        Shape shape = FlatUIUtils.createArrowShape(n5, bl, f4, f5);
        if (bl) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(UIScale.scale(f)));
            FlatUIUtils.drawShapePure(graphics2D, shape);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.fill(shape);
        }
        graphics2D.translate(-f9, -f10);
    }

    public static Shape createArrowShape(int n, boolean bl, float f, float f2) {
        switch (n) {
            case 1: {
                return FlatUIUtils.createPath(!bl, 0.0, f2, f / 2.0f, 0.0, f, f2);
            }
            case 5: {
                return FlatUIUtils.createPath(!bl, 0.0, 0.0, f / 2.0f, f2, f, 0.0);
            }
            case 7: {
                return FlatUIUtils.createPath(!bl, f, 0.0, 0.0, f2 / 2.0f, f, f2);
            }
            case 3: {
                return FlatUIUtils.createPath(!bl, 0.0, 0.0, f, f2 / 2.0f, 0.0, f2);
            }
        }
        return new Path2D.Float();
    }

    public static Path2D createPath(double ... dArray) {
        return FlatUIUtils.createPath(true, dArray);
    }

    public static Path2D createPath(boolean bl, double ... dArray) {
        Path2D.Float float_ = new Path2D.Float(1, dArray.length / 2 + (bl ? 1 : 0));
        ((Path2D)float_).moveTo(dArray[0], dArray[1]);
        int n = 2;
        while (n < dArray.length) {
            double d = dArray[n];
            if (d == -1.000000000001E12) {
                ((Path2D)float_).moveTo(dArray[n + 1], dArray[n + 2]);
                n += 3;
                continue;
            }
            if (d == -1.000000000002E12) {
                ((Path2D)float_).quadTo(dArray[n + 1], dArray[n + 2], dArray[n + 3], dArray[n + 4]);
                n += 5;
                continue;
            }
            if (d == -1.000000000003E12) {
                ((Path2D)float_).curveTo(dArray[n + 1], dArray[n + 2], dArray[n + 3], dArray[n + 4], dArray[n + 5], dArray[n + 6]);
                n += 7;
                continue;
            }
            if (d == -1.000000000004E12) {
                double d2 = dArray[n + 1];
                double d3 = dArray[n + 2];
                double d4 = dArray[n + 3];
                int n2 = n + 4;
                if (dArray[n2] == -1.000000000002E12 || dArray[n2] == -1.000000000004E12) {
                    ++n2;
                }
                Point2D point2D = float_.getCurrentPoint();
                double d5 = point2D.getX();
                double d6 = point2D.getY();
                double d7 = dArray[n2];
                double d8 = dArray[n2 + 1];
                double d9 = FlatUIUtils.distance(d2, d3, d5, d6);
                double d10 = FlatUIUtils.distance(d2, d3, d7, d8);
                double d11 = 1.0 - 1.0 / d9 * d4;
                double d12 = 1.0 / d10 * d4;
                ((Path2D)float_).lineTo(FlatUIUtils.lerp(d5, d2, d11), FlatUIUtils.lerp(d6, d3, d11));
                ((Path2D)float_).quadTo(d2, d3, FlatUIUtils.lerp(d2, d7, d12), FlatUIUtils.lerp(d3, d8, d12));
                n += 4;
                continue;
            }
            if (d == -1.000000000005E12) {
                float_.closePath();
                ++n;
                continue;
            }
            ((Path2D)float_).lineTo(d, dArray[n + 1]);
            n += 2;
        }
        if (bl) {
            float_.closePath();
        }
        return float_;
    }

    private static double lerp(double d, double d2, double d3) {
        return d * (1.0 - d3) + d2 * d3;
    }

    private static double distance(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = d5;
        double d8 = d6;
        return Math.sqrt(d7 * d7 + d8 * d8);
    }

    public static void drawShapePure(Graphics2D graphics2D, Shape shape) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.translate(0.5, 0.5);
        graphics2D.draw(shape);
        graphics2D.translate(-0.5, -0.5);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        HiDPIUtils.drawStringWithYCorrection(jComponent, (Graphics2D)graphics, string, n, n2);
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        if (n >= 0 && UIScale.getUserScaleFactor() > 1.0f) {
            graphics = new Graphics2DProxy((Graphics2D)graphics){

                @Override
                public void fillRect(int n, int n2, int n3, int n4) {
                    if (n4 == 1) {
                        n4 = Math.round(UIScale.scale(0.9f));
                        n2 += n4 - 1;
                    }
                    super.fillRect(n, n2, n3, n4);
                }
            };
        }
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(jComponent, (Graphics2D)graphics, string, n, n2, n3);
    }

    public static boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        boolean bl = jComponent.isOpaque();
        LookAndFeel.installProperty(jComponent, "opaque", !bl);
        boolean bl2 = jComponent.isOpaque() == bl;
        LookAndFeel.installProperty(jComponent, "opaque", bl);
        return bl2;
    }

    public static boolean isUseSharedUIs() {
        return useSharedUIs;
    }

    public static boolean setUseSharedUIs(boolean bl) {
        boolean bl2 = useSharedUIs;
        useSharedUIs = bl;
        return bl2;
    }

    public static ComponentUI createSharedUI(Object object2, Supplier<ComponentUI> supplier) {
        if (!useSharedUIs) {
            return supplier.get();
        }
        return sharedUIinstances.computeIfAbsent(UIManager.getLookAndFeel(), lookAndFeel -> new IdentityHashMap()).computeIfAbsent(object2, object -> (ComponentUI)supplier.get());
    }

    public static boolean canUseSharedUI(JComponent jComponent) {
        return !FlatStylingSupport.hasStyleProperty(jComponent);
    }

    private static class NonUIResourceBorder
    implements Border {
        private final Border delegate;

        NonUIResourceBorder(Border border) {
            this.delegate = border;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.delegate.paintBorder(component, graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.delegate.getBorderInsets(component);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }
    }

    public static class RepaintFocusListener
    implements FocusListener {
        private final Component repaintComponent;
        private final Predicate<Component> repaintCondition;

        public RepaintFocusListener(Component component, Predicate<Component> predicate) {
            this.repaintComponent = component;
            this.repaintCondition = predicate;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                this.repaintComponent.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                this.repaintComponent.repaint();
            }
        }
    }
}

