/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class NativeLibrary {
    private static final String DELETE_SUFFIX = ".delete";
    private static boolean deletedTemporary;
    private final boolean loaded;

    public NativeLibrary(String string, ClassLoader classLoader, boolean bl) {
        this.loaded = bl ? NativeLibrary.loadLibraryFromJar(string, classLoader) : false;
    }

    public NativeLibrary(File file, boolean bl) {
        this.loaded = bl ? this.loadLibraryFromFile(file) : false;
    }

    public NativeLibrary(String string, boolean bl) {
        this.loaded = bl ? this.loadLibraryFromSystem(string) : false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private static boolean loadLibraryFromJar(String string, ClassLoader object) {
        string = NativeLibrary.decorateLibraryName(string);
        if ((object = object != null ? ((ClassLoader)object).getResource(string) : NativeLibrary.class.getResource("/" + string)) == null) {
            LoggingFacade.INSTANCE.logSevere("Library '" + string + "' not found", null);
            return false;
        }
        File file = null;
        try {
            Object object2;
            Object object3;
            if ("file".equals(((URL)object).getProtocol())) {
                object3 = ((URL)object).getPath();
                object2 = ((String)object3).replace("flatlaf-core/bin/main/", "flatlaf-core/src/main/resources/");
                File file2 = new File((String)object2);
                if (!file2.isFile()) {
                    file2 = new File((String)object3);
                }
                if (file2.isFile()) {
                    System.load(file2.getCanonicalPath());
                    return true;
                }
            }
            object3 = NativeLibrary.createTempFile(string);
            file = object3.toFile();
            object2 = ((URL)object).openStream();
            try {
                Files.copy((InputStream)object2, (Path)object3, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
            System.load(file.getCanonicalPath());
            NativeLibrary.deleteOrMarkForDeletion(file);
            return true;
        }
        catch (Throwable throwable) {
            LoggingFacade.INSTANCE.logSevere(throwable.getMessage(), throwable);
            if (file != null) {
                NativeLibrary.deleteOrMarkForDeletion(file);
            }
            return false;
        }
    }

    private boolean loadLibraryFromFile(File file) {
        try {
            System.load(file.getAbsolutePath());
            return true;
        }
        catch (Throwable throwable) {
            LoggingFacade.INSTANCE.logSevere(throwable.getMessage(), throwable);
            return false;
        }
    }

    private boolean loadLibraryFromSystem(String object) {
        try {
            System.loadLibrary((String)object);
            return true;
        }
        catch (Throwable throwable) {
            object = throwable;
            String string = throwable.getMessage();
            if (object instanceof UnsatisfiedLinkError && string != null && string.contains("java.library.path")) {
                return false;
            }
            LoggingFacade.INSTANCE.logSevere(string, (Throwable)object);
            return false;
        }
    }

    private static String decorateLibraryName(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            return string.substring(0, n + 1) + System.mapLibraryName(string.substring(n + 1));
        }
        return System.mapLibraryName(string);
    }

    private static Path createTempFile(String string) {
        int n = string.lastIndexOf(47);
        string = n >= 0 ? string.substring(n + 1) : string;
        n = string.lastIndexOf(46);
        String string2 = (n >= 0 ? string.substring(0, n) : string) + '-';
        string = n >= 0 ? string.substring(n) : "";
        Path path = NativeLibrary.getTempDir();
        long l = System.nanoTime();
        int n2 = 0;
        while (true) {
            String string3 = string2 + Long.toUnsignedString(l) + n2 + string;
            try {
                return Files.createFile(path.resolve(string3), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                ++n2;
                continue;
            }
            break;
        }
    }

    private static Path getTempDir() {
        Object object = System.getProperty("java.io.tmpdir");
        if (SystemInfo.isWindows) {
            object = (String)object + "\\flatlaf.temp";
        }
        object = Paths.get((String)object, new String[0]);
        Files.createDirectories((Path)object, new FileAttribute[0]);
        if (SystemInfo.isWindows) {
            NativeLibrary.deleteTemporaryFiles((Path)object);
        }
        return object;
    }

    private static void deleteTemporaryFiles(Path fileArray) {
        if (deletedTemporary) {
            return;
        }
        deletedTemporary = true;
        if ((fileArray = fileArray.toFile().listFiles((file, string) -> string.endsWith(DELETE_SUFFIX))) == null) {
            return;
        }
        for (File file2 : fileArray) {
            File file3 = new File(file2.getParent(), StringUtils.removeTrailing(file2.getName(), DELETE_SUFFIX));
            if (file3.exists() && !file3.delete()) continue;
            file2.delete();
        }
    }

    private static void deleteOrMarkForDeletion(File file) {
        if (file.delete()) {
            return;
        }
        try {
            file = new File(file.getParent(), file.getName() + DELETE_SUFFIX);
            file.createNewFile();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

