/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.MimesKt;
import io.ktor.util.CharsetKt;
import io.ktor.util.CollectionsKt;
import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\r\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0007\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\f\u0010\n\u001a\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0019\u0010\u000f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\bH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0013\u0010\u0014\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001aC\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u001a\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00190\u0018H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001d\u001a\u00020\u0003*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\"-\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"-\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010 \u001a\u0004\b%\u0010\"\u00a8\u0006'"}, d2={"Lio/ktor/http/ContentType$Companion;", "", "extension", "Lio/ktor/http/ContentType;", "defaultForFileExtension", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Lio/ktor/http/ContentType;", "path", "defaultForFilePath", "", "fromFilePath", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Ljava/util/List;", "ext", "fromFileExtension", "fileExtensions", "(Lio/ktor/http/ContentType;)Ljava/util/List;", "selectDefault", "(Ljava/util/List;)Lio/ktor/http/ContentType;", "", "matchApplicationTypeWithCharset", "(Lio/ktor/http/ContentType;)Z", "withCharsetUTF8IfNeeded", "(Lio/ktor/http/ContentType;)Lio/ktor/http/ContentType;", "A", "B", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "groupByPairs", "(Lkotlin/sequences/Sequence;)Ljava/util/Map;", "toContentType", "(Ljava/lang/String;)Lio/ktor/http/ContentType;", "contentTypesByExtensions$delegate", "Lkotlin/Lazy;", "getContentTypesByExtensions", "()Ljava/util/Map;", "contentTypesByExtensions", "extensionsByContentType$delegate", "getExtensionsByContentType", "extensionsByContentType", "ktor-http"})
public final class FileContentTypeKt {
    private static final Lazy contentTypesByExtensions$delegate = LazyKt.lazy(FileContentTypeKt::contentTypesByExtensions_delegate$lambda$1);
    private static final Lazy extensionsByContentType$delegate = LazyKt.lazy(FileContentTypeKt::extensionsByContentType_delegate$lambda$3);

    public static final ContentType defaultForFileExtension(ContentType.Companion companion, String string) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, string));
    }

    public static final ContentType defaultForFilePath(ContentType.Companion companion, String string) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, string));
    }

    public static final List<ContentType> fromFilePath(ContentType.Companion companion, String string) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = StringsKt.lastIndexOfAny$default((CharSequence)string, (char[])CharsetKt.toCharArray((String)"/\\"), (int)0, (boolean)false, (int)6, null);
        n = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)(n + 1), (boolean)false, (int)4, null);
        if (n == -1) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        String string2 = string.substring(n + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return FileContentTypeKt.fromFileExtension(companion, string2);
    }

    public static final List<ContentType> fromFileExtension(ContentType.Companion object, String list) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)list, (String)"");
        object = TextKt.toLowerCasePreservingASCIIRules((String)StringsKt.removePrefix((String)((Object)list), (CharSequence)"."));
        while (((CharSequence)object).length() > 0) {
            list = FileContentTypeKt.getContentTypesByExtensions().get(object);
            if (list != null) {
                return list;
            }
            object = StringsKt.substringAfter((String)object, (String)".", (String)"");
        }
        return kotlin.collections.CollectionsKt.emptyList();
    }

    public static final List<String> fileExtensions(ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        List list = FileContentTypeKt.getExtensionsByContentType().get(contentType);
        if (list == null && (list = FileContentTypeKt.getExtensionsByContentType().get(contentType.withoutParameters())) == null) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Map<String, List<ContentType>> getContentTypesByExtensions() {
        Lazy lazy = contentTypesByExtensions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<ContentType, List<String>> getExtensionsByContentType() {
        Lazy lazy = extensionsByContentType$delegate;
        return (Map)lazy.getValue();
    }

    public static final ContentType selectDefault(List<ContentType> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        Object object2 = (ContentType)kotlin.collections.CollectionsKt.firstOrNull(object);
        if (object2 == null) {
            object2 = object = ContentType.Application.INSTANCE.getOctetStream();
        }
        if (((ContentType)object2).match(ContentType.Text.INSTANCE.getAny())) {
            return FileContentTypeKt.withCharsetUTF8IfNeeded((ContentType)object);
        }
        if (((ContentType)object).match(ContentType.Image.INSTANCE.getSVG())) {
            return FileContentTypeKt.withCharsetUTF8IfNeeded((ContentType)object);
        }
        if (FileContentTypeKt.matchApplicationTypeWithCharset((ContentType)object)) {
            return FileContentTypeKt.withCharsetUTF8IfNeeded((ContentType)object);
        }
        return object;
    }

    private static final boolean matchApplicationTypeWithCharset(ContentType contentType) {
        if (!contentType.match(ContentType.Application.INSTANCE.getAny())) {
            return false;
        }
        return contentType.match(ContentType.Application.INSTANCE.getAtom()) || contentType.match(ContentType.Application.INSTANCE.getJavaScript()) || contentType.match(ContentType.Application.INSTANCE.getRss()) || contentType.match(ContentType.Application.INSTANCE.getXml()) || contentType.match(ContentType.Application.INSTANCE.getXml_Dtd());
    }

    private static final ContentType withCharsetUTF8IfNeeded(ContentType contentType) {
        if (ContentTypesKt.charset(contentType) != null) {
            return contentType;
        }
        return ContentTypesKt.withCharset(contentType, Charsets.UTF_8);
    }

    public static final <A, B> Map<A, List<B>> groupByPairs(Sequence<? extends Pair<? extends A, ? extends B>> object) {
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        Object object6;
        Intrinsics.checkNotNullParameter(object, (String)"");
        Object object7 = object;
        object = new LinkedHashMap();
        object7 = object7.iterator();
        while (object7.hasNext()) {
            Object object8;
            object6 = object;
            object5 = object7.next();
            object4 = (Pair)object5;
            object32 = object4.getFirst();
            object2 = object6.get(object32);
            if (object2 == null) {
                object4 = new ArrayList();
                object6.put(object32, object4);
                object8 = object4;
            } else {
                object8 = object2;
            }
            object4 = (List)object8;
            object4.add(object5);
        }
        object7 = object;
        object = new LinkedHashMap(MapsKt.mapCapacity((int)object.size()));
        object7 = object7.entrySet();
        object4 = object7.iterator();
        while (object4.hasNext()) {
            object7 = object4.next();
            object32 = (Map.Entry)object7;
            object6 = object;
            object2 = (Map.Entry)object7;
            Object k = object32.getKey();
            Object object9 = object6;
            object5 = object7 = (Iterable)object2.getValue();
            object7 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault(object7, (int)10));
            for (Object object32 : object5) {
                object32 = (Pair)object32;
                object6 = object7;
                object6.add((Object)object32.getSecond());
            }
            object7 = (List)object7;
            object9.put(k, object7);
        }
        return object;
    }

    public static final ContentType toContentType(String string) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            contentType = ContentType.Companion.parse(string);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Failed to parse " + string, throwable);
        }
        return contentType;
    }

    private static final Map contentTypesByExtensions_delegate$lambda$1() {
        Map map;
        Map map2 = map = CollectionsKt.caseInsensitiveMap();
        map.putAll(FileContentTypeKt.groupByPairs(kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes())));
        return map;
    }

    private static final Pair extensionsByContentType_delegate$lambda$3$lambda$2(Pair object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        String string = (String)object.component1();
        object = (ContentType)object.component2();
        return TuplesKt.to((Object)object, (Object)string);
    }

    private static final Map extensionsByContentType_delegate$lambda$3() {
        return FileContentTypeKt.groupByPairs(SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes()), FileContentTypeKt::extensionsByContentType_delegate$lambda$3$lambda$2));
    }
}

