/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CookieUtilsKt;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.parsing.ParseException;
import io.ktor.utils.io.InternalAPI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a-\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0002\u00a2\u0006\u0004\b\u0003\u0010\f\u001a7\u0010\u000f\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a3\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a3\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a\u001f\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0013\u0010\u0018\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a#\u0010\u001c\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001b\u0010\u001e\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0017\u001a\u0013\u0010 \u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b \u0010!\u001a\u0013\u0010\"\u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010!\"\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\"\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\"\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\"\u0014\u0010*\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)\u00a8\u0006+"}, d2={"", "headerValue", "Lio/ktor/http/auth/HttpAuthHeader;", "parseAuthorizationHeader", "(Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader;", "", "parseAuthorizationHeaders", "(Ljava/lang/String;)Ljava/util/List;", "", "startIndex", "", "headers", "(Ljava/lang/String;ILjava/util/List;)I", "header", "index", "nextChallengeIndex", "(Ljava/util/List;Lio/ktor/http/auth/HttpAuthHeader;ILjava/lang/String;)Ljava/lang/Integer;", "", "parameters", "matchParameters", "(Ljava/lang/String;ILjava/util/Map;)I", "matchParameter", "matchToken68", "(Ljava/lang/String;I)I", "unescaped", "(Ljava/lang/String;)Ljava/lang/String;", "", "delimiter", "skipDelimiter", "(Ljava/lang/String;IC)I", "skipSpaces", "", "isToken68", "(C)Z", "isToken", "", "TOKEN_EXTRA", "Ljava/util/Set;", "TOKEN68_EXTRA", "Lkotlin/text/Regex;", "token68Pattern", "Lkotlin/text/Regex;", "escapeRegex", "ktor-http"})
public final class HttpAuthHeaderKt {
    private static final Set<Character> TOKEN_EXTRA;
    private static final Set<Character> TOKEN68_EXTRA;
    private static final Regex token68Pattern;
    private static final Regex escapeRegex;

    public static final HttpAuthHeader parseAuthorizationHeader(String string) {
        int n;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n2 = n = HttpAuthHeaderKt.skipSpaces(string, 0);
        while (n < string.length() && HttpAuthHeaderKt.isToken(string.charAt(n))) {
            ++n;
        }
        String string2 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n2, (int)n));
        n = HttpAuthHeaderKt.skipSpaces(string, n);
        if (StringsKt.isBlank((CharSequence)string2)) {
            return null;
        }
        if (string.length() == n) {
            return new HttpAuthHeader.Parameterized(string2, CollectionsKt.emptyList(), null, 4, null);
        }
        int n3 = HttpAuthHeaderKt.matchToken68(string, n);
        String string3 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n, (int)n3)))).toString();
        if (((CharSequence)string3).length() > 0 && n3 == string.length()) {
            return new HttpAuthHeader.Single(string2, string3);
        }
        Map map = new LinkedHashMap();
        int n4 = HttpAuthHeaderKt.matchParameters(string, n, map);
        if (n4 == -1) {
            return new HttpAuthHeader.Parameterized(string2, map, null, 4, null);
        }
        throw new ParseException("Function parseAuthorizationHeader can parse only one header", null, 2, null);
    }

    @InternalAPI
    public static final List<HttpAuthHeader> parseAuthorizationHeaders(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = 0;
        List list = new ArrayList();
        while (n != -1) {
            n = HttpAuthHeaderKt.parseAuthorizationHeader(string, n, list);
        }
        return list;
    }

    private static final int parseAuthorizationHeader(String string, int n, List<HttpAuthHeader> list) {
        Integer n2;
        int n3 = n = HttpAuthHeaderKt.skipSpaces(string, n);
        while (n < string.length() && HttpAuthHeaderKt.isToken(string.charAt(n))) {
            ++n;
        }
        String string2 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n3, (int)n));
        if (StringsKt.isBlank((CharSequence)string2)) {
            throw new ParseException("Invalid authScheme value: it should be token, can't be blank", null, 2, null);
        }
        n = HttpAuthHeaderKt.skipSpaces(string, n);
        Integer n4 = HttpAuthHeaderKt.nextChallengeIndex(list, new HttpAuthHeader.Parameterized(string2, CollectionsKt.emptyList(), null, 4, null), n, string);
        if (n4 != null) {
            int n5 = ((Number)n4).intValue();
            return n5;
        }
        int n6 = HttpAuthHeaderKt.matchToken68(string, n);
        String string3 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n, (int)n6)))).toString();
        if (((CharSequence)string3).length() > 0 && (n2 = HttpAuthHeaderKt.nextChallengeIndex(list, new HttpAuthHeader.Single(string2, string3), n6, string)) != null) {
            int n7 = ((Number)n2).intValue();
            return n7;
        }
        Map map = new LinkedHashMap();
        int n8 = HttpAuthHeaderKt.matchParameters(string, n, map);
        list.add(new HttpAuthHeader.Parameterized(string2, map, null, 4, null));
        return n8;
    }

    private static final Integer nextChallengeIndex(List<HttpAuthHeader> list, HttpAuthHeader httpAuthHeader, int n, String string) {
        if (n == string.length() || string.charAt(n) == ',') {
            list.add(httpAuthHeader);
            if (n == string.length()) {
                return -1;
            }
            if (string.charAt(n) == ',') {
                return n + 1;
            }
            throw new IllegalStateException("".toString());
        }
        return null;
    }

    private static final int matchParameters(String string, int n, Map<String, String> map) {
        while (n > 0 && n < string.length()) {
            int n2 = HttpAuthHeaderKt.matchParameter(string, n, map);
            if (n2 == n) {
                return n;
            }
            n = HttpAuthHeaderKt.skipDelimiter(string, n2, ',');
        }
        return n;
    }

    private static final int matchParameter(String string, int n, Map<String, String> map) {
        int n2;
        int n3;
        for (n3 = n2 = HttpAuthHeaderKt.skipSpaces(string, n); n3 < string.length() && HttpAuthHeaderKt.isToken(string.charAt(n3)); ++n3) {
        }
        String string2 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n2, (int)n3));
        if ((n3 = HttpAuthHeaderKt.skipSpaces(string, n3)) == string.length() || string.charAt(n3) != '=') {
            return n;
        }
        ++n3;
        n = 0;
        int n4 = n3;
        if (string.charAt(n3) == '\"') {
            n = 1;
            n4 = ++n3;
            boolean bl = false;
            while (n3 < string.length() && (string.charAt(n3) != '\"' || bl)) {
                bl = !bl && string.charAt(n3) == '\\';
                ++n3;
            }
            if (n3 == string.length()) {
                throw new ParseException("Expected closing quote'\"' in parameter", null, 2, null);
            }
        } else {
            for (n3 = HttpAuthHeaderKt.skipSpaces(string, n3); n3 < string.length() && string.charAt(n3) != ' ' && string.charAt(n3) != ','; ++n3) {
            }
        }
        String string3 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n4, (int)n3));
        map.put(string2, n != 0 ? HttpAuthHeaderKt.unescaped(string3) : string3);
        if (n != 0) {
            ++n3;
        }
        return n3;
    }

    private static final int matchToken68(String string, int n) {
        for (n = HttpAuthHeaderKt.skipSpaces(string, n); n < string.length() && HttpAuthHeaderKt.isToken68(string.charAt(n)); ++n) {
        }
        while (n < string.length() && string.charAt(n) == '=') {
            ++n;
        }
        return HttpAuthHeaderKt.skipSpaces(string, n);
    }

    private static final String unescaped(String charSequence) {
        charSequence = charSequence;
        Regex regex = escapeRegex;
        Function1 function1 = HttpAuthHeaderKt::unescaped$lambda$2;
        return regex.replace(charSequence, function1);
    }

    private static final int skipDelimiter(String string, int n, char c) {
        if ((n = HttpAuthHeaderKt.skipSpaces(string, n)) == string.length()) {
            return -1;
        }
        if (string.charAt(n) != c) {
            throw new ParseException("Expected delimiter " + c + " at position " + n, null, 2, null);
        }
        return HttpAuthHeaderKt.skipSpaces(string, ++n);
    }

    private static final int skipSpaces(String string, int n) {
        while (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        return n;
    }

    private static final boolean isToken68(char c) {
        block4: {
            block3: {
                if ('a' <= c ? c < '{' : false) break block3;
                boolean bl = 'A' <= c ? c < '[' : false;
                if (!bl && !CookieUtilsKt.isDigit(c) && !TOKEN68_EXTRA.contains(Character.valueOf(c))) break block4;
            }
            return true;
        }
        return false;
    }

    private static final boolean isToken(char c) {
        block4: {
            block3: {
                if ('a' <= c ? c < '{' : false) break block3;
                boolean bl = 'A' <= c ? c < '[' : false;
                if (!bl && !CookieUtilsKt.isDigit(c) && !TOKEN_EXTRA.contains(Character.valueOf(c))) break block4;
            }
            return true;
        }
        return false;
    }

    private static final CharSequence unescaped$lambda$2(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"");
        return StringsKt.takeLast((String)matchResult.getValue(), (int)1);
    }

    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }

    static {
        Object[] objectArray = new Character[15];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Character.valueOf('!');
        objectArray2[1] = Character.valueOf('#');
        objectArray2[2] = Character.valueOf('$');
        objectArray2[3] = Character.valueOf('%');
        objectArray2[4] = Character.valueOf('&');
        objectArray2[5] = Character.valueOf('\'');
        objectArray2[6] = Character.valueOf('*');
        objectArray2[7] = Character.valueOf('+');
        objectArray2[8] = Character.valueOf('-');
        objectArray2[9] = Character.valueOf('.');
        objectArray2[10] = Character.valueOf('^');
        objectArray2[11] = Character.valueOf('_');
        objectArray2[12] = Character.valueOf('`');
        objectArray2[13] = Character.valueOf('|');
        objectArray2[14] = Character.valueOf('~');
        TOKEN_EXTRA = SetsKt.setOf((Object[])objectArray2);
        Character[] characterArray = new Character[6];
        objectArray2 = characterArray;
        characterArray[0] = Character.valueOf('-');
        objectArray2[1] = Character.valueOf('.');
        objectArray2[2] = Character.valueOf('_');
        objectArray2[3] = Character.valueOf('~');
        objectArray2[4] = Character.valueOf('+');
        objectArray2[5] = Character.valueOf('/');
        TOKEN68_EXTRA = SetsKt.setOf((Object[])objectArray2);
        token68Pattern = new Regex("[a-zA-Z0-9\\-._~+/]+=*");
        escapeRegex = new Regex("\\\\.");
    }
}

