/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.helper.TimeBasedArchiveRemover;
import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeAndTimeBasedArchiveRemover
extends TimeBasedArchiveRemover {
    protected static final int NO_INDEX = -1;

    public SizeAndTimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        super(fileNamePattern, rollingCalendar);
    }

    @Override
    protected File[] getFilesInPeriod(Instant fileArray) {
        File file = new File(this.fileNamePattern.convertMultipleArguments(fileArray, 0));
        file = this.getParentDir(file);
        fileArray = this.createStemRegex((Instant)fileArray);
        fileArray = FileFilterUtil.filesInFolderMatchingStemRegex(file, (String)fileArray);
        return fileArray;
    }

    private String createStemRegex(Instant object) {
        object = this.fileNamePattern.toRegexForFixedDate((Instant)object);
        return FileFilterUtil.afterLastSlash((String)object);
    }

    @Override
    protected void descendingSort(File[] fileArray, Instant object) {
        object = this.createStemRegex((Instant)object);
        object = Pattern.compile((String)object);
        Arrays.sort(fileArray, new Comparator<File>(){
            final /* synthetic */ Pattern val$pattern;
            {
                this.val$pattern = pattern;
            }

            @Override
            public int compare(File file, File file2) {
                1 v0 = this;
                int n = v0.extractIndex(v0.val$pattern, file);
                1 v1 = this;
                int n2 = v1.extractIndex(v1.val$pattern, file2);
                if (n == n2) {
                    return 0;
                }
                if (n2 < n) {
                    return -1;
                }
                return 1;
            }

            private int extractIndex(Pattern object, File file) {
                if (((Matcher)(object = ((Pattern)object).matcher(file.getName()))).find()) {
                    if ((object = ((Matcher)object).group(1)) == null || ((String)object).isEmpty()) {
                        return -1;
                    }
                    return Integer.parseInt((String)object);
                }
                return -1;
            }
        });
    }
}

