/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectDecoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;

public class HttpRequestDecoder
extends HttpObjectDecoder {
    private static final AsciiString Accept = AsciiString.cached((String)"Accept");
    private static final AsciiString Host = AsciiString.cached((String)"Host");
    private static final AsciiString Connection = AsciiString.cached((String)"Connection");
    private static final AsciiString ContentType = AsciiString.cached((String)"Content-Type");
    private static final AsciiString ContentLength = AsciiString.cached((String)"Content-Length");
    private static final int GET_AS_INT = 0x544547;
    private static final int POST_AS_INT = 1414745936;
    private static final long HTTP_1_1_AS_LONG = 3543824036068086856L;
    private static final long HTTP_1_0_AS_LONG = 3471766442030158920L;
    private static final int HOST_AS_INT = 1953722184;
    private static final long CONNECTION_AS_LONG_0 = 7598807758576447299L;
    private static final short CONNECTION_AS_SHORT_1 = 28271;
    private static final long CONTENT_AS_LONG = 3275364211029339971L;
    private static final int TYPE_AS_INT = 1701869908;
    private static final long LENGTH_AS_LONG = 114849160783180L;
    private static final long ACCEPT_AS_LONG = 128026086171457L;

    public HttpRequestDecoder() {
    }

    public HttpRequestDecoder(int n, int n2, int n3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3));
    }

    @Deprecated
    public HttpRequestDecoder(int n, int n2, int n3, boolean bl) {
        super(n, n2, n3, true, bl);
    }

    @Deprecated
    public HttpRequestDecoder(int n, int n2, int n3, boolean bl, int n4) {
        super(n, n2, n3, true, bl, n4);
    }

    @Deprecated
    public HttpRequestDecoder(int n, int n2, int n3, boolean bl, int n4, boolean bl2) {
        super(n, n2, n3, true, bl, n4, bl2);
    }

    @Deprecated
    public HttpRequestDecoder(int n, int n2, int n3, boolean bl, int n4, boolean bl2, boolean bl3) {
        super(n, n2, n3, true, bl, n4, bl2, bl3);
    }

    public HttpRequestDecoder(HttpDecoderConfig httpDecoderConfig) {
        super(httpDecoderConfig);
    }

    @Override
    protected HttpMessage createMessage(String[] stringArray) {
        return new DefaultHttpRequest(HttpVersion.valueOf(stringArray[2], true), HttpMethod.valueOf(stringArray[0]), stringArray[1], this.headersFactory);
    }

    @Override
    protected AsciiString splitHeaderName(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        if (by == 72) {
            if (n2 == 4 && HttpRequestDecoder.isHost(byArray, n)) {
                return Host;
            }
        } else if (by == 65) {
            if (n2 == 6 && HttpRequestDecoder.isAccept(byArray, n)) {
                return Accept;
            }
        } else if (by == 67) {
            if (n2 == 10) {
                if (HttpRequestDecoder.isConnection(byArray, n)) {
                    return Connection;
                }
            } else if (n2 == 12) {
                if (HttpRequestDecoder.isContentType(byArray, n)) {
                    return ContentType;
                }
            } else if (n2 == 14 && HttpRequestDecoder.isContentLength(byArray, n)) {
                return ContentLength;
            }
        }
        return super.splitHeaderName(byArray, n, n2);
    }

    private static boolean isAccept(byte[] byArray, int n) {
        long l = (long)(byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24) | (long)byArray[n + 4] << 32 | (long)byArray[n + 5] << 40;
        return l == 128026086171457L;
    }

    private static boolean isHost(byte[] byArray, int n) {
        int n2 = byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24;
        return n2 == 1953722184;
    }

    private static boolean isConnection(byte[] byArray, int n) {
        long l = (long)(byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24) | (long)byArray[n + 4] << 32 | (long)byArray[n + 5] << 40 | (long)byArray[n + 6] << 48 | (long)byArray[n + 7] << 56;
        if (l != 7598807758576447299L) {
            return false;
        }
        short s = (short)(byArray[n + 8] | byArray[n + 9] << 8);
        return s == 28271;
    }

    private static boolean isContentType(byte[] byArray, int n) {
        long l = (long)(byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24) | (long)byArray[n + 4] << 32 | (long)byArray[n + 5] << 40 | (long)byArray[n + 6] << 48 | (long)byArray[n + 7] << 56;
        if (l != 3275364211029339971L) {
            return false;
        }
        int n2 = byArray[n + 8] | byArray[n + 9] << 8 | byArray[n + 10] << 16 | byArray[n + 11] << 24;
        return n2 == 1701869908;
    }

    private static boolean isContentLength(byte[] byArray, int n) {
        long l = (long)(byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24) | (long)byArray[n + 4] << 32 | (long)byArray[n + 5] << 40 | (long)byArray[n + 6] << 48 | (long)byArray[n + 7] << 56;
        if (l != 3275364211029339971L) {
            return false;
        }
        long l2 = (long)(byArray[n + 8] | byArray[n + 9] << 8 | byArray[n + 10] << 16 | byArray[n + 11] << 24) | (long)byArray[n + 12] << 32 | (long)byArray[n + 13] << 40;
        return l2 == 114849160783180L;
    }

    private static boolean isGetMethod(byte[] byArray, int n) {
        int n2 = byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16;
        return n2 == 0x544547;
    }

    private static boolean isPostMethod(byte[] byArray, int n) {
        int n2 = byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24;
        return n2 == 1414745936;
    }

    @Override
    protected String splitFirstWordInitialLine(byte[] byArray, int n, int n2) {
        if (n2 == 3) {
            if (HttpRequestDecoder.isGetMethod(byArray, n)) {
                return HttpMethod.GET.name();
            }
        } else if (n2 == 4 && HttpRequestDecoder.isPostMethod(byArray, n)) {
            return HttpMethod.POST.name();
        }
        return super.splitFirstWordInitialLine(byArray, n, n2);
    }

    @Override
    protected String splitThirdWordInitialLine(byte[] byArray, int n, int n2) {
        if (n2 == 8) {
            long l = (long)(byArray[n] | byArray[n + 1] << 8 | byArray[n + 2] << 16 | byArray[n + 3] << 24) | (long)byArray[n + 4] << 32 | (long)byArray[n + 5] << 40 | (long)byArray[n + 6] << 48 | (long)byArray[n + 7] << 56;
            if (l == 3543824036068086856L) {
                return "HTTP/1.1";
            }
            if (l == 3471766442030158920L) {
                return "HTTP/1.0";
            }
        }
        return super.splitThirdWordInitialLine(byArray, n, n2);
    }

    @Override
    protected HttpMessage createInvalidMessage() {
        return new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "/bad-request", Unpooled.buffer((int)0), this.headersFactory, this.trailersFactory);
    }

    @Override
    protected boolean isDecodingRequest() {
        return true;
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage.getClass() == DefaultHttpRequest.class) {
            return false;
        }
        return super.isContentAlwaysEmpty(httpMessage);
    }
}

