/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS = AsciiString.of((CharSequence)(HttpHeaderValues.CHARSET + "="));
    private static final AsciiString SEMICOLON = AsciiString.cached((String)";");
    private static final String COMMA_STRING = ",";
    private static final long TOKEN_CHARS_HIGH;
    private static final long TOKEN_CHARS_LOW;

    private HttpUtil() {
    }

    public static boolean isOriginForm(URI uRI) {
        return HttpUtil.isOriginForm(uRI.toString());
    }

    public static boolean isOriginForm(String string) {
        return string.startsWith("/");
    }

    public static boolean isAsteriskForm(URI uRI) {
        return HttpUtil.isAsteriskForm(uRI.toString());
    }

    public static boolean isAsteriskForm(String string) {
        return "*".equals(string);
    }

    public static boolean isKeepAlive(HttpMessage httpMessage) {
        return !httpMessage.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true) && (httpMessage.protocolVersion().isKeepAliveDefault() || httpMessage.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true));
    }

    public static void setKeepAlive(HttpMessage httpMessage, boolean bl) {
        HttpUtil.setKeepAlive(httpMessage.headers(), httpMessage.protocolVersion(), bl);
    }

    public static void setKeepAlive(HttpHeaders httpHeaders, HttpVersion httpVersion, boolean bl) {
        if (httpVersion.isKeepAliveDefault()) {
            if (bl) {
                httpHeaders.remove((CharSequence)HttpHeaderNames.CONNECTION);
                return;
            }
            httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            return;
        }
        if (bl) {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            return;
        }
        httpHeaders.remove((CharSequence)HttpHeaderNames.CONNECTION);
    }

    public static long getContentLength(HttpMessage httpMessage) {
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l >= 0L) {
            return l;
        }
        throw new NumberFormatException("header not found: " + HttpHeaderNames.CONTENT_LENGTH);
    }

    public static long getContentLength(HttpMessage httpMessage, long l) {
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l2 = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l2 >= 0L) {
            return l2;
        }
        return l;
    }

    public static int getContentLength(HttpMessage httpMessage, int n) {
        return (int)Math.min(Integer.MAX_VALUE, HttpUtil.getContentLength(httpMessage, (long)n));
    }

    static int getWebSocketContentLength(HttpMessage httpMessage) {
        HttpHeaders httpHeaders = httpMessage.headers();
        if (httpMessage instanceof HttpRequest) {
            if (HttpMethod.GET.equals((httpMessage = (HttpRequest)httpMessage).method()) && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1) && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (httpMessage instanceof HttpResponse && (httpMessage = (HttpResponse)httpMessage).status().code() == 101 && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static void setContentLength(HttpMessage httpMessage, long l) {
        httpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)l);
    }

    public static boolean isContentLengthSet(HttpMessage httpMessage) {
        return httpMessage.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage httpMessage) {
        return HttpUtil.isExpectHeaderValid(httpMessage) && httpMessage.headers().contains((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE, true);
    }

    static boolean isUnsupportedExpectation(HttpMessage object) {
        if (!HttpUtil.isExpectHeaderValid((HttpMessage)object)) {
            return false;
        }
        return (object = object.headers().get((CharSequence)HttpHeaderNames.EXPECT)) != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase((String)object);
    }

    private static boolean isExpectHeaderValid(HttpMessage httpMessage) {
        return httpMessage instanceof HttpRequest && httpMessage.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static void set100ContinueExpected(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE);
            return;
        }
        httpMessage.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
    }

    public static boolean isTransferEncodingChunked(HttpMessage httpMessage) {
        return httpMessage.headers().containsValue((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            httpMessage.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            return;
        }
        List<String> list = httpMessage.headers().getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (list.isEmpty()) {
            return;
        }
        list = new ArrayList<String>(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence = (CharSequence)iterator.next();
            if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            httpMessage.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            return;
        }
        httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, list);
    }

    public static Charset getCharset(HttpMessage httpMessage) {
        return HttpUtil.getCharset(httpMessage, CharsetUtil.ISO_8859_1);
    }

    public static Charset getCharset(CharSequence charSequence) {
        if (charSequence != null) {
            return HttpUtil.getCharset(charSequence, CharsetUtil.ISO_8859_1);
        }
        return CharsetUtil.ISO_8859_1;
    }

    public static Charset getCharset(HttpMessage object, Charset charset) {
        if ((object = object.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null) {
            return HttpUtil.getCharset((CharSequence)object, charset);
        }
        return charset;
    }

    public static Charset getCharset(CharSequence charSequence, Charset charset) {
        if (charSequence != null && (charSequence = HttpUtil.getCharsetAsSequence(charSequence)) != null) {
            if (charSequence.length() > 2 && charSequence.charAt(0) == '\"') {
                CharSequence charSequence2 = charSequence;
                if (charSequence2.charAt(charSequence2.length() - 1) == '\"') {
                    charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                }
            }
            try {
                return Charset.forName(charSequence.toString());
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {}
        }
        return charset;
    }

    @Deprecated
    public static CharSequence getCharsetAsString(HttpMessage httpMessage) {
        return HttpUtil.getCharsetAsSequence(httpMessage);
    }

    public static CharSequence getCharsetAsSequence(HttpMessage object) {
        if ((object = object.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null) {
            return HttpUtil.getCharsetAsSequence((CharSequence)object);
        }
        return null;
    }

    public static CharSequence getCharsetAsSequence(CharSequence charSequence) {
        ObjectUtil.checkNotNull((Object)charSequence, (String)"contentTypeValue");
        int n = AsciiString.indexOfIgnoreCaseAscii((CharSequence)charSequence, (CharSequence)CHARSET_EQUALS, (int)0);
        if (n == -1) {
            return null;
        }
        if ((n += CHARSET_EQUALS.length()) < charSequence.length()) {
            if ((n = AsciiString.indexOfIgnoreCaseAscii((CharSequence)(charSequence = charSequence.subSequence(n, charSequence.length())), (CharSequence)SEMICOLON, (int)0)) == -1) {
                return charSequence;
            }
            return charSequence.subSequence(0, n);
        }
        return null;
    }

    public static CharSequence getMimeType(HttpMessage object) {
        if ((object = object.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null) {
            return HttpUtil.getMimeType((CharSequence)object);
        }
        return null;
    }

    public static CharSequence getMimeType(CharSequence charSequence) {
        ObjectUtil.checkNotNull((Object)charSequence, (String)"contentTypeValue");
        int n = AsciiString.indexOfIgnoreCaseAscii((CharSequence)charSequence, (CharSequence)SEMICOLON, (int)0);
        if (n != -1) {
            return charSequence.subSequence(0, n);
        }
        if (charSequence.length() > 0) {
            return charSequence;
        }
        return null;
    }

    public static String formatHostnameForHttp(InetSocketAddress inetSocketAddress) {
        String string = NetUtil.getHostname((InetSocketAddress)inetSocketAddress);
        if (NetUtil.isValidIpV6Address((String)string)) {
            if (!inetSocketAddress.isUnresolved()) {
                string = NetUtil.toAddressString((InetAddress)inetSocketAddress.getAddress());
            } else if (string.charAt(0) == '[') {
                String string2 = string;
                if (string2.charAt(string2.length() - 1) == ']') {
                    return string;
                }
            }
            return "[" + string + ']';
        }
        return string;
    }

    public static long normalizeAndGetContentLength(List<? extends CharSequence> list, boolean bl, boolean n) {
        if (list.isEmpty()) {
            return -1L;
        }
        String string = list.get(0).toString();
        boolean bl2 = list.size() > 1 || string.indexOf(44) >= 0;
        if (bl2 && !bl) {
            int n2;
            if (n2 != 0) {
                String numberFormatException = null;
                for (CharSequence stringArray : list) {
                    String[] stringArray2;
                    String[] stringArray3 = stringArray2 = stringArray.toString().split(COMMA_STRING, -1);
                    n2 = stringArray2.length;
                    for (int i = 0; i < n2; ++i) {
                        String string2 = stringArray3[i];
                        string2 = string2.trim();
                        if (numberFormatException == null) {
                            numberFormatException = string2;
                            continue;
                        }
                        if (string2.equals(numberFormatException)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
                    }
                }
                string = numberFormatException;
            } else {
                throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
            }
        }
        if (string.isEmpty() || !Character.isDigit(string.charAt(0))) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string);
        }
        try {
            long l = Long.parseLong(string);
            return ObjectUtil.checkPositiveOrZero((long)l, (String)"Content-Length value");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string, numberFormatException);
        }
    }

    static int validateToken(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return HttpUtil.validateAsciiStringToken((AsciiString)charSequence);
        }
        return HttpUtil.validateCharSequenceToken(charSequence);
    }

    private static int validateAsciiStringToken(AsciiString asciiString) {
        byte[] byArray = asciiString.array();
        int n = asciiString.arrayOffset() + asciiString.length();
        for (int i = asciiString.arrayOffset(); i < n; ++i) {
            if (BitSet128.contains(byArray[i], TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i - asciiString.arrayOffset();
        }
        return -1;
    }

    private static int validateCharSequenceToken(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            byte by = (byte)charSequence.charAt(i);
            if (BitSet128.contains(by, TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i;
        }
        return -1;
    }

    static {
        BitSet128 bitSet128 = new BitSet128().range('0', '9').range('a', 'z').range('A', 'Z').bits('-', '.', '_', '~').bits('!', '#', '$', '%', '&', '\'', '*', '+', '^', '`', '|');
        TOKEN_CHARS_HIGH = bitSet128.high();
        TOKEN_CHARS_LOW = bitSet128.low();
    }

    private static final class BitSet128 {
        private long high;
        private long low;

        private BitSet128() {
        }

        final BitSet128 range(char c, char c2) {
            while (c <= c2) {
                if (c < '@') {
                    this.low |= 1L << c;
                } else {
                    this.high |= 1L << c - 64;
                }
                c = (char)(c + 1);
            }
            return this;
        }

        final BitSet128 bits(char ... cArray) {
            for (char c : cArray) {
                if (c < '@') {
                    this.low |= 1L << c;
                    continue;
                }
                this.high |= 1L << c - 64;
            }
            return this;
        }

        final long high() {
            return this.high;
        }

        final long low() {
            return this.low;
        }

        static boolean contains(byte by, long l, long l2) {
            if (by < 0) {
                return false;
            }
            if (by < 64) {
                return 0L != (l2 & 1L << by);
            }
            return 0L != (l & 1L << by - 64);
        }
    }
}

