/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostMultipartRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final int maxFields;
    private final int maxBufferedBytes;
    private Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private final String multipartDataBoundary;
    private String multipartMixedBoundary;
    private HttpPostRequestDecoder.MultiPartStatus currentStatus = HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED;
    private Map<CharSequence, Attribute> currentFieldAttributes;
    private FileUpload currentFileUpload;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;
    private static final String FILENAME_ENCODED = HttpHeaderValues.FILENAME.toString() + '*';

    public HttpPostMultipartRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        this(httpDataFactory, httpRequest, charset, 128, 1024);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory stringArray, HttpRequest httpRequest, Charset charset, int n, int n2) {
        this.request = (HttpRequest)ObjectUtil.checkNotNull((Object)httpRequest, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNull((Object)stringArray, (String)"factory");
        this.maxFields = n;
        this.maxBufferedBytes = n2;
        stringArray = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (stringArray == null) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException("No '" + HttpHeaderNames.CONTENT_TYPE + "' header present.");
        }
        if ((stringArray = HttpPostRequestDecoder.getMultipartDataBoundary((String)stringArray)) != null) {
            this.multipartDataBoundary = stringArray[0];
            if (stringArray.length > 1 && stringArray[1] != null) {
                try {
                    this.charset = Charset.forName(stringArray[1]);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalCharsetNameException);
                }
            }
        } else {
            this.multipartDataBoundary = null;
        }
        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
        try {
            if (!(httpRequest instanceof HttpContent)) {
                this.parseBody();
                return;
            }
            this.offer((HttpContent)((Object)httpRequest));
        }
        catch (Throwable throwable) {
            this.destroy();
            PlatformDependent.throwException((Throwable)throwable);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostMultipartRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return true;
    }

    @Override
    public void setDiscardThreshold(int n) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero((int)n, (String)"discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String object) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        if ((object = this.bodyMapHttpData.get(object)) != null) {
            return (InterfaceHttpData)object.get(0);
        }
        return null;
    }

    @Override
    public HttpPostMultipartRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        httpContent = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = httpContent.alloc().buffer(httpContent.readableBytes()).writeBytes((ByteBuf)httpContent);
        } else {
            this.undecodedChunk.writeBytes((ByteBuf)httpContent);
        }
        this.parseBody();
        if (this.maxBufferedBytes > 0 && this.undecodedChunk != null && this.undecodedChunk.readableBytes() > this.maxBufferedBytes) {
            throw new HttpPostRequestDecoder.TooLongFormFieldException();
        }
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            if (this.undecodedChunk.refCnt() == 1) {
                this.undecodedChunk.discardReadBytes();
            } else {
                httpContent = this.undecodedChunk.alloc().buffer(this.undecodedChunk.readableBytes());
                httpContent.writeBytes(this.undecodedChunk);
                this.undecodedChunk.release();
                this.undecodedChunk = httpContent;
            }
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder.EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        if (this.currentFileUpload != null) {
            return this.currentFileUpload;
        }
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyMultipart();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        if (this.maxFields > 0 && this.bodyListHttpData.size() >= this.maxFields) {
            throw new HttpPostRequestDecoder.TooManyFormFieldsException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    private void parseBodyMultipart() {
        if (this.undecodedChunk == null || this.undecodedChunk.readableBytes() == 0) {
            return;
        }
        HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
        InterfaceHttpData interfaceHttpData = httpPostMultipartRequestDecoder.decodeMultipart(httpPostMultipartRequestDecoder.currentStatus);
        while (interfaceHttpData != null) {
            this.addHttpData(interfaceHttpData);
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) break;
            HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder2 = this;
            interfaceHttpData = httpPostMultipartRequestDecoder2.decodeMultipart(httpPostMultipartRequestDecoder2.currentStatus);
        }
    }

    private InterfaceHttpData decodeMultipart(HttpPostRequestDecoder.MultiPartStatus object) {
        switch (object) {
            case NOTSTARTED: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case PREAMBLE: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case HEADERDELIMITER: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.findMultipartDelimiter(httpPostMultipartRequestDecoder.multipartDataBoundary, HttpPostRequestDecoder.MultiPartStatus.DISPOSITION, HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE);
            }
            case DISPOSITION: {
                return this.findMultipartDisposition();
            }
            case FIELD: {
                Attribute attribute;
                object = null;
                Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET);
                if (attribute2 != null) {
                    try {
                        object = Charset.forName(attribute2.getValue());
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(unsupportedCharsetException);
                    }
                }
                attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
                if (this.currentAttribute == null) {
                    long l;
                    attribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
                    try {
                        l = attribute != null ? Long.parseLong(attribute.getValue()) : 0L;
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        l = 0L;
                    }
                    try {
                        this.currentAttribute = l > 0L ? this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute2.getValue()), l) : this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute2.getValue()));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                    }
                    if (object != null) {
                        this.currentAttribute.setCharset((Charset)object);
                    }
                }
                if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, this.multipartDataBoundary, this.currentAttribute)) {
                    return null;
                }
                attribute = this.currentAttribute;
                this.currentAttribute = null;
                this.currentFieldAttributes = null;
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                return attribute;
            }
            case FILEUPLOAD: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.getFileUpload(httpPostMultipartRequestDecoder.multipartDataBoundary);
            }
            case MIXEDDELIMITER: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.findMultipartDelimiter(httpPostMultipartRequestDecoder.multipartMixedBoundary, HttpPostRequestDecoder.MultiPartStatus.MIXEDDISPOSITION, HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            case MIXEDDISPOSITION: {
                return this.findMultipartDisposition();
            }
            case MIXEDFILEUPLOAD: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.getFileUpload(httpPostMultipartRequestDecoder.multipartMixedBoundary);
            }
            case PREEPILOGUE: {
                return null;
            }
            case EPILOGUE: {
                return null;
            }
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Shouldn't reach here.");
    }

    private static void skipControlCharacters(ByteBuf object) {
        if (!object.hasArray()) {
            try {
                HttpPostMultipartRequestDecoder.skipControlCharactersStandard((ByteBuf)object);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
            }
        }
        object = new HttpPostBodyUtil.SeekAheadOptimize((ByteBuf)object);
        while (((HttpPostBodyUtil.SeekAheadOptimize)object).pos < ((HttpPostBodyUtil.SeekAheadOptimize)object).limit) {
            char c;
            if (Character.isISOControl(c = (char)(((HttpPostBodyUtil.SeekAheadOptimize)object).bytes[((HttpPostBodyUtil.SeekAheadOptimize)object).pos++] & 0xFF)) || Character.isWhitespace(c)) continue;
            ((HttpPostBodyUtil.SeekAheadOptimize)object).setReadPosition(1);
            return;
        }
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException("Access out of bounds");
    }

    private static void skipControlCharactersStandard(ByteBuf byteBuf) {
        char c;
        while (Character.isISOControl(c = (char)byteBuf.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        ByteBuf byteBuf2 = byteBuf;
        byteBuf2.readerIndex(byteBuf2.readerIndex() - 1);
    }

    private InterfaceHttpData findMultipartDelimiter(String string, HttpPostRequestDecoder.MultiPartStatus multiPartStatus, HttpPostRequestDecoder.MultiPartStatus multiPartStatus2) {
        String string2;
        int n = this.undecodedChunk.readerIndex();
        try {
            HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            return null;
        }
        this.skipOneLine();
        try {
            string2 = HttpPostMultipartRequestDecoder.readDelimiterOptimized(this.undecodedChunk, string, this.charset);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            return null;
        }
        if (string2.equals(string)) {
            this.currentStatus = multiPartStatus;
            return this.decodeMultipart(multiPartStatus);
        }
        if (string2.equals(string + "--")) {
            this.currentStatus = multiPartStatus2;
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER) {
                this.currentFieldAttributes = null;
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            return null;
        }
        this.undecodedChunk.readerIndex(n);
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("No Multipart delimiter found");
    }

    private InterfaceHttpData findMultipartDisposition() {
        String[] stringArray;
        int n = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            this.currentFieldAttributes = new TreeMap<CharSequence, Attribute>(CaseIgnoringComparator.INSTANCE);
        }
        while (!this.skipOneLine()) {
            Object object;
            Object object2;
            int n2;
            try {
                HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
                stringArray = HttpPostMultipartRequestDecoder.readLineOptimized(this.undecodedChunk, this.charset);
            }
            catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
                this.undecodedChunk.readerIndex(n);
                return null;
            }
            stringArray = HttpPostMultipartRequestDecoder.splitMultipartHeader((String)stringArray);
            if (HttpHeaderNames.CONTENT_DISPOSITION.contentEqualsIgnoreCase((CharSequence)stringArray[0])) {
                if ((this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION ? HttpHeaderValues.FORM_DATA.contentEqualsIgnoreCase((CharSequence)stringArray[1]) : (n2 = HttpHeaderValues.ATTACHMENT.contentEqualsIgnoreCase((CharSequence)stringArray[1]) || HttpHeaderValues.FILE.contentEqualsIgnoreCase((CharSequence)stringArray[1]) ? 1 : 0)) == 0) continue;
                for (int i = 2; i < stringArray.length; ++i) {
                    object2 = stringArray[i].split("=", 2);
                    try {
                        object = this.getContentDispositionAttribute((String)object2);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(object.getName(), (Attribute)object);
                }
                continue;
            }
            if (HttpHeaderNames.CONTENT_TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)stringArray[0])) {
                Attribute attribute;
                try {
                    attribute = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_TRANSFER_ENCODING.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put((CharSequence)HttpHeaderNames.CONTENT_TRANSFER_ENCODING, attribute);
                continue;
            }
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)stringArray[0])) {
                Attribute attribute;
                try {
                    attribute = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_LENGTH.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put((CharSequence)HttpHeaderNames.CONTENT_LENGTH, attribute);
                continue;
            }
            if (!HttpHeaderNames.CONTENT_TYPE.contentEqualsIgnoreCase((CharSequence)stringArray[0])) continue;
            if (HttpHeaderValues.MULTIPART_MIXED.contentEqualsIgnoreCase((CharSequence)stringArray[1])) {
                if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
                    String string = StringUtil.substringAfter((String)stringArray[2], (char)'=');
                    this.multipartMixedBoundary = "--" + string;
                    this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                    return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER);
                }
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Mixed Multipart found in a previous Mixed Multipart");
            }
            for (n2 = 1; n2 < stringArray.length; ++n2) {
                Object object3 = HttpHeaderValues.CHARSET.toString();
                if (stringArray[n2].regionMatches(true, 0, (String)object3, 0, ((String)object3).length())) {
                    object2 = StringUtil.substringAfter((String)stringArray[n2], (char)'=');
                    try {
                        object = this.factory.createAttribute(this.request, (String)object3, HttpPostMultipartRequestDecoder.cleanString((String)object2));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put((CharSequence)HttpHeaderValues.CHARSET, (Attribute)object);
                    continue;
                }
                if (stringArray[n2].contains("=")) {
                    object2 = StringUtil.substringBefore((String)stringArray[n2], (char)'=');
                    object = StringUtil.substringAfter((String)stringArray[n2], (char)'=');
                    try {
                        object3 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString((String)object2), (String)object);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put((CharSequence)object2, (Attribute)object3);
                    continue;
                }
                try {
                    object2 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(stringArray[0]), stringArray[n2]);
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(object2.getName(), (Attribute)object2);
            }
        }
        stringArray = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            if (stringArray != null) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD;
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD);
            }
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FIELD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FIELD);
        }
        if (stringArray != null) {
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD);
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Filename not found");
    }

    private Attribute getContentDispositionAttribute(String ... object) {
        String string = HttpPostMultipartRequestDecoder.cleanString(object[0]);
        object = object[1];
        if (HttpHeaderValues.FILENAME.contentEquals((CharSequence)string)) {
            int n = ((String)object).length() - 1;
            if (n > 0 && ((String)object).charAt(0) == '\"' && ((String)object).charAt(n) == '\"') {
                object = ((String)object).substring(1, n);
            }
        } else if (FILENAME_ENCODED.equals(string)) {
            try {
                string = HttpHeaderValues.FILENAME.toString();
                String[] stringArray = HttpPostMultipartRequestDecoder.cleanString((String)object).split("'", 3);
                object = QueryStringDecoder.decodeComponent(stringArray[2], Charset.forName(stringArray[0]));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(arrayIndexOutOfBoundsException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(unsupportedCharsetException);
            }
        } else {
            object = HttpPostMultipartRequestDecoder.cleanString((String)object);
        }
        return this.factory.createAttribute(this.request, string, (String)object);
    }

    protected InterfaceHttpData getFileUpload(String string) {
        Object object = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        Charset charset = this.charset;
        HttpPostBodyUtil.TransferEncodingMechanism transferEncodingMechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT7;
        if (object != null) {
            try {
                object = object.getValue().toLowerCase();
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            if (((String)object).equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT7.value())) {
                charset = CharsetUtil.US_ASCII;
            } else if (((String)object).equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT8.value())) {
                charset = CharsetUtil.ISO_8859_1;
                transferEncodingMechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT8;
            } else if (((String)object).equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value())) {
                transferEncodingMechanism = HttpPostBodyUtil.TransferEncodingMechanism.BINARY;
            } else {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("TransferEncoding Unknown: " + (String)object);
            }
        }
        if ((object = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET)) != null) {
            try {
                charset = Charset.forName(object.getValue());
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(unsupportedCharsetException);
            }
        }
        if (this.currentFileUpload == null) {
            long l;
            object = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
            Attribute attribute = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
            Object object2 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TYPE);
            Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
            try {
                l = attribute2 != null ? Long.parseLong(attribute2.getValue()) : 0L;
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
            try {
                object2 = object2 != null ? object2.getValue() : "application/octet-stream";
                this.currentFileUpload = this.factory.createFileUpload(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute.getValue()), HttpPostMultipartRequestDecoder.cleanString(object.getValue()), (String)object2, transferEncodingMechanism.value(), charset, l);
            }
            catch (NullPointerException nullPointerException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
        }
        if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, string, this.currentFileUpload)) {
            return null;
        }
        if (this.currentFileUpload.isCompleted()) {
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                this.currentFieldAttributes = null;
            } else {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                this.cleanMixedAttributes();
            }
            object = this.currentFileUpload;
            this.currentFileUpload = null;
            return object;
        }
        return null;
    }

    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData interfaceHttpData : this.bodyListHttpData) {
            if (interfaceHttpData.refCnt() <= 0) continue;
            interfaceHttpData.release();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }

    private void cleanMixedAttributes() {
        this.currentFieldAttributes.remove(HttpHeaderValues.CHARSET);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_LENGTH);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TYPE);
        this.currentFieldAttributes.remove(HttpHeaderValues.FILENAME);
    }

    private static String readLineOptimized(ByteBuf byteBuf, Charset object) {
        int n;
        block7: {
            n = byteBuf.readerIndex();
            ByteBuf byteBuf2 = null;
            if (!byteBuf.isReadable()) break block7;
            ByteBuf byteBuf3 = byteBuf;
            int n2 = HttpPostBodyUtil.findLineBreak(byteBuf3, byteBuf3.readerIndex());
            if (n2 <= 0) {
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            try {
                byteBuf2 = byteBuf.alloc().heapBuffer(n2);
                byteBuf2.writeBytes(byteBuf, n2);
                byte by = byteBuf.readByte();
                n2 = by;
                if (by == 13) {
                    byteBuf.readByte();
                }
                object = byteBuf2.toString((Charset)object);
            }
            catch (Throwable throwable) {
                try {
                    byteBuf2.release();
                    throw throwable;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    byteBuf.readerIndex(n);
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
                }
            }
            byteBuf2.release();
            return object;
        }
        byteBuf.readerIndex(n);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private static String readDelimiterOptimized(ByteBuf byteBuf, String charSequence, Charset object) {
        int n = byteBuf.readerIndex();
        byte[] byArray = ((String)charSequence).getBytes((Charset)object);
        object = byArray;
        int n2 = byArray.length;
        try {
            int n3 = HttpPostBodyUtil.findDelimiter(byteBuf, n, (byte[])object, false);
            if (n3 < 0) {
                byteBuf.readerIndex(n);
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            charSequence = new StringBuilder((String)charSequence);
            byteBuf.readerIndex(n + n3 + n2);
            if (byteBuf.isReadable()) {
                byte by = byteBuf.readByte();
                n3 = by;
                if (by == 13) {
                    byte by2 = byteBuf.readByte();
                    n3 = by2;
                    if (by2 == 10) {
                        return ((StringBuilder)charSequence).toString();
                    }
                    byteBuf.readerIndex(n);
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                }
                if (n3 == 10) {
                    return ((StringBuilder)charSequence).toString();
                }
                if (n3 == 45) {
                    ((StringBuilder)charSequence).append('-');
                    byte by3 = byteBuf.readByte();
                    n3 = by3;
                    if (by3 == 45) {
                        ((StringBuilder)charSequence).append('-');
                        if (byteBuf.isReadable()) {
                            byte by4 = byteBuf.readByte();
                            n3 = by4;
                            if (by4 == 13) {
                                byte by5 = byteBuf.readByte();
                                n3 = by5;
                                if (by5 == 10) {
                                    return ((StringBuilder)charSequence).toString();
                                }
                                byteBuf.readerIndex(n);
                                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                            }
                            if (n3 == 10) {
                                return ((StringBuilder)charSequence).toString();
                            }
                            ByteBuf byteBuf2 = byteBuf;
                            byteBuf2.readerIndex(byteBuf2.readerIndex() - 1);
                            return ((StringBuilder)charSequence).toString();
                        }
                        return ((StringBuilder)charSequence).toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            byteBuf.readerIndex(n);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        byteBuf.readerIndex(n);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private static void rewriteCurrentBuffer(ByteBuf byteBuf, int n) {
        if (n == 0) {
            return;
        }
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.readableBytes();
        if (n3 == n) {
            byteBuf.readerIndex(n2);
            byteBuf.writerIndex(n2);
            return;
        }
        byteBuf.setBytes(n2, byteBuf, n2 + n, n3 - n);
        byteBuf.readerIndex(n2);
        byteBuf.writerIndex(n2 + n3 - n);
    }

    private static boolean loadDataMultipartOptimized(ByteBuf byteBuf, String object, HttpData httpData) {
        if (!byteBuf.isReadable()) {
            return false;
        }
        int n = byteBuf.readerIndex();
        int n2 = HttpPostBodyUtil.findDelimiter(byteBuf, n, (byte[])(object = (Object)((String)object).getBytes(httpData.getCharset())), true);
        if (n2 < 0) {
            int n3 = byteBuf.readableBytes();
            int n4 = n3 - ((Object)object).length - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n2 = HttpPostBodyUtil.findLastLineBreak(byteBuf, n + n4)) < 0 && httpData.definedLength() == httpData.length() + (long)n3 - 1L && byteBuf.getByte(n3 + n - 1) == 13) {
                n4 = 0;
                n2 = n3 - 1;
            }
            if (n2 < 0) {
                ByteBuf byteBuf2 = byteBuf.copy();
                try {
                    httpData.addContent(byteBuf2, false);
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                }
                byteBuf.readerIndex(n);
                byteBuf.writerIndex(n);
                return false;
            }
            if ((n2 += n4) == 0) {
                return false;
            }
            ByteBuf byteBuf3 = byteBuf.copy(n, n2);
            try {
                httpData.addContent(byteBuf3, false);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(byteBuf, n2);
            return false;
        }
        ByteBuf byteBuf4 = byteBuf.copy(n, n2);
        try {
            httpData.addContent(byteBuf4, true);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
        }
        HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(byteBuf, n2);
        return true;
    }

    private static String cleanString(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    stringBuilder.append(' ');
                    continue block4;
                }
                case '\"': {
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString().trim();
    }

    private boolean skipOneLine() {
        if (!this.undecodedChunk.isReadable()) {
            return false;
        }
        byte by = this.undecodedChunk.readByte();
        if (by == 13) {
            if (!this.undecodedChunk.isReadable()) {
                this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                return false;
            }
            by = this.undecodedChunk.readByte();
            if (by == 10) {
                return true;
            }
            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 2);
            return false;
        }
        if (by == 10) {
            return true;
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
        return false;
    }

    private static String[] splitMultipartHeader(String stringArray) {
        int n;
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (n3 = n2 = HttpPostBodyUtil.findNonWhitespace((String)stringArray, 0); n3 < stringArray.length(); ++n3) {
            char c = stringArray.charAt(n3);
            n = c;
            if (c == ':' || Character.isWhitespace((char)n)) break;
        }
        for (n = n3; n < stringArray.length(); ++n) {
            if (stringArray.charAt(n) != ':') continue;
            ++n;
            break;
        }
        n = HttpPostBodyUtil.findNonWhitespace((String)stringArray, n);
        int n4 = HttpPostBodyUtil.findEndOfString((String)stringArray);
        arrayList.add(stringArray.substring(n2, n3));
        String string2 = n >= n4 ? "" : stringArray.substring(n, n4);
        for (String string2 : string2.indexOf(59) >= 0 ? HttpPostMultipartRequestDecoder.splitMultipartHeaderValues(string2) : string2.split(",")) {
            arrayList.add(string2.trim());
        }
        stringArray = new String[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray[n2] = (String)arrayList.get(n2);
        }
        return stringArray;
    }

    private static String[] splitMultipartHeaderValues(String string) {
        ArrayList arrayList = InternalThreadLocalMap.get().arrayList(1);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c != '\"') continue;
                bl = false;
                continue;
            }
            if (c == '\"') {
                bl = true;
                continue;
            }
            if (c != ';') continue;
            arrayList.add(string.substring(n, i));
            n = i + 1;
        }
        arrayList.add(string.substring(n));
        return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    int getCurrentAllocatedCapacity() {
        return this.undecodedChunk.capacity();
    }
}

