/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class WebSocket00FrameDecoder
extends ReplayingDecoder<Void>
implements WebSocketFrameDecoder {
    static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384);
    }

    public WebSocket00FrameDecoder(int n) {
        this.maxFrameSize = n;
    }

    public WebSocket00FrameDecoder(WebSocketDecoderConfig webSocketDecoderConfig) {
        this.maxFrameSize = ((WebSocketDecoderConfig)ObjectUtil.checkNotNull((Object)webSocketDecoderConfig, (String)"decoderConfig")).maxFramePayloadLength();
    }

    protected void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        byte by = byteBuf.readByte();
        object = (by & 0x80) == 128 ? this.decodeBinaryFrame((ChannelHandlerContext)object, by, byteBuf) : this.decodeTextFrame((ChannelHandlerContext)object, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    private WebSocketFrame decodeBinaryFrame(ChannelHandlerContext channelHandlerContext, byte by, ByteBuf byteBuf) {
        byte by2;
        long l = 0L;
        int n = 0;
        do {
            by2 = byteBuf.readByte();
            l <<= 7;
            if ((l |= (long)(by2 & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException("frame length exceeds " + this.maxFrameSize + ": " + l);
            }
            if (++n <= 8) continue;
            throw new TooLongFrameException("frame length field size exceeds 8: " + n);
        } while ((by2 & 0x80) == 128);
        if (by == -1 && l == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame(true, 0, channelHandlerContext.alloc().buffer(0));
        }
        channelHandlerContext = ByteBufUtil.readBytes((ByteBufAllocator)channelHandlerContext.alloc(), (ByteBuf)byteBuf, (int)((int)l));
        return new BinaryWebSocketFrame((ByteBuf)channelHandlerContext);
    }

    private WebSocketFrame decodeTextFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n = byteBuf.readerIndex();
        int n2 = this.actualReadableBytes();
        int n3 = n;
        int n4 = byteBuf.indexOf(n3, n3 + n2, (byte)-1);
        if (n4 == -1) {
            if ((long)n2 > this.maxFrameSize) {
                throw new TooLongFrameException("frame length exceeds " + this.maxFrameSize + ": " + n2);
            }
            return null;
        }
        if ((long)(n = n4 - n) > this.maxFrameSize) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameSize + ": " + n);
        }
        channelHandlerContext = ByteBufUtil.readBytes((ByteBufAllocator)channelHandlerContext.alloc(), (ByteBuf)byteBuf, (int)n);
        byteBuf.skipBytes(1);
        ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
        int n5 = channelHandlerContext2.indexOf(channelHandlerContext2.readerIndex(), channelHandlerContext.writerIndex(), (byte)-1);
        if (n5 >= 0) {
            channelHandlerContext.release();
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame((ByteBuf)channelHandlerContext);
    }
}

